do_compile[nostamp] = "1"

do_compile () {
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${BL33_OUT} \
		           LIBGCC="" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MD_VERIFY=${MD_VERIFY} \
		           HSM_OS_SUPPORT=${HSM_OS_SUPPORT} \
		           MTK_KEDUMP_MINI_SUPPORT=${MTK_KEDUMP_MINI_SUPPORT} \
		           MTK_MRDUMP_SUPPORT=${MTK_MRDUMP_SUPPORT} \
		           MTK_BOOT_REASON_SUPPORT=${MTK_BOOT_REASON_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           MTK_PMIC_CHIP_TYPE=${MTK_PMIC_CHIP_TYPE} \
		           MTK_SUB_PMIC_CHIP_TYPE=${MTK_SUB_PMIC_CHIP_TYPE} \
		           BUILD_LOAD_TYPE=${BUILD_TYPE} \
		           SINGLE_BIN_MODEM_SUPPORT=${SINGLE_BIN_MODEM_SUPPORT} \
		           BOOTDEV_TYPE=${BOOTDEV_TYPE} \
		           ${BL33_PROJECT}
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${BL33_OUT} \
		           LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MD_VERIFY=${MD_VERIFY} \
		           HSM_OS_SUPPORT=${HSM_OS_SUPPORT} \
		           MTK_KEDUMP_MINI_SUPPORT=${MTK_KEDUMP_MINI_SUPPORT} \
		           MTK_MRDUMP_SUPPORT=${MTK_MRDUMP_SUPPORT} \
		           MTK_BOOT_REASON_SUPPORT=${MTK_BOOT_REASON_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           MTK_PMIC_CHIP_TYPE=${MTK_PMIC_CHIP_TYPE} \
		           MTK_SUB_PMIC_CHIP_TYPE=${MTK_SUB_PMIC_CHIP_TYPE} \
		           BUILD_LOAD_TYPE=${BUILD_TYPE} \
		           SINGLE_BIN_MODEM_SUPPORT=${SINGLE_BIN_MODEM_SUPPORT} \
		           BOOTDEV_TYPE=${BOOTDEV_TYPE} \
		           ${BL33_PROJECT}
	fi
	# add filesize check
	start=$(grep -w _start -n ${BL33_OUT}/build-${BL33_PROJECT}/lk.elf.sym.sorted | \
			sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	end=$(grep -w _end -n ${BL33_OUT}/build-${BL33_PROJECT}/lk.elf.sym.sorted | \
		  sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	fs=`echo "obase=16;ibase=16; $end - $start" | bc`
	maxsize=${BL33_MAX_SIZE}
	if [ ${BL33_MAX_SIZE} != "" ] && [[ 0x$fs -gt $maxsize ]]; then
		  bberror "Little kernel image size overflow, please have a check."
	fi
}
