SUMMARY = "BL2-IMAGE"
inherit deploy lk-image hsm-sign-env
LICENSE = "MIT"
LK_OUT = "${WORKDIR}/out"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=411c267670838099ca82e01c7f044a7b"

DEPENDS += "u-boot-mkimage-native bc-native dtc-native"

SRC_URI = "file://gfh file://dev_info file://pbp file://key file://lk_dts file://dummy_img file://fit-lk"
SRC_URI += " file://LICENSE "
WORKONSRC = "${TOPDIR}/../prebuilt/firmware/bl2"

LK_BINARY = "lk.bin"
LK_IMAGE = "bl2.img"
PACKAGE_ARCH = "${MACHINE_ARCH}"
DEPENDS += "libgcc"
GFH_DIR = "${WORKDIR}/gfh"
PBP_DIR = "${WORKDIR}/pbp"
KEY_DIR = "${WORKDIR}/key"
DTS_DIR = "${WORKDIR}/lk_dts"
DUMMY_IMG_DIR="${WORKDIR}/dummy_img"
FIT_IMG_TOOL ?= "uboot-mkimage"

IC_NAME="$(echo ${TARGET_PLATFORM}|tr '[a-z]' '[A-Z]')"
DEV_INFO_HDR_TOOL = "${TOPDIR}/../src/bsp/scatter/scripts/dev-info-hdr-tool.py"


do_configure () {
	:
}
do_genkey () {
	mkdir -p ${LK_OUT}/include
	if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
		mkdir -p ${WORKDIR}/mykeys
		dtc -p 0x3ff ${DTS_DIR}/lk.dts -O dtb -o ${DTS_DIR}/lk.dtb
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key
		${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -F -k ${WORKDIR}/mykeys -K ${DTS_DIR}/lk.dtb -r ${DUMMY_IMG_DIR}/fitImage
		OFF_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep off_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		SIZE_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep size_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		KEYNODE_LEN="`echo "obase=16;ibase=16;${OFF_DT_STRINGS} + ${SIZE_DT_STRINGS}" | bc`"
		python ${WORKDIR}/dev_info/dtb-transfer-array.py ${DTS_DIR}/lk.dtb ${DTS_DIR}/blob.h ${KEYNODE_LEN}
		cp ${DTS_DIR}/blob.h ${LK_OUT}/include/blob.h
		cp ${DTS_DIR}/lk.dtb ${TOPDIR}/lk.dtb
		rm -rf ${WORKDIR}/mykeys
	else
		cp ${DTS_DIR}/tmp_blob.txt ${LK_OUT}/include/blob.h
	fi
}

do_compile[nostamp] = "1"
do_deploy () {
	install -d ${DEPLOYDIR}

	install ${LK_OUT}/build-${LK_PROJECT}/${LK_BINARY} ${DEPLOYDIR}/${LK_BINARY}
	install ${WORKDIR}/${LK_IMAGE} ${DEPLOYDIR}/${LK_IMAGE}
}

addtask deploy before do_build after do_compile
do_compile() {
	echo "no source with images"
	install -d ${LK_OUT}/build-${LK_PROJECT}
	install -m 755 ${WORKONSRC}/${LK_BINARY}  ${LK_OUT}/build-${LK_PROJECT}/${LK_BINARY}
}
do_genheader () {
	if [ "${FIT_LK_IMAGE}" = "yes" ]; then
		gen_lk_fit_header
	else
		gen_lk_gfh_header
	fi
}


addtask genkey before do_compile after do_configure
addtask genheader before do_deploy after do_compile
addtask deploy before do_build after do_compile
