inherit deploy srcprebuilt externalsrc lk-image hsm-sign-env

LICENSE = "MIT"
MTK_SRC = "${TOPDIR}/../src/bsp/lk"
LK_OUT = "${WORKDIR}/out"
LIC_FILES_CHKSUM = "file://${MTK_SRC}/LICENSE;md5=25394d472e4c06f4d61140e88861fb5b"
SRC_URI = "file://gfh file://dev_info file://pbp file://key file://lk_dts file://fit-lk"
#S = "${WORKDIR}"
DEPENDS += "u-boot-mkimage-native bc-native dtc-native"

TOOLCHAIN_PREFIX = "${TARGET_PREFIX}"
EXTERNALSRC = "${MTK_SRC}"
EXTERNALSRC_BUILD = "${MTK_SRC}"
LK_BINARY = "lk.bin"
LK_IMAGE = "bl2.img"
PACKAGE_ARCH = "${MACHINE_ARCH}"
DEPENDS += "libgcc"
GFH_DIR = "${WORKDIR}/gfh"
PBP_DIR = "${WORKDIR}/pbp"
KEY_DIR = "${WORKDIR}/key"
DTS_DIR = "${WORKDIR}/lk_dts"
FIT_IMG_TOOL ?= "uboot-mkimage"

IC_NAME="$(echo ${TARGET_PLATFORM}|tr '[a-z]' '[A-Z]')"
DEV_INFO_HDR_TOOL = "${TOPDIR}/../src/bsp/scatter/scripts/dev-info-hdr-tool.py"


do_configure () {
	:
}

do_genkey () {
	mkdir -p ${LK_OUT}/include
	if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
		mkdir -p ${WORKDIR}/mykeys
		dtc -p 0x3ff ${DTS_DIR}/lk.dts -O dtb -o ${DTS_DIR}/lk.dtb
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key

		echo -n -e \\xde\\xed\\xbe\\xef > ${DTS_DIR}/dummy.bin
		${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ${WORKDIR}/mykeys -K ${DTS_DIR}/lk.dtb -r -f ${DTS_DIR}/dummy.its ${DTS_DIR}/dummyfit.img
		OFF_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep off_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		SIZE_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep size_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		KEYNODE_LEN="`echo "obase=16;ibase=16;${OFF_DT_STRINGS} + ${SIZE_DT_STRINGS}" | bc`"
		python ${WORKDIR}/dev_info/dtb-transfer-array.py ${DTS_DIR}/lk.dtb ${DTS_DIR}/blob.h ${KEYNODE_LEN}
		cp ${DTS_DIR}/blob.h ${LK_OUT}/include/blob.h
		cp ${DTS_DIR}/lk.dtb ${TOPDIR}/lk.dtb
		rm -rf ${WORKDIR}/mykeys
		rm -f ${DTS_DIR}/dummy.bin
		rm -f ${DTS_DIR}/fummyfit.img
	else
		cp ${DTS_DIR}/tmp_blob.txt ${LK_OUT}/include/blob.h
	fi
}

do_compile () {
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${LK_OUT} \
		           LIBGCC="" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           MTK_CLK32K_EXT_REMOVAL_SUPPORT=${MTK_CLK32K_EXT_REMOVAL_SUPPORT} \
		           ${LK_PROJECT}
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${LK_OUT} \
		           LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           MTK_CLK32K_EXT_REMOVAL_SUPPORT=${MTK_CLK32K_EXT_REMOVAL_SUPPORT} \
		           ${LK_PROJECT}
	fi
	# add filesize check
	start=$(grep -w _start -n ${LK_OUT}/build-${LK_PROJECT}/lk.elf.sym.sorted | \
			sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	end=$(grep -w _end -n ${LK_OUT}/build-${LK_PROJECT}/lk.elf.sym.sorted | \
		  sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	fs=`echo "obase=10;ibase=16; $end - $start" | bc`
	maxsize=$(printf '%d' ${LK_MAX_SIZE})

	if [ ${LK_MAX_SIZE} != "" ] && [ $fs -gt $maxsize ]; then
		  bberror "Little kernel image size overflow, please have a check. $fs > $maxsize"
	fi
}

do_buildclean () {
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
			   NOECHO="" \
			   BUILDROOT=${LK_OUT} \
			   LIBGCC="" \
			   CFLAGS="" \
			   DEBUG=0 \
			   ${LK_PROJECT} clean
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
			   NOECHO="" \
			   BUILDROOT=${LK_OUT} \
			   LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
			   CFLAGS="" \
			   DEBUG=0 \
			   ${LK_PROJECT} clean
	fi
}

do_genheader () {
	if [ "${FIT_LK_IMAGE}" = "yes" ]; then
		gen_lk_fit_header
	else
		gen_lk_gfh_header
	fi
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${LK_OUT}/build-${LK_PROJECT}/${LK_BINARY} ${DEPLOYDIR}/${LK_BINARY}
	install ${WORKDIR}/${LK_IMAGE} ${DEPLOYDIR}/${LK_IMAGE}
}

addtask genkey before do_compile after do_configure
addtask genheader before do_deploy after do_compile
addtask deploy before do_build after do_compile

