FILESEXTRAPATHS_append := ":${THISDIR}/files"

SRC_URI_remove = "file://gfh"
SRC_URI += "file://ap_bl2.json"

DEPENDS += "packer-native"

do_compile () {
	if [ "${MT2735_LITE_CONFIG}" = "yes" ]; then
		# Set CCB buffer size to 0 on lite project
		CCCI_FILE="${EXTERNALSRC}/platform/mt2735/drivers/md/ccci_lk_load_img_plat.c"
		sed -i 's/define CCCI_SMEM_SIZE_CCB_DHL/define CCCI_SMEM_SIZE_CCB_DHL (0) \/\//g' ${CCCI_FILE}
		sed -i 's/define CCCI_SMEM_SIZE_RAW_DHL/define CCCI_SMEM_SIZE_RAW_DHL (0) \/\//g' ${CCCI_FILE}

		RAM_FILE="${EXTERNALSRC}/platform/mt2735/include/platform/ram_console_def.h"
		sed -i 's/define RAM_CONSOLE_DRAM_SIZE/define RAM_CONSOLE_DRAM_SIZE (0) \/\//g' ${RAM_FILE}
		sed -i 's/define MINIRDUMP_MEM_SIZE/define MINIRDUMP_MEM_SIZE (0) \/\//g' ${RAM_FILE}
		sed -i 's/define LOG_STORE_MEM_SIZE/define LOG_STORE_MEM_SIZE (0) \/\//g' ${RAM_FILE}
	fi
#Typethree@2023.2.03 modify for TCXO hw version start
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${LK_OUT} \
		           LIBGCC="" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MD_VERIFY_ENABLE=${MD_VERIFY_ENABLE} \
		           HSM_OS_SUPPORT=${HSM_OS_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           CLK32K_EXT_REMOVAL=${CLK32K_EXT_REMOVAL} \
		           MTK_PMIC_CHIP_TYPE=${MTK_PMIC_CHIP_TYPE} \
		           MTK_SUB_PMIC_CHIP_TYPE=${MTK_SUB_PMIC_CHIP_TYPE} \
		           BUILD_LOAD_TYPE=${BUILD_TYPE} \
		           LK_PROG_RPMB_KEY=${LK_PROG_RPMB_KEY} \
		           MTK_CFG_LAST_EMI_BW_DUMP=${MTK_CFG_LAST_EMI_BW_DUMP} \
		           ${LK_PROJECT}
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${LK_OUT} \
		           LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
		           CFLAGS="" \
		           DEBUG=0 \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MD_VERIFY_ENABLE=${MD_VERIFY_ENABLE} \
		           HSM_OS_SUPPORT=${HSM_OS_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           CLK32K_EXT_REMOVAL=${CLK32K_EXT_REMOVAL} \
		           MTK_PMIC_CHIP_TYPE=${MTK_PMIC_CHIP_TYPE} \
		           MTK_SUB_PMIC_CHIP_TYPE=${MTK_SUB_PMIC_CHIP_TYPE} \
		           BUILD_LOAD_TYPE=${BUILD_TYPE} \
		           LK_PROG_RPMB_KEY=${LK_PROG_RPMB_KEY} \
		           MTK_CFG_LAST_EMI_BW_DUMP=${MTK_CFG_LAST_EMI_BW_DUMP} \
		           ${LK_PROJECT}
	fi
#Typethree@2023.2.03 modify for TCXO hw version end
	# filesize check
	end=$(grep -w _end -n ${LK_OUT}/build-${LK_PROJECT}/lk.elf.sym.sorted | \
		sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	end_of_ram=$(grep -w _end_of_ram -n ${LK_OUT}/build-${LK_PROJECT}/lk.elf.sym.sorted | \
		sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	fs=`echo "obase=10;ibase=16; $end_of_ram - $end" | bc`

	if [ $fs -lt 0 ]; then
		bberror "Little kernel image size overflow, please have a check."
	fi
}

do_genheader () {
	${WORKDIR}/recipe-sysroot-native${bindir}/python-native/python2 ${WORKDIR}/recipe-sysroot-native${datadir}/packer/mipack.py -d ${LK_OUT}/build-${LK_PROJECT} -o ${WORKDIR}/${LK_IMAGE} ${WORKDIR}/ap_bl2.json
}
