inherit deploy medmcu-fitimage
inherit staging-copyfile

SUMMARY = "MEDMCU Firmware"
DESCRIPTION = "MEDMCU Firmware"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://${MEDMCU_PREBUILT}/LICENSE;md5=33021e5683364ac70382851bdf2e4dbd"
MEDMCU_PREBUILT = "${TOPDIR}/../prebuilt/firmware/medmcu/${TARGET_PLATFORM}"
MEDMCU_OUT = "${WORKDIR}/out"
MEDMCU_IMAGETYPE = "fitImage"
DEPENDS += "u-boot-mkimage-native"

MEDMCU_PREBUILT_BINARY = "medmcu.img"
MEDMCU_BINARY = "medmcu.img"
MEDMCU_COMPRESS = "none"
do_compile[nostamp] = "1"

python __anonymous () {
    secure_boot_enable = d.getVar('SECURE_BOOT_ENABLE', True)
    if secure_boot_enable == 'yes':
        d.setVar("MEDMCU_BINARY_SELECT", '${MEDMCU_BINARY}')
    else:
        d.setVar("MEDMCU_BINARY_SELECT", '${MEDMCU_BINARY}')
}

do_compile () {
	if [ -s ${MEDMCU_OUT}/${MEDMCU_BINARY} ]; then
    rm ${MEDMCU_OUT}/${MEDMCU_BINARY}
    fi
	
	if [ -s ${TOPDIR}/../build/tmp/deploy/image/auto2735evb-ivt-main/medmcu.img ]; then
    rm ${TOPDIR}/../build/tmp/deploy/image/auto2735evb-ivt-main/medmcu.img
    fi

	mkdir -p ${MEDMCU_OUT}
	cp ${MEDMCU_PREBUILT}/${MEDMCU_BINARY} ${MEDMCU_OUT}/${MEDMCU_BINARY}
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${MEDMCU_OUT}/${MEDMCU_BINARY} ${DEPLOYDIR}/${MEDMCU_BINARY}
}

addtask deploy before do_build after do_compile
