inherit deploy externalsrc

LICENSE = "MediaTekProprietary"
MTK_SRC = "${TOPDIR}/../src/bsp/preloader"
LIC_FILES_CHKSUM = "file://${MTK_SRC}/README;md5=661d538ca8a7b4b17d03d6e90e384ffa"
PRELOADER_OUT = "${WORKDIR}/out"
CROSS_COMPILE = "${TARGET_PREFIX}"
EXTERNALSRC = "${MTK_SRC}"
EXTERNALSRC_BUILD = "${MTK_SRC}"
PACKAGE_ARCH = "${MACHINE_ARCH}"
PRELOADER_BINARY = "preloader_${PRELOADER_PROJECT}.bin"
PRELOADER_IMAGE = "preloader.img"
PRELOADER_NOR_IMAGE = "preloader_nor.img"

do_compile () {
        oe_runmake MTK_PROJECT=${PRELOADER_PROJECT} \
                   PRELOADER_OUT=${PRELOADER_OUT} \
                   CROSS_COMPILE=${CROSS_COMPILE} \
                   PRELOADER_BINARY=${PRELOADER_BINARY} \
                   PRELOADER_PROJECT=${PRELOADER_PROJECT}
        python ${MTK_SRC}/tools/gen-preloader-img.py \
               ${PRELOADER_OUT}/bin/${PRELOADER_BINARY} \
               ${PRELOADER_OUT}/bin/${PRELOADER_IMAGE}
        python ${MTK_SRC}/tools/gen-sf-preloader-img.py \
               ${PRELOADER_OUT}/bin/${PRELOADER_BINARY} \
               ${PRELOADER_OUT}/bin/${PRELOADER_NOR_IMAGE}
}


do_buildclean () {
        oe_runmake MTK_PROJECT=${PRELOADER_PROJECT} \
                   PRELOADER_OUT=${PRELOADER_OUT} \
                   CROSS_COMPILE=${CROSS_COMPILE} \
                   PRELOADER_BINARY=${PRELOADER_BINARY} \
                   PRELOADER_PROJECT=${PRELOADER_PROJECT} clean
}

do_deploy () {
        install -d ${DEPLOYDIR}
        install ${PRELOADER_OUT}/bin/${PRELOADER_BINARY} ${DEPLOYDIR}/${PRELOADER_BINARY}
        ln -nfs ${PRELOADER_BINARY} ${DEPLOYDIR}/preloader.bin
        install ${PRELOADER_OUT}/bin/${PRELOADER_IMAGE} ${DEPLOYDIR}/${PRELOADER_IMAGE}
        install ${PRELOADER_OUT}/bin/${PRELOADER_NOR_IMAGE} ${DEPLOYDIR}/${PRELOADER_NOR_IMAGE}
}

addtask deploy before do_build after do_compile
