inherit deploy spmfw-fitimage
inherit staging-copyfile

SUMMARY = "SPM Firmware"
DESCRIPTION = "SPM Firmware"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://${SPMFW_PREBUILT}/LICENSE;md5=31605e32b2213851d3687355e1ef06f9"
SPMFW_PREBUILT = "${TOPDIR}/../prebuilt/firmware/spmfw/${TARGET_PLATFORM}"
SPMFW_OUT = "${WORKDIR}/out"
SPMFW_IMAGETYPE = "fitImage"
DEPENDS += "u-boot-mkimage-native"

SPMFW_PREBUILT_BINARY = "spmfw.img"
SPMFW_BINARY = "spmfw.img"
SPMFW_RAW_BINARY = "spmfw_raw.img"
SPMFW_SIGNED_BINARY = "spmfw_signed.img"
SPMFW_COMPRESS = "none"
do_compile[nostamp] = "1"

# LOADER ENTRYPOINT, LOADADDRESS
SPMFW_ENTRYPOINT = "0x44600000"
SPMFW_LOADADDRESS = "0x44600000"

run_lz4_compression() {
	dec_size=0
	fsize=$(stat -c "%s" "${SPMFW_OUT}/${1}")
	dec_size=$(expr $dec_size + $fsize)
	lz4 -l -c1 ${SPMFW_OUT}/${1} > ${SPMFW_OUT}/${1}.lz4
	mv -f ${SPMFW_OUT}/${1}.lz4 ${SPMFW_OUT}/${1}
	printf "%08x\n" $dec_size |
	sed 's/\(..\)/\1 /g' | {
		read ch0 ch1 ch2 ch3;
		for ch in $ch3 $ch2 $ch1 $ch0; do
			printf `printf '%s%03o' '\\' 0x$ch` >> ${SPMFW_OUT}/${1};
		done;
	}
}

python __anonymous () {
	secure_boot_enable = d.getVar('SECURE_BOOT_ENABLE', True)
	if secure_boot_enable == 'yes':
		d.setVar("SPMFW_BINARY_SELECT", '${SPMFW_SIGNED_BINARY}')
	else:
		d.setVar("SPMFW_BINARY_SELECT", '${SPMFW_RAW_BINARY}')
}

do_compile () {
	mkdir -p ${SPMFW_OUT}
	cp ${SPMFW_PREBUILT}/${SPMFW_PREBUILT_BINARY} ${SPMFW_OUT}/${SPMFW_BINARY_SELECT}

	# compression method LZ4 support
	if [ "${SPMFW_COMPRESS}" = "lz4" ]; then
		run_lz4_compression ${SPMFW_BINARY_SELECT}
	fi
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${SPMFW_OUT}/${SPMFW_BINARY} ${DEPLOYDIR}/${SPMFW_BINARY}
}

addtask deploy before do_build after do_install