inherit workonsrc
inherit trustzone-build

DESCRIPTION = "OPTEE example"
LICENSE = "BSD-2-Clause & MediaTekProprietary"
TZ_SRC = "${TOPDIR}/../src/bsp/trustzone"
WORKONSRC = "${TZ_SRC}/optee/source/mt2xxx/optee_examples"
WORKONSRC_BUILD = "${TZ_SRC}/optee/source/mt2xxx/optee_examples"
LIC_FILES_CHKSUM = "file://${S}/LICENSE;md5=cd95ab417e23b94f381dafc453d70c30"

DEPENDS = "optee-client optee-os"

OPTEE_CLIENT_EXPORT = "${STAGING_DIR_HOST}${prefix}"
TEEC_EXPORT         = "${STAGING_DIR_HOST}${prefix}"
TA_DEV_KIT_DIR      = "${STAGING_INCDIR}/optee/export-user_ta"

OPTEE_ARCH = "${TEE_ARCH}"
TEE_TOOLCHAIN ?= "${HOST_PREFIX}"

EXTRA_OEMAKE = " TA_DEV_KIT_DIR=${TA_DEV_KIT_DIR} \
                 OPTEE_CLIENT_EXPORT=${OPTEE_CLIENT_EXPORT} \
                 TEEC_EXPORT=${TEEC_EXPORT} \
                 HOST_CROSS_COMPILE=${TEE_TOOLCHAIN} \
                 CROSS_COMPILE_TA=${TEE_TOOLCHAIN} \
                 V=1 \
                 OUTPUT_DIR=${WORKDIR}/out \
               "

do_compile() {
    # Top level makefile doesn't seem to handle parallel make gracefully
    oe_runmake all
}

do_install () {
    install -d ${D}${bindir}/
    install -D -p -m0755 ${WORKDIR}/out/ca/optee_example_* ${D}${bindir}/

    # install path should match the value set in optee-client/tee-supplicant
    # default TEEC_LOAD_PATH is /lib
    mkdir -p ${D}${nonarch_base_libdir}/optee_armtz/
    install -D -p -m0444 ${WORKDIR}/out/ta/*.ta ${D}${nonarch_base_libdir}/optee_armtz/
}

FILES_${PN} += "${nonarch_base_libdir}/optee_armtz/"
