inherit workonsrc
inherit deploy trustzone-image-build
DEPENDS = "python-pycrypto-native"

inherit pythonnative

DESCRIPTION = "OPTEE OS IMAGE"
LICENSE = "MIT"
PLATFORM_TYPE = "${@d.getVar('TARGET_PLATFORM', True)[0:3]+'xxx'}"
OVERRIDES += ":${PLATFORM_TYPE}"
TZ_SRC = "${TOPDIR}/../src/bsp/trustzone"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=411c267670838099ca82e01c7f044a7b"
OPTEEMACHINE = "mediatek"
OPTEEOUTPUTMACHINE = "mediatek"

OPTEE_ARCH = "${TEE_ARCH}"
TEE_TOOLCHAIN ?= "${TARGET_PREFIX}"
DEPENDS += "virtual/${TARGET_PREFIX}gcc"
TEE_OS_RAM_SIZE = "0x1d0000"

do_compile[noexec] = "1"
SRC_URI += " file://LICENSE "

WORKONSRC = "${TOPDIR}/../prebuilt/firmware/trustzone/optee-os"
SRC_URI +="file://${WORKONSRC}/optee-out.tar.gz"





do_install() {
    #install core on boot directory
    install -d ${D}${nonarch_base_libdir}/firmware/

    install -m 644 ${WORKDIR}/out/${OPTEE_ARCH}-plat-${OPTEEOUTPUTMACHINE}/core/*.bin ${D}${nonarch_base_libdir}/firmware/
    #install TA devkit
    install -d ${D}/usr/include/optee/export-user_ta/

    for f in  ${WORKDIR}/out/${OPTEE_ARCH}-plat-${OPTEEOUTPUTMACHINE}/export-ta_${OPTEE_ARCH}/* ; do
        cp -aR  $f  ${D}/usr/include/optee/export-user_ta/
    done
}

do_deploy() {
    install -d ${DEPLOYDIR}/optee
    for f in ${D}${nonarch_base_libdir}/firmware/*; do
        install -m 644 $f ${DEPLOYDIR}/optee/
    done
    install ${DEPLOYDIR}/optee/tee-pager.bin ${TZ_ASSEMBLE_OUT}/${TZ_RAW_BINARY}
    install ${DEPLOYDIR}/optee/tee-pager.bin ${TZ_ASSEMBLE_OUT}/${TRUSTEDOS_RAW_BINARY}
    install ${DEPLOYDIR}/optee/tee-pager.bin ${TZ_ASSEMBLE_OUT}/${TRUSTEDOS_SIGNED_BINARY}
}

addtask deploy before do_build after do_install

FILES_${PN} = "${nonarch_base_libdir}/firmware/"
FILES_${PN}-dev = "/usr/include/optee"

INSANE_SKIP_${PN}-dev = "staticdev"
