inherit workonsrc
inherit deploy
inherit optee-build
DEPENDS = "python-pycrypto-native"

inherit pythonnative

DESCRIPTION = "OPTEE TESTSUITE"
LICENSE = "BSD-2-Clause & GPL-2.0"
PLATFORM_TYPE = "${@d.getVar('TARGET_PLATFORM', True)[0:3]+'xxx'}"
OVERRIDES_append = ":${PLATFORM_TYPE}"
TZ_SRC = "${TOPDIR}/../src/bsp/trustzone"
WORKONSRC = "${TZ_SRC}/optee/3.2.0/source/optee_test"
WORKONSRC_mt2xxx = "${TZ_SRC}/optee/optee_test/mt2xxx"
WORKONSRC_BUILD = "${TZ_SRC}/optee/3.2.0/source/optee_test"
WORKONSRC_BUILD_mt2xxx = "${TZ_SRC}/optee/optee_test/mt2xxx"
LIC_FILES_CHKSUM = "file://${S}/LICENSE.md;md5=daa2bcccc666345ab8940aab1315a4fa"
DEPENDS += "optee-client openssl"
DEPENDS_append_mt2xxx = " optee-os "
DEPENDS_append_mt8xxx = " lib64-optee-os "
OPTEE_CLIENT_EXPORT = "${STAGING_DIR_HOST}${prefix}"
OPTEE_OPENSSL_EXPORT = "${STAGING_INCDIR}"
TEEC_EXPORT         = "${STAGING_DIR_HOST}${prefix}"
TA_DEV_KIT_DIR_mt2xxx = "${STAGING_INCDIR}/optee/export-user_ta"

OPTEE_ARCH = "${TEE_ARCH}"
TEE_TOOLCHAIN_mt2xxx = "${TARGET_PREFIX}"
DEPENDS += "virtual/${TARGET_PREFIX}gcc"

EXTRA_OEMAKE = " TA_DEV_KIT_DIR=${TA_DEV_KIT_DIR} \
                 OPTEE_CLIENT_EXPORT=${OPTEE_CLIENT_EXPORT} \
                 OPTEE_OPENSSL_EXPORT=${OPTEE_OPENSSL_EXPORT} \
                 TEEC_EXPORT=${TEEC_EXPORT} \
                 CROSS_COMPILE_HOST=${TARGET_PREFIX} \
                 CROSS_COMPILE_TA=${TEE_TOOLCHAIN} \
                 V=1 \
                 O=${WORKDIR}/out \
                 COMPILE_NS_USER=32 \
               "

do_compile() {
    # Top level makefile doesn't seem to handle parallel make gracefully
if ${@bb.utils.contains('PLATFORM_TYPE','mt2xxx','false','true',d)}; then
	export LD_LIBRARY_PATH=${OPTEE_LIB64}:${LD_LIBRARY_PATH}
	export PATH=${OPTEE_BULID_SA}:${PATH}
fi
    oe_runmake xtest
    oe_runmake ta
}

do_install () {
    install -D -p -m0755 ${WORKDIR}/out/xtest/xtest ${D}${bindir}/xtest

    # install path should match the value set in optee-client/tee-supplicant
    # default TEEC_LOAD_PATH is /lib
    mkdir -p ${D}${nonarch_base_libdir}/optee_armtz/
    install -D -p -m0444 ${WORKDIR}/out/ta/*/*.ta ${D}${nonarch_base_libdir}/optee_armtz/
}

FILES_${PN} += "${nonarch_base_libdir}/optee_armtz/"

# Imports machine specific configs from staging to build
PACKAGE_ARCH = "${MACHINE_ARCH}"
