#IMAGE_INSTALL = "packagegroup-core-boot ${CORE_IMAGE_EXTRA_INSTALL}"

IMAGE_LINGUAS = " "

LICENSE = "MIT"

IMAGE_ROOTFS_SIZE ?= "1024"

STATE_DIR_CONTENT = "${IMAGE_ROOTFS}/home ${IMAGE_ROOTFS}/usr/lib/tmpfiles.d ${IMAGE_ROOTFS}/etc/firmware ${IMAGE_ROOTFS}/etc/syslog ${IMAGE_ROOTFS}/mnt ${IMAGE_ROOTFS}/srv   ${IMAGE_ROOTFS}/usr/local ${IMAGE_ROOTFS}/system/etc/firmware ${IMAGE_ROOTFS}/custom/etc/firmware ${IMAGE_ROOTFS}/var/lib ${IMAGE_ROOTFS}/data ${IMAGE_ROOTFS}/system/etc/tele ${IMAGE_ROOTFS}/system/etc/adr ${IMAGE_ROOTFS}/system/etc/agps ${IMAGE_ROOTFS}/system/etc/security ${IMAGE_ROOTFS}/etc/adr ${IMAGE_ROOTFS}/etc/gnss ${IMAGE_ROOTFS}/usr/share/gps ${IMAGE_ROOTFS}/etc/thermal ${IMAGE_ROOTFS}/etc/config"

STATE_DIR_IMAGE_SIZE ?= "14336"
VENDOR_PROP_FILE = "${IMAGE_ROOTFS}/vendor/build.prop"
DEPENDS = "lynq-rootfs"
inherit core-image-tiny
#inherit create-link
#inherit create-nfsb
#inherit depends-systemd
inherit mkstatepart
inherit mkuserdataimg
inherit mksncfg
#you.chen@2022-07-11 for change partition begin
DEPENDS += "init-oem"
inherit mkoemdataimg
inherit mkoemappimg
#you.chen@2022-07-11 for change partition end
inherit create-sparse-image
inherit staging-copyfile
inherit avb_sign_image
inherit make_ota_full-package
inherit mknvram
inherit mkmcf

EXTRA_IMAGECMD_ext4 := "-i 4096 -b 4096"

#Typethree add for kernel failure signed by avb when generate sdk start 2022/7/18
do_rootfs[depends] += "mtk-core-image-tiny:do_image_complete"
do_rootfs[depends] += "linux-mtk-extension:do_deploy"
#Typethree add for kernel failure signed by avb when generate sdk end 2022/7/18

IMAGE_FEATURES_append = " \
    ${@bb.utils.contains("SECURE_BOOT_ENABLE", "yes", "read-only-rootfs", "", d)} \
"

# BAD_RECOMMENDATIONS = "udev-hwdb shared-mime-info kbd kbd-consolefonts kbd-keymaps"

CORE_IMAGE_EXTRA_INSTALL += " \
"
IMAGE_INSTALL_append = " \
	${@bb.utils.contains("TEE_SUPPORT_SRC", "yes", "optee-client", "", d)} \
	${@bb.utils.contains("TEE_SUPPORT_SRC", "yes", "optee-test", "", d)} \
	${@bb.utils.contains("TEE_SUPPORT_SRC", "yes", "optee-example", "", d)} \
	${@bb.utils.contains("TEE_SUPPORT_SRC", "yes", "optee-services", "", d)} \
	${@bb.utils.contains("TEE_SUPPORT_SRC", "yes", "security-storage-demo", "", d)} \
    ${@bb.utils.contains("RNDIS_ENABLE", "yes", "lynq-rndis-service", "", d)} \
	hello-world\
	shadow\
	procps \
	dtbo \
	network-demo \
	call-demo \
	sms-demo \
        sim-demo \
        data-demo \
        util-linux \
        lynq-fota-demo \
        lynq-thermal-demo \
	wakelock-demo \
	rtp-demo \
	media-demo \
    autosuspend-client-demo \
	e-call-demo \
	lynq-cv2x-demo \
         wifi6-demo \
         setalarm   \
"

do_populate_sdk_prepend() {
    d.appendVar("PACKAGE_EXCLUDE", "lib32-libcxx")
    bb.note("building sdk, PACKAGE_EXCLUDE = %s" % d.getVar("PACKAGE_EXCLUDE"))
}

do_modem_align_4kb() {
    if [ -f "${DEPLOY_DIR}/images/${MACHINE}/md1img.img" ]; then
        python ${DEPLOY_DIR_IMAGE}/align_4kb.py ${DEPLOY_DIR_IMAGE}/md1img.img
    fi
    if [ -f "${DEPLOY_DIR}/images/${MACHINE}/md1dsp.img" ]; then
        python ${DEPLOY_DIR_IMAGE}/align_4kb.py ${DEPLOY_DIR_IMAGE}/md1dsp.img
    fi
}

do_squashfs_gen_image(){
        if ${@bb.utils.contains('IMAGE_FSTYPES','squashfs','true','false',d)}; then
                simg2img ${DEPLOY_DIR_IMAGE}/system.img ${DEPLOY_DIR_IMAGE}/system_unsparse.img
                echo \[squashfs\] > ubinize.cfg
                echo mode=ubi >> ubinize.cfg
                echo image=${DEPLOY_DIR_IMAGE}/system_unsparse.img >> ubinize.cfg
                echo vol_id=0 >> ubinize.cfg
                echo vol_type=dynamic >> ubinize.cfg
                echo vol_name=rootfs >> ubinize.cfg
                ubinize -o ${DEPLOY_DIR_IMAGE}/system.ubi ${UBINIZE_ARGS} ubinize.cfg
                img2simg ${DEPLOY_DIR_IMAGE}/system.ubi ${DEPLOY_DIR_IMAGE}/system.img
                mv ubinize.cfg ${DEPLOY_DIR_IMAGE}/
        fi
}


addtask squashfs_gen_image after do_avb_sign_img before do_build
addtask make_otafull_package after do_squashfs_gen_image before do_build

gen_feature_property() {
       if [ ! -d "${IMAGE_ROOTFS}/vendor" ]; then
               mkdir ${IMAGE_ROOTFS}/vendor
       fi

       echo "" >> ${VENDOR_PROP_FILE}
       echo "###### FO <=> property mapping start ######" >> ${VENDOR_PROP_FILE}

       echo "ro.build.type=${BUILD_TYPE}" >> ${VENDOR_PROP_FILE}

       echo "ro.hardware=${TARGET_PLATFORM}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.board=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.device=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.model=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.name=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.vendor.device=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.vendor.model=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}
       echo "ro.product.vendor.name=${MTK_PROJECT}" >> ${VENDOR_PROP_FILE}

       echo "###### FO <=> property mapping end ######" >> ${VENDOR_PROP_FILE}
       echo "" >> ${VENDOR_PROP_FILE}
       cp -af ${VENDOR_PROP_FILE} ${DEPLOY_DIR_IMAGE}/

       mkdir ${IMAGE_ROOTFS}/sdcard
       echo "${NATA_SERIAL_NUMBER}" >> ${IMAGE_ROOTFS}/sdcard/nata_serial.txt
}
#ROOTFS_POSTPROCESS_COMMAND += " gen_feature_property;"
mk_lynq_base_part_rootfs_pre() {
   # install -d ${IMAGE_ROOTFS}/protect_f
   #echo "${TOPDIR}"
   . ${TOPDIR}/rootbase.sh
   #echo "${ROOTFS_BASE}"   
   cp -af ${ROOTFS_BASE}/* ${IMAGE_ROOTFS}/
   #you.chen@2023-06-08 for change partition begin
   install -d ${IMAGE_ROOTFS}/db
   install -d ${IMAGE_ROOTFS}/oemapp
   install -d ${IMAGE_ROOTFS}/oemdata
   #you.chen@2023-06-08 for change partition end

   echo "copy ok----\n"
}

ROOTFS_PREPROCESS_COMMAND += "mk_lynq_base_part_rootfs_pre;"

#you.chen@2023-06-08 for change partition begin
mk_oem_init_part_rootfs_post() {
    cp ${STAGING_DIR_HOST}/${datadir}/init/* ${IMAGE_ROOTFS}/${datadir}/init/
    rm ${IMAGE_ROOTFS}/lib/systemd/system/sound.target.wants/alsa-restore.service
}

ROOTFS_POSTPROCESS_COMMAND += "mk_oem_init_part_rootfs_post;"
#you.chen@2023-06-08 for change partition end
addtask modem_align_4kb after do_image_complete before do_build
