#Basic Configuration
DESCRIPTION = "Initial settting"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://init_network"
SRC_URI += "file://init_mount"
SRC_URI += "file://init_speech"
SRC_URI += "file://init_mount_nand"
SRC_URI += "file://usb_switch"
SRC_URI += "file://init_network.service"
SRC_URI += "file://init_mount.service"
SRC_URI += "file://nvram_daemon.service"
SRC_URI += "file://ccci_fsd.service"
SRC_URI += "file://ccci_mdinit.service"
SRC_URI += "file://speech_daemon.service"
SRC_URI += "file://meta_tst.service"
SRC_URI += "file://emdlogger1.service"
SRC_URI += "file://thermal_core.service"
SRC_URI += "${@bb.utils.contains('MTK_SMT_BUILD', 'yes', ' file://meta_tst_tmp', ' file://meta_tst', d)}"
SRC_URI += "${@bb.utils.contains('BUILD_TYPE', 'user', ' ', ' file://init_atci', d)}"
SRC_URI += "${@bb.utils.contains('BUILD_TYPE', 'user', ' ', ' file://init_atci.service', d)}"
SRC_URI += "file://agps.service"
SRC_URI += "file://init_usb"
SRC_URI += "file://init_usb.service"
SRC_URI += "file://smp.sh"
#xf.li 2022.11.17 modify for userdata recover start
SRC_URI += "file://lynq_data_recover"
SRC_URI += "file://lynq_ubi1_wmtd"
SRC_URI += "file://lynq_data_recover.service"
SRC_URI += "file://lynq_ubi1_wmtd.service"
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 delete for Slow loading of ETS port start
#SRC_URI += "file://smp.rules"

#DEPENDS+= "udev"
#dongyu@2022.7.15 delete for Slow loading of ETS port end

#dongyu@2022.7.15 abb for Slow loading of ETS port start
SRC_URI += "file://init_smp.service"
#dongyu@2022.7.15 add for Slow loading of ETS port end

S = "${WORKDIR}"

#Skip strip check in QA test
INSANE_SKIP_${PN} += "already-stripped"

#dongyu@2022.7.15 delete (/etc/udev/rules.d/smp.rules)for Slow loading of ETS port start
#xf.li 2022.11.17 modify for userdata recover start
FILES_${PN} = "${datadir}/init/init_network \
               ${datadir}/init/init_mount \
               ${datadir}/init/usb_switch \
               ${datadir}/init/meta_tst \
               ${datadir}/init/init_speech \
               ${datadir}/init/init_usb \
               /oemdata \
               /oemapp \
               ${@bb.utils.contains('BOOTDEV_TYPE', 'nand',  ' ${datadir}/init/init_mmc', ' ', d)} \
               ${datadir}/init/smp.sh \
               ${datadir}/init/lynq_data_recover \
               ${datadir}/init/lynq_ubi1_wmtd \
               ${@bb.utils.contains('BUILD_TYPE', 'user', ' ', ' ${datadir}/init/init_atci', d)}"
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 delete (/etc/udev/rules.d/smp.rules)for Slow loading of ETS port end

inherit systemd

#dongyu@2022.7.15 abb (init_smp.service) for Slow loading of ETS port start
#xf.li 2022.11.17 modify for userdata recover start
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "init_network.service \
                         init_mount.service \
                         nvram_daemon.service \
                         ccci_fsd.service \
                         ccci_mdinit.service \
                         speech_daemon.service \
                         meta_tst.service \
                         emdlogger1.service \
                         thermal_core.service \
                         agps.service \
                         init_usb.service \
			 init_smp.service \
			 lynq_ubi1_wmtd.service \
			 lynq_data_recover.service \
                         ${@bb.utils.contains('BUILD_TYPE', 'user', ' ', 'init_atci.service', d)}"
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 add (init_smp.service) for Slow loading of ETS port end

#dongyu@2022.7.15 abb (${systemd_unitdir}/system/init_smp.service) for Slow loading of ETS port start
#xf.li 2022.11.17 modify for userdata recover start
FILES_${PN} += "${systemd_unitdir}/system/init_network.service \
                ${systemd_unitdir}/system/init_mount.service \
                ${systemd_unitdir}/system/nvram_daemon.service \
                ${systemd_unitdir}/system/ccci_fsd.service \
                ${systemd_unitdir}/system/ccci_mdinit.service \
                ${systemd_unitdir}/system/speech_daemon.service \
                ${systemd_unitdir}/system/meta_tst.service \
                ${systemd_unitdir}/system/emdlogger1.service \
                ${systemd_unitdir}/system/thermal_core.service \
                ${systemd_unitdir}/system/agps.service \
                ${systemd_unitdir}/system/init_usb.service \
		${systemd_unitdir}/system/init_smp.service \
		${systemd_unitdir}/system/lynq_ubi1_wmtd.service \
		${systemd_unitdir}/system/lynq_data_recover.service \
                ${@bb.utils.contains('BUILD_TYPE', 'user', ' ', ' ${systemd_unitdir}/system/init_atci.service', d)}"
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 add (${systemd_unitdir}/system/init_smp.service) for Slow loading of ETS port end

do_install_append() {
    install -d ${D}${datadir}/init
    install -m 0755 init_network ${D}${datadir}/init/init_network
    install -m 0755 usb_switch ${D}${datadir}/init/usb_switch
    install -m 0755 init_speech ${D}${datadir}/init/init_speech
    install -m 0755 init_usb ${D}${datadir}/init/init_usb
    install -m 0755 smp.sh ${D}${datadir}/init/smp.sh
#xf.li 2022.11.17 modify for userdata recover start
    install -m 0755 lynq_data_recover ${D}${datadir}/init/lynq_data_recover
    install -m 0755 lynq_ubi1_wmtd ${D}${datadir}/init/lynq_ubi1_wmtd
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 delete for Slow loading of ETS port start
    #install -d ${D}/etc/udev/rules.d/
    #install -m 0755 smp.rules ${D}/etc/udev/rules.d/smp.rules
#dongyu@2022.7.15 delete for Slow loading of ETS port end

    if [ "${MTK_SMT_BUILD}" = "yes" ]; then
        install -m 0755 meta_tst_tmp ${D}${datadir}/init/meta_tst
    else
        install -m 0755 meta_tst ${D}${datadir}/init/meta_tst
    fi

    if [ "${BOOTDEV_TYPE}" = "nand" ]; then
        install -m 0755 init_mount_nand ${D}${datadir}/init/init_mount
    else
        install -m 0755 init_mount ${D}${datadir}/init/init_mount
    fi

    if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
        install -d ${D}${systemd_unitdir}/system/
        install -m 0644 init_network.service ${D}${systemd_unitdir}/system
        install -m 0644 init_mount.service ${D}${systemd_unitdir}/system
        install -m 0644 nvram_daemon.service ${D}${systemd_unitdir}/system
        install -m 0644 ccci_fsd.service ${D}${systemd_unitdir}/system
        install -m 0644 ccci_mdinit.service ${D}${systemd_unitdir}/system
        install -m 0644 speech_daemon.service ${D}${systemd_unitdir}/system
        install -m 0644 meta_tst.service ${D}${systemd_unitdir}/system
        install -m 0644 emdlogger1.service ${D}${systemd_unitdir}/system
        install -m 0644 thermal_core.service ${D}${systemd_unitdir}/system
        install -m 0644 agps.service ${D}${systemd_unitdir}/system
        install -m 0644 init_usb.service ${D}${systemd_unitdir}/system
#xf.li 2022.11.17 modify for userdata recover start
        install -m 0644 lynq_data_recover.service ${D}${systemd_unitdir}/system
        install -m 0644 lynq_ubi1_wmtd.service ${D}${systemd_unitdir}/system
#xf.li 2022.11.17 modify for userdata recover end
#dongyu@2022.7.15 abb for Slow loading of ETS port start
	install -m 0644 init_smp.service ${D}${systemd_unitdir}/system
#dongyu@2022.7.15 add for Slow loading of ETS port end
         if [ "${BUILD_TYPE}" = "eng" ]; then
            install -m 0644 init_atci.service ${D}${systemd_unitdir}/system
        fi
    fi

    if [ "${BUILD_TYPE}" = "eng" ]; then
        install -m 0755 init_atci ${D}${datadir}/init/init_atci
    fi
}
