#Basic Configuration
DESCRIPTION = "Initial settting"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://init_mount"
SRC_URI += "file://init_mount_nand"
SRC_URI += "file://wifi_network"
SRC_URI += "${@bb.utils.contains('BOOTDEV_TYPE', 'nand',  'file://init_mmc', ' ', d)}"

S = "${WORKDIR}"

#Skip strip check in QA test
INSANE_SKIP_${PN} += "already-stripped"

FILES_${PN} = "${datadir}/init/init_mount \
               ${datadir}/wg870/wifi_network \
               ${@bb.utils.contains('BOOTDEV_TYPE', 'nand',  ' ${datadir}/init/init_mmc', ' ', d)} \
               "

do_install_append() {
    install -d ${D}${datadir}/init
    install -d ${D}${datadir}/wg870
    install -m 0644 wifi_network ${D}${datadir}/wg870/wifi_network 
    if [ "${BOOTDEV_TYPE}" = "nand" ]; then
        install -m 0755 init_mount_nand ${D}${datadir}/init/init_mount
    	install -m 0755 init_mmc ${D}${datadir}/init/init_mmc
    else
        install -m 0755 init_mount ${D}${datadir}/init/init_mount
    fi
}
