SUMMARY = "Lynq RootFS for T800 series"
DESCRIPTION = "Contains basic root files for services"
LICENSE = "MIT"
S = "${WORKDIR}/rootfs"
#LICENSE = "GPLv2+ & (GPLv2 | GPLv3)"
# License files went missing in 010, when 011 is released add LICENSES/* back
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=8b0de5cacd563a6727aab4ef51b219d5"
export ROOTFS_BASE = "${S}"

#DEPENDS = "libusb1 virtual/libiconv udev"
WORKONSRC = "${TOPDIR}/../prebuilt/firmware/rootfs"
SRC_URI = "file://${WORKONSRC}/lynq_rootfs_1.1.tar.gz \
           file://LICENSE \
          "
SRC_URI[md5sum] = "fd3b6d9bd6b92f7fd2b7c896b5760978 "
SRC_URI[sha256sum] = "64d46225606fd65a7333889d9bf6b69647b83e6545e06c48990b37626cfcb270"
do_compile[noexec] = "1"

inherit deploy
mk_lynq_base_part_rootfs_pre() {
   # install -d ${IMAGE_ROOTFS}/protect_f
sdfd
   export BASE_ROOTFS=${S}
   #cp -af ${S}/* ${IMAGE_ROOTFS}/
}

ROOTFS_PREPROCESS_COMMAND += "mk_lynq_base_part_rootfs_pre;"

do_install() {
    echo "export ROOTFS_BASE=${S}" > ${TOPDIR}/rootbase.sh
    chmod a+x ${TOPDIR}/rootbase.sh
}
#ALTERNATIVE_${PN} = "lsusb"
#ALTERNATIVE_PRIORITY = "100"

# The binaries are mostly GPLv2+ apart from lsusb.py which is GPLv2 or v3.
#LICENSE_${PN} = "GPLv2+"
#LICENSE_${PN}-python = "GPLv2 | GPLv3"

#RRECOMMENDS_${PN} = "udev-hwdb"

#PACKAGE_BEFORE_PN =+ "${PN}-python"
#FILES_${PN}-python += "${bindir}/lsusb.py"
#RDEPENDS_${PN}-python = "python3-core"
