/************************************************************/
/* This is a autosuspend sample program for  Linux          */

/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <dlfcn.h>
#include <time.h>

#define LOG_TAG "AUTOSUSPEND-CLIENT-DEMO"

#define SERVER_PATH "/tmp/autosuspend.server"
// #define CLIENT_PATH "/tmp/autosuspend.client"
// #define DATA "disable"

void *dlHandle_network;

int (*lynq_query_registration_state)(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam,int *errorCode);
int (*lynq_network_init)(int utoken);

void *dlHandle_autosuspend;

int (*lynq_autosleep_enable)(void);
int (*lynq_autosleep_disable)(void);
int (*lynq_wait_wakeup_event)(long *, long *);

void init_autosuspend_func()
{
    const char *lynqLibPath_Autosuspend = "/lib64/libautosuspend.so";
    dlHandle_autosuspend = dlopen(lynqLibPath_Autosuspend, RTLD_NOW);
    if (dlHandle_autosuspend == NULL) 
    {
        printf("dlopen lynqLibPath_Autosuspend failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }

    lynq_autosleep_enable = (int(*)(void))dlsym(dlHandle_autosuspend, "lynq_autosleep_enable");
    if (lynq_autosleep_enable == NULL) {
        printf("libautosleep_enable not defined or exported in %s", lynqLibPath_Autosuspend);
        exit(EXIT_FAILURE);
    }

    lynq_autosleep_disable = (int(*)(void))dlsym(dlHandle_autosuspend, "lynq_autosleep_disable");
    if (lynq_autosleep_disable == NULL) {
        printf("libautosleep_disable not defined or exported in %s", lynqLibPath_Autosuspend);
	}
    lynq_wait_wakeup_event = (int(*)(long *, long * ))dlsym(dlHandle_autosuspend, "lynq_wait_wakeup_event");
    if (lynq_wait_wakeup_event == NULL) {
        printf("lynq_wait_wakeup_event not defined or exported in %s", lynqLibPath_Autosuspend);
        exit(EXIT_FAILURE);
    }

    dlerror(); // Clear any previous dlerror
    return;            
}

void init_network_func()
{
    int res;
    const char *lynqLibPath_Network = "/lib64/liblynq-network.so";
    dlHandle_network = dlopen(lynqLibPath_Network, RTLD_NOW);
    if (dlHandle_network == NULL) 
    {
        printf("dlopen lynqLibPath_Network failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }

    lynq_query_registration_state = (int(*)(const char*,int*,int*,char *,char *,int *,int *,int *))dlsym(dlHandle_network, "lynq_query_registration_state");
    if (lynq_query_registration_state == NULL) {
        printf("lynq_query_registration_state not defined or exported in %s", lynqLibPath_Network);
        exit(EXIT_FAILURE);
    }

    lynq_network_init = (int(*)(int))dlsym(dlHandle_network, "lynq_network_init");
    if (lynq_network_init == NULL) {
        printf("lynq_network_init not defined or exported in %s", lynqLibPath_Network);
        exit(EXIT_FAILURE);
    }

    printf("start lynq_network_init\n");
    res = lynq_network_init(2);
    // sleep(10);

    if(res == 0)
    {
        printf("Run lynq_network_init\n");
    }else{
        printf("lynq_network_init error\n");
        exit(EXIT_FAILURE);
    }       

    dlerror(); // Clear any previous dlerror
    return;            
}

int getregState()
{
    int regState;
    int imsRegState;
    // char *LAC = (char *)malloc(128);
    // char *CID = (char *)malloc(128);
    char LAC[128],CID[128];
    int netType;
    int radioTechFam;
    regState = imsRegState = netType = radioTechFam = 0;
    int errorCode;
    errorCode = -1;
  
    if(lynq_query_registration_state("VOICE",&regState,&imsRegState,LAC,CID,&netType,&radioTechFam,&errorCode) != 0)
    {
        printf("lynq_query_registration_state fail. \n");
        // sleep(1);
        return -1;
    }
    if(regState == 0 || regState == 2 || regState == 3 || regState == 4)
    {
        printf("regState: %d is not OK yet, try again. \n",regState);
        // sleep(1);
        return -1;
    }
    else
    {
        printf("regState: %d is OK.\n",regState);
    }
    return 0;
}

int main(int argc,char** argv){


    if (argc != 3)
    {
        printf("wrong input format.\n");
        return -1;
    }



    if (strcmp(argv[2],"0") == 0)
    {
        printf("autosleep : disable.\n");
        init_autosuspend_func();
        if(lynq_autosleep_disable() < 0)
        {
            printf("lynq_autosleep_disable fail.\n");
            return -1;
        }
        
    }
    else if (strcmp(argv[2],"1") == 0)
    {
        int count = 0;
        printf("autosleep : enable.\n");
        init_autosuspend_func();
        init_network_func();
        while(getregState() != 0) //when modem is normal in cell registerd, autosuspend could be enable
        {
            printf("regstate is not OK, count = %d\n",count);
            sleep(5);
            count++;
            if(count == 4)
                return -1;
        }

        if(lynq_autosleep_enable() < 0)
        {
            printf("lynq_autosleep_enable fail.\n");
            return -1;
        }

    }
    else
    {
        printf("wrong input format.\n");
        return -1;
    }
	
    if (strcmp(argv[1],"-q") == 0)
    {
        printf("No need to get feedback.\n");
        return 0;
    }
    else if(strcmp(argv[1],"-f") == 0)
    {
        printf("start to get feedback.\n");
    }
    

    long sleep_start_time = 0;
	long wakeup_time = 0;
    while (1)
    {   
        
        
        if(lynq_wait_wakeup_event(&sleep_start_time,&wakeup_time) == -1)
        {
            printf("lynq_wait_wakeup_event fail.\n");
            sleep(5);
            continue;
        }

        printf("@@@@@@@@@@@@@system sleep_start timestamps : %ld ms\n",sleep_start_time);
        printf("@@@@@@@@@@@@@@@@system wakeup timestamps : %ld ms\n",wakeup_time);

        // sleep(10);
    }
    


    
    return 0;
}