#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pthread.h>
#include <unistd.h>
#include <dlfcn.h>
//#include <libcall/lynq_call.h>//引用LYNQ call 头文件
//#include <liblog/lynq_deflog.h>//引用LYNQ log 头文件
#undef LOG_TAG
#define LOG_TAG "CALL_DEMO"

#define MAX_IP_LENGTH 128
#define MAX_VLAN_INFO_LENGTH 128


//static pthread_mutex_t s_urc_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
//static pthread_cond_t s_urc_call_state_change_cond = PTHREAD_COND_INITIALIZER;

typedef enum{
    AUDIO_MODE_CODEC = 0,     /* Codec */
    AUDIO_MODE_RTP = 1,      /* RTP */       
}LYNQ_Audio_Mode;

typedef enum{
    RTP_CLIENT = 0,     
    RTP_SERVER =1,
    RTP_MODE_MAX
}LYNQ_Rtp_Mode;

void *dlHandle_call;
void *dlHandle_log;

int (*lynq_init_call)(int);
int (*lynq_deinit_call)(void);
int (*lynq_call)(int *handle,char addr[]);
int (*lynq_call_answer)(void);
int (*lynq_call_hungup)(int *handle);
int (*lynq_call_hungup_all)(void);
int (*lynq_wait_incoming_call)(int *handle);
int (*lynq_set_auto_answercall)(const int mode);
int (*lynq_set_DTMF)(const char callnum);
int (*lynq_get_mute_mic)(int *status);
int (*lynq_set_mute_mic)(const int enable);
int (*lynq_get_speech_volume)(int *volume);
int (*lynq_set_speech_volume)(const int volume);
int (*lynq_get_current_call_state)(int *handle,int *call_state,int *toa,int *direction,char addr[]);

void set_rtp(int argc, char const *argv[]);

//以下示例默认为所有API 执行都成功的情况下，依次执行后续API。
int main(int argc, char const *argv[])
{
    int ret = 0;
    int handle = -1;//handle某一通电话的唯一标识，初始化为-1.
    int status =-1;
    const char * addr = argv[1];
    const char *lynqLibPath_Call = "/lib64/liblynq-call.so";
    const char *lynqLibPath_Log = "/lib64/liblynq-log.so";

    dlHandle_call = dlopen(lynqLibPath_Call, RTLD_NOW);
    if (dlHandle_call == NULL) 
    {
        printf("dlopen dlHandle_call failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynqLibPath_Log, RTLD_NOW);
    if (dlHandle_log == NULL) 
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    lynq_init_call = (int(*)(int))dlsym(dlHandle_call, "lynq_init_call");
    if (lynq_init_call == NULL) {
        printf("lynq_init_call not defined or exported in %s", lynqLibPath_Call);
        exit(EXIT_FAILURE);
    }
    dlerror(); // Clear any previous dlerror
    printf("--------->[%s,%d] start",__FUNCTION__,__LINE__);
    ret = lynq_init_call(2022);   //初始化电话业务,调用电话API之前必须初始化电话业务。
    sleep(1); //等待初始化结束。

    set_rtp(argc,argv);

    printf("Dial a call!!! addr is %s\n", addr);
    lynq_call = (int(*)(int *handle,char addr[]))dlsym(dlHandle_call,"lynq_call");
    if(NULL != lynq_call)
    {
        ret = lynq_call(&handle,(char *)addr);
        if(ret == 0)
        {
            printf("dial a call success\n");
        }else{
            printf("dial call error, ret is %d\n",ret);
        }
    }else{
        printf("call dlsym error\n");
        exit(EXIT_FAILURE);
    }

    /**********根据handle 去获取当前这通电话的状态--start**********/
    lynq_get_current_call_state = (int(*)(int *handle,int *call_state,int *toa,int *direction,char addr[]))dlsym(dlHandle_call,"lynq_get_current_call_state");
    if(NULL != lynq_get_current_call_state)
    {
        int call_state = -1;//电话状态
        char address[64] ={0};// 电话号码
        int type_of_addr = -1;//电话号码类型
        int direction = -1;//电话方向
        ret = lynq_get_current_call_state(&handle,&call_state, &type_of_addr, &direction,address);
        if(ret== 0)
        {
            printf("call state:%d,toa:%d,dir:%d,addr=%s\n",call_state,type_of_addr,direction,address);
        }else{
            printf("query call state error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_get_current_call_state dlsym error");
        exit(EXIT_FAILURE);
    }
    /**********根据handle 去获取当前这通电话的状态--end**********/

    sleep(50);//等待50s，等待电话被接通。

    /**********查询静音状态--start**********/
    printf("get mute mic!!!\n");
    lynq_get_mute_mic = (int (*)(int *status))dlsym(dlHandle_call,"lynq_get_mute_mic");
    if(NULL != lynq_get_mute_mic)
    {
        ret = lynq_get_mute_mic(&status);
        if(ret == 0)
        {
            printf("get mute mic success: value is %d!!!\n",status);
        }else{
            printf("get mute mic state error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_get_mute_status dlsym error");
    }
    /**********查询静音状态--end**********/

    sleep(1);

    /**********设置DTMF--start**********/
    lynq_set_DTMF = (int (*)(const char callnum))dlsym(dlHandle_call,"lynq_set_DTMF");
    if(NULL != lynq_set_DTMF)
    {
        ret = lynq_set_DTMF('1');
        if(ret == 0)
        {
            printf("set DTMF success!!! value is %c\n",'1');
        }else{
            printf("set DTMF error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_set_DTMF dlsym error\n");
    }
    /**********设置DTMF--end**********/
    sleep(10);
    
    lynq_set_mute_mic = (int (*)(const int enable))dlsym(dlHandle_call,"lynq_set_mute_mic");
    if(NULL != lynq_set_mute_mic)
    {
        ret = lynq_set_mute_mic(1);
        if(ret == 0)
        {
            printf("set mute mic success!!! value is %d\n",1);
        }else{
            printf("set mute mic error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_set_mute_mic dlsym error\n");
    }
    
    sleep(1);
    
    printf("get mute mic!!!\n");
    lynq_get_mute_mic = (int (*)(int *status))dlsym(dlHandle_call,"lynq_get_mute_mic");
    if(NULL != lynq_get_mute_mic)
    {
        ret = lynq_get_mute_mic(&status);
        if(ret == 0)
        {
            printf("get mute mic success !!! value is %d\n",status);
            
            if(status!=1)
            {
                printf("get mute mic value error, set value is %d, get value is %d!!!\n",1,status);
            }
        }else{
            printf("get mute mic state error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_get_mute_status dlsym error");
    }

    
    lynq_set_mute_mic = (int (*)(const int enable))dlsym(dlHandle_call,"lynq_set_mute_mic");
    if(NULL != lynq_set_mute_mic)
    {
        ret = lynq_set_mute_mic(0);
        if(ret == 0)
        {
            printf("set mute mic success !!! value is %d\n",0);
        }else{
            printf("set mute mic error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_set_mute_mic dlsym error\n");
    }
    
    sleep(1);
    
    printf("get mute mic!!!\n");
    lynq_get_mute_mic = (int (*)(int *status))dlsym(dlHandle_call,"lynq_get_mute_mic");
    if(NULL != lynq_get_mute_mic)
    {
        ret = lynq_get_mute_mic(&status);
        if(ret == 0)
        {
            printf("get mute mic success !!! value is %d\n",status);
            
            if(status!=0)
            {
                printf("get mute mic value error, set value is %d, get value is %d!!!\n",0,status);
            }
        }else{
            printf("get mute mic state error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_get_mute_status dlsym error");
    }

    lynq_set_speech_volume = (int (*)(const int enable))dlsym(dlHandle_call,"lynq_set_speech_volume");
    if(NULL != lynq_set_speech_volume)
    {
        ret = lynq_set_speech_volume(3);
        if(ret == 0)
        {
            printf("set speech volumn success!!! value is %d \n",3);
        }else{
            printf("set speech volumn error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_set_speech_volume dlsym error\n");
    }
    
    sleep(1);
    
    lynq_get_speech_volume = (int (*)(int *status))dlsym(dlHandle_call,"lynq_get_speech_volume");
    if(NULL != lynq_set_speech_volume)
    {
        ret = lynq_get_speech_volume(&status);
        if(ret == 0)
        {
            printf("get speech volumn success!!! value is %d\n",status);
            if(status!=3)
            {
                printf("get speech volumn error, set value is %d, get value is %d!!!\n",3,status);
            }
        }else{
            printf("get speech volumn error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_get_speech_volume dlsym error\n");
    }
    
    /**********根据handle 挂断这一通电话--start**********/
    lynq_call_hungup = (int (*)(int *handle))dlsym(dlHandle_call,"lynq_call_hungup");
    if(NULL != lynq_call_hungup)
    {
        ret = lynq_call_hungup(&handle);
        if(ret == 0)
        {
            printf("hungup call success!!!\n");
        }else{
            printf("hungup call error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_call_hungup dlsym error\n");
    }
    sleep(5);
    /**********根据handle 挂断这一通电话--end**********/

    /**********注销电话业务--start**********/
    lynq_deinit_call = (int (*)(void))dlsym(dlHandle_call,"lynq_deinit_call");
    if(NULL != lynq_deinit_call)
    {
        ret = lynq_deinit_call();
        if(ret == 0)
        {
            printf("deinit call success!!!\n");
        }else{
            printf("deinit call error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_deinit_call dlsym error\n");
    }
    // 注销电话业务后若再调用Call API 均为无效结果。 
    /**********注销电话业务--end**********/

    sleep(5);
    
    return 0;
}

/*rtp*/
/*set*/
int (*lynq_set_voice_audio_mode)(const LYNQ_Audio_Mode audio_mode); 
int (*lynq_set_remote_rtp_ip)(const char* ip, const int ip_length);
int (*lynq_set_vlan_info)(const char* vlan_info, const int vlan_info_length);
int (*lynq_set_rtp_port)(const LYNQ_Rtp_Mode rtp_mode, const int port);
int (*lynq_set_rtp_param)(const int clock_rate,const int channels,const int latency); //only for client
/*get*/
int (*lynq_get_voice_audio_mode)(int*);
int (*lynq_get_remote_rtp_ip)(char* ip, const int ip_length);
int (*lynq_get_vlan_info)(char* vlan_info, const int vlan_info_length);
int (*lynq_get_rtp_port)(const LYNQ_Rtp_Mode rtp_mode, int* port);
int (*lynq_get_rtp_param)(int* clock_rate,int* channels, int* latency);//only for client

void set_voice_audio_mode(LYNQ_Audio_Mode audio_mode)
{
    int get_audio_mode;
    int ret;
    printf("lynq_set_voice_audio_mode, mode is %d\n",audio_mode);
    lynq_set_voice_audio_mode = (int (*)(const LYNQ_Audio_Mode audio_mode))dlsym(dlHandle_call,"lynq_set_voice_audio_mode");
    if(NULL != lynq_set_voice_audio_mode)
    {
        ret = lynq_set_voice_audio_mode(audio_mode);
        if(ret == 0)
        {                
            printf("lynq_set_voice_audio_mode success\n");
        }else{
            printf("lynq_set_voice_audio_mode error, ret is %d\n",ret);
            return;
        }            
    }
    else
    {
        printf("lynq_set_voice_audio_mode dlsym error\n");
        return;
    }

    printf("lynq_get_voice_audio_mode\n");
    lynq_get_voice_audio_mode = (int (*)(int*))dlsym(dlHandle_call,"lynq_get_voice_audio_mode");
    if(NULL != lynq_get_voice_audio_mode)
    {
        ret = lynq_get_voice_audio_mode(&get_audio_mode);                   
        printf("lynq_get_voice_audio_mode, ret is %d mode is %d\n",ret,get_audio_mode);
    }
    else
    {
        printf("lynq_get_voice_audio_mode dlsym error\n");
        return;
    }
}

void set_rtp(int argc, char const *argv[])
{
    int audio_mode =AUDIO_MODE_CODEC;   
    int ret;

    if(argc>2 && argv[2]!=NULL)
    {
        audio_mode=atoi(argv[2]);
    }    
    if(audio_mode==AUDIO_MODE_RTP){
        const char* ip=argv[3];
        int local_port = atoi(argv[4]);
        int remote_port = atoi(argv[5]);
        int clock_rate = atoi(argv[6]);
        int channels =atoi(argv[7]);
        int latency =atoi(argv[8]);  
        const char* vlan_info=argv[9];
        char get_ip[MAX_IP_LENGTH]={0};
        int get_local_port;
        int get_remote_port;
        int get_clock_rate;
        int get_channels;
        int get_latency;   
        char get_vlan_info[MAX_VLAN_INFO_LENGTH]={0};       

        printf("lynq_set_remote_rtp_ip ip is %s\n",ip);
        lynq_set_remote_rtp_ip = (int (*)(const char* ip, const int ip_length))dlsym(dlHandle_call,"lynq_set_remote_rtp_ip");
        if(NULL != lynq_set_remote_rtp_ip)
        {
            ret = lynq_set_remote_rtp_ip(ip,strlen(ip)+1);
            if(ret == 0)
            {
                printf("lynq_set_remote_rtp_ip success!!!\n");
            }else{
                printf("lynq_set_remote_rtp_ip error, ret is %d\n",ret);
                return;
            }
        }else{
            printf("lynq_set_remote_rtp_ip dlsym error\n");
            return;
        }

        printf("lynq_get_remote_rtp_ip\n");
        lynq_get_remote_rtp_ip = (int (*)(char* ip, const int ip_length))dlsym(dlHandle_call,"lynq_get_remote_rtp_ip");
        if(NULL != lynq_get_remote_rtp_ip)
        {
            ret = lynq_get_remote_rtp_ip(get_ip,MAX_IP_LENGTH);
            if(ret == 0)
            {
                printf("lynq_get_remote_rtp_ip success, ip is %s\n", get_ip);
            }else{
                printf("lynq_get_remote_rtp_ip error, ret is %d\n",ret);
                return;
            }
        }else{
            printf("lynq_get_remote_rtp_ip dlsym error\n");
            return;
        }

        printf("lynq_set_vlan_info vlan info is %s\n",vlan_info);
        lynq_set_vlan_info = (int (*)(const char* vlan_info, const int vlan_info_length))dlsym(dlHandle_call,"lynq_set_vlan_info");
        if(NULL != lynq_set_vlan_info)
        {
            ret = lynq_set_vlan_info(vlan_info,strlen(vlan_info)+1);
            if(ret == 0)
            {
                printf("lynq_set_vlan_info success!!!\n");
            }else{
                printf("lynq_set_vlan_info error, ret is %d\n",ret);
                return;
            }
        }else{
            printf("lynq_set_vlan_info dlsym error\n");
            return;
        }

        printf("lynq_get_vlan_info\n");
        lynq_get_vlan_info = (int (*)(char* get_vlan_info, const int vlan_info_length))dlsym(dlHandle_call,"lynq_get_vlan_info");
        if(NULL != lynq_get_vlan_info)
        {
            ret = lynq_get_vlan_info(get_vlan_info,MAX_VLAN_INFO_LENGTH);
            if(ret == 0)
            {
                printf("lynq_get_vlan_info success, vlan info is %s\n", get_vlan_info);
            }else{
                printf("lynq_get_vlan_info error, ret is %d\n",ret);
                return;
            }
        }else{
            printf("lynq_get_vlan_info dlsym error\n");
            return;
        }

        printf("lynq_set_rtp_port, local port is %d, remote port is %d\n",local_port,remote_port);
        lynq_set_rtp_port = (int (*)(const LYNQ_Rtp_Mode rtp_mode, const int port))dlsym(dlHandle_call,"lynq_set_rtp_port");
        if(NULL != lynq_set_rtp_port)
        {
            ret = lynq_set_rtp_port(RTP_CLIENT, remote_port);
            if(ret == 0)
            {
                printf("lynq_set_rtp_port RTP_CLIENT success!!!\n");
            }else{
                printf("lynq_set_rtp_port RTP_CLIENT error, ret is %d\n",ret);
                return;
            }            

            ret = lynq_set_rtp_port(RTP_SERVER, local_port);
            if(ret == 0)
            {
                printf("lynq_set_rtp_port RTP_SERVER success!!!\n");
            }else{
                printf("lynq_set_rtp_port RTP_SERVER error, ret is %d\n",ret);
                return;
            }            
        }
        else
        {
            printf("lynq_set_rtp_port dlsym error\n");
            return;
        }
        
        printf("lynq_get_rtp_port\n");
        lynq_get_rtp_port = (int (*)(const LYNQ_Rtp_Mode rtp_mode, int* port))dlsym(dlHandle_call,"lynq_get_rtp_port");
        if(NULL != lynq_get_rtp_port)
        {
            ret = lynq_get_rtp_port(RTP_CLIENT, &get_remote_port);
            if(ret == 0)
            {
                printf("lynq_get_rtp_port RTP_CLIENT success, port is %d\n",get_remote_port);
            }else{
                printf("lynq_get_rtp_port RTP_CLIENT error, ret is %d\n",ret);
                return;
            }            

            ret = lynq_get_rtp_port(RTP_SERVER, &get_local_port);
            if(ret == 0)
            {
                printf("lynq_get_rtp_port RTP_SERVER success, port is %d\n",get_local_port);
            }else{
                printf("lynq_get_rtp_port RTP_SERVER error, ret is %d\n",ret);
                return;
            }            
        }
        else
        {
            printf("lynq_get_rtp_port dlsym error\n");
            return;
        }

        printf("lynq_set_rtp_param, clock_rate is %d, channels is %d, latency is %d\n",clock_rate,channels,latency);
        lynq_set_rtp_param = (int (*)(const int clock_rate,const int channels,const int latency))dlsym(dlHandle_call,"lynq_set_rtp_port");
        if(NULL != lynq_set_rtp_param)
        {
            ret = lynq_set_rtp_param(clock_rate, channels, latency);
            if(ret == 0)
            {
                printf("lynq_set_rtp_param success!!!\n");
            }else{
                printf("lynq_set_rtp_param error, ret is %d\n",ret);
                return;
            }            
        }
        else
        {
            printf("lynq_set_rtp_param dlsym error\n");
            return;
        }

        printf("lynq_get_rtp_param success!!!\n");
        lynq_get_rtp_param = (int (*)(int* clock_rate, int* channels, int* latency))dlsym(dlHandle_call,"lynq_get_rtp_param");
        if(NULL != lynq_get_rtp_param)
        {
            ret = lynq_get_rtp_param(&get_clock_rate, &get_channels, &get_latency);
            if(ret == 0)
            {                
                printf("lynq_get_rtp_param, clock_rate is %d, channels is %d, latency is %d\n",get_clock_rate,get_channels,get_latency);
            }else{
                printf("lynq_get_rtp_param error, ret is %d\n",ret);
                return;
            }            
        }
        else
        {
            printf("lynq_get_rtp_param dlsym error\n");
            return;
        }
        set_voice_audio_mode(AUDIO_MODE_RTP);
    } 
    else 
    {
        set_voice_audio_mode(AUDIO_MODE_CODEC);
    }

}


