#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pthread.h>
#include <unistd.h>
#include <dlfcn.h>

#undef LOG_TAG
#define LOG_TAG "E_CALL_DEMO"

void *dlHandle_call;
void *dlHandle_log;

typedef enum{
    LYNQ_ECALL_SET_NUMBER = 0,     /* Set Number */
    LYNQ_ECALL_SET_URI = 1,      /* Set Uri */   
}LYNQ_ECall_Set_Type;

typedef enum{
    LYNQ_EMER_CAT_MANUAL_ECALL = 0,      /* Manual Emergency eCall */
    LYNQ_EMER_CAT_AUTO_ECALL = 1,     /*  Automatic Emergency eCall */
}LYNQ_ECall_Category;

typedef enum{
    LYNQ_ECALL_TEST = 0,     /* Test eCall */
    LYNQ_ECALL_EMERGENCY = 1,      /* Emergency eCall */
    LYNQ_ECALL_RECONFIG = 2,     /*  Reconfiguration eCall */
    LYNQ_ECALL_VAR_MAX, 
}LYNQ_ECall_Variant;

typedef enum{
    LYNQ_ECALL_SENDING_START = 1,
    LYNQ_ECALL_SENDING_MSD = 2,
    LYNQ_ECALL_LLACK_RECEIVED = 3,
    LYNQ_ECALL_ALACK_POSITIVE_RECEIVED = 4,
    LYNQ_ECALL_ALACK_CLEARDOWN_RECEIVED = 5,
    LYNQ_ECALL_ACTIVE = 11,
    LYNQ_ECALL_DISCONNECTED = 12,
    LYNQ_ECALL_IMS_ACTIVE = 13,
    LYNQ_ECALL_IMS_DISCONNECTED = 14,
    LYNQ_ECALL_ABNORMAL_HANGUP=15,
    LYNQ_ECALL_IMS_MSD_ACK = 20,
    LYNQ_ECALL_IMS_UPDATE_MSD = 21,
    LYNQ_ECALL_IMS_IN_BAND_TRANSFER = 22,
    LYNQ_ECALL_IMS_MSD_NACK = 23,
    LYNQ_ECALL_IMS_SRVCC = 24,
    LYNQ_ECALL_ONLY_DEREGISTRATION = 31,
    LYNQ_ECALL_MAY_DEREGISTER = 32,
    LYNQ_ECALL_PSAP_CALLBACK_START = 40,
    LYNQ_ECALL_PSAP_CALLBACK_IMS_UPDATE_MSD = 41,
    LYNQ_ECALL_UNSPECIFIED = 0xffff,
}LYNQ_ECall_Indication;

int (*lynq_init_call)(int);
int (*lynq_deinit_call)(void);
int (*lynq_call)(int *handle,char addr[]);
int (*lynq_call_hungup)(int *handle);
int (*lynq_set_test_num)(LYNQ_ECall_Set_Type type, const char *test_num, int test_num_length);
int (*lynq_fast_ecall)(int* handle, LYNQ_ECall_Category lynq_ecall_cat, LYNQ_ECall_Variant lynq_ecall_variant,  const char *addr, int addr_length, const unsigned char *msd_data, int msd_length);
int (*lynq_set_msd)(int* handle, const unsigned char *msd_data, int msd_length);
int (*lynq_set_ivs)(int enable);
int (*lynq_ivs_push_msd)();
int (*lynq_wait_ecall_indication)(int* handle, LYNQ_ECall_Indication *eCall_Indication);

/*
argc shoudl be 7
argv[0] is "e-call-demo"
argv[1] is ecall_set_type, between LYNQ_ECALL_SET_NUMBER and LYNQ_ECALL_SET_URI
argv[2] is ecall_cat, between LYNQ_ECALL_TEST and LYNQ_ECALL_RECONFIG
argv[3] is ecall_variant, between LYNQ_EMER_CAT_MANUAL_ECALL and LYNQ_EMER_CAT_AUTO_ECALL
argv[4] is EMERGENCY call number or Test Call Number or Reconfig Number, depends on ecall_cat
argv[5] is Msd Data
argv[6] is new Msd Data*/

int main(int argc, char const *argv[])
{
    int ret = 0;
    int handle = -1; 
    const char *lynqLibPath_Call = "/lib64/liblynq-call.so";
    const char *lynqLibPath_Log = "/lib64/liblynq-log.so";
    int ecall_cat;
    int ecall_variant;
    const char *addr;
    const unsigned char *msd_data;
    int type;
    LYNQ_ECall_Indication eCall_Indication;

    if(argc!=7)
    {
        printf("the argc %d is not equal 7", argc);
        exit(EXIT_FAILURE);
    }

    type=atoi(argv[1]);
    ecall_cat=atoi(argv[2]);
    ecall_variant=atoi(argv[3]);
    addr=argv[4];
    msd_data =(const unsigned char *) (argv[5]);

    if(ecall_cat < 0 || ecall_cat>1 ||
       ecall_variant < 0 || ecall_variant >= LYNQ_ECALL_VAR_MAX || type < 0 || type >1)
    {
        printf("parameter error");
        exit(EXIT_FAILURE);
    }           
    
    dlHandle_call = dlopen(lynqLibPath_Call, RTLD_NOW);
    if (dlHandle_call == NULL) 
    {
        printf("dlopen dlHandle_call failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynqLibPath_Log, RTLD_NOW);
    if (dlHandle_log == NULL) 
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    lynq_init_call = (int(*)(int))dlsym(dlHandle_call, "lynq_init_call");
    if (lynq_init_call == NULL) {
        printf("lynq_init_call not defined or exported in %s", lynqLibPath_Call);
        exit(EXIT_FAILURE);
    }
    dlerror(); // Clear any previous dlerror
    printf("--------->[%s,%d] start",__FUNCTION__,__LINE__);
    ret = lynq_init_call(2022);   
    sleep(1); 

    /**********set test number**********/
    printf("lynq_set_test_numl!!! type is %d, test_num is %s, test_num_length is %d\n",type,addr,strlen(addr)+1);
    lynq_set_test_num = (int(*)(LYNQ_ECall_Set_Type type, const char *test_num, int test_num_length))dlsym(dlHandle_call,"lynq_set_test_num");

    if(NULL != lynq_set_test_num)
    {
        ret = lynq_set_test_num((LYNQ_ECall_Set_Type) type,addr,strlen(addr)+1);
        if(ret == 0)
        {
            printf("set test number success\n");
        }else{
            printf("set test number error\n");
        }
    }else{
        printf("lynq_set_test_num call dlsym error\n");
        exit(EXIT_FAILURE);
    }   

    /**********dail fast call**********/
    printf("Dial a fast call!!! Addr is %s, ecall_cat is %d, ecall_variant is %d, msd is %s\n", addr,ecall_cat,ecall_variant,msd_data);
    lynq_fast_ecall = (int(*)(int* handle, LYNQ_ECall_Category lynq_ecall_cat, LYNQ_ECall_Variant lynq_ecall_variant,  const char *addr, int addr_length, const unsigned char *msd_data, int msd_length))dlsym(dlHandle_call,"lynq_fast_ecall");

    if(NULL != lynq_fast_ecall)
    {
        ret = lynq_fast_ecall(&handle, (LYNQ_ECall_Category) ecall_cat, (LYNQ_ECall_Variant) ecall_variant,  "null", 5,msd_data,strlen(argv[5]));
        if(ret == 0)
        {
            printf("dial fast call success, handle is %d\n", handle);
        }else{
            printf("dial fast call error\n");
        }
    }else{
        printf("lynq_fast_ecall call dlsym error\n");
        exit(EXIT_FAILURE);
    }   

    printf("60s begin\n");
    sleep(60);
    printf("60s end\n");

    lynq_wait_ecall_indication = (int(*)(int* handle, LYNQ_ECall_Indication *eCall_Indication))dlsym(dlHandle_call,"lynq_wait_ecall_indication");

    while(1)
    {
        lynq_wait_ecall_indication(&handle, &eCall_Indication);
        printf("recvd ecall indication %d", eCall_Indication);
        if(eCall_Indication==LYNQ_ECALL_SENDING_START)
        {
            /**********set New MSD**********/
            msd_data=(const unsigned char *) (argv[6]);
            printf("set new msd !!! msd is %s\n",msd_data);    
            lynq_set_msd = (int (*)(int* handle, const unsigned char *msd_data, int msd_length))dlsym(dlHandle_call,"lynq_set_msd");
            if(NULL != lynq_set_msd)
            {
                ret = lynq_set_msd(&handle, msd_data,strlen(argv[6]));
                if(ret == 0)
                {
                    printf("set new msd success!!!\n");
                }else{
                    printf("set new msd fail");
                }
            }else{
                printf("lynq_set_msd dlsym error");
            }
            /**********set MSD --end**********/
        }
        else if (eCall_Indication==LYNQ_ECALL_LLACK_RECEIVED) 
        {
            printf("recvd LYNQ_ECALL_LLACK_RECEIVED, msd is recved by psap");
            break;
        }    
    }
    
    sleep(10);

    lynq_call_hungup = (int (*)(int *handle))dlsym(dlHandle_call,"lynq_call_hungup");
    if(NULL != lynq_call_hungup)
    {
        ret = lynq_call_hungup(&handle);
        if(ret == 0)
        {
            printf("hungup call success!!!\n");
        }else{
            printf("hungup call error\n");
        }
    }else{
        printf("lynq_call_hungup dlsym error\n");
    }
    sleep(5);


    lynq_deinit_call = (int (*)(void))dlsym(dlHandle_call,"lynq_deinit_call");
    if(NULL != lynq_deinit_call)
    {
        ret = lynq_deinit_call();
        if(ret == 0)
        {
            printf("deinit call success!!!\n");
        }else{
            printf("deinit call error\n");
        }
    }else{
        printf("lynq_deinit_call dlsym error\n");
    }   

    sleep(5);
   
    return 0;
}

