inherit externalsrc package
DESCRIPTION = "lynq cv2x demo"
LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"

SRC_URI =  "file://lynq-cv2x-demo.cpp \
            file://cv2x-example \
            file://atk_flasher \
            file://atk_flasher \
            file://calib_file.bin \
            file://cgen \
            file://cgen_5.16.0_armv8 \
            file://cv2x_rrc_config.uper \
            file://cv2x_sw_config.txt \
            file://cv2x-example \
            file://device_logs.csv \
            file://diag-cli \
            file://dsp_sw_rev3.bin \
            file://pgen \
            file://rf_config.bin \
            file://SECTON.packed_bin.rom \
            file://SECTON.packed_bin.rom.injected \
            file://sw_config.txt \
            file://sw_config_internal.txt \
            file://readme.txt \
            file://libatlkremote_linux_u.so \
            file://libcli.so \
            file://libcv2x.so \
            file://libsmx.so \
            file://LICENSE"

TARGET_CC_ARCH += "${LDFLAGS}"


FILES_${PN} = "${base_libdir}/*.so \
               ${bindir}\
               /etc/cv2x "

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


LOCAL_C_INCLUDES = "-I."

LOCAL_LIBS = "-L. -ldl -lstdc++ -lpthread"

SOURCES = "$(wildcard *.cpp )"

OBJECTS = "$(SOURCES:.cpp=.o)"

EXECUTABLE = "lynq-cv2x-demo"
S = "${WORKDIR}"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {

	${CXX} -Wall lynq-cv2x-demo.cpp ${LOCAL_LIBS} ${LOCAL_C_INCLUDES} -o ${EXECUTABLE}
}

do_install() {
    install -d ${D}/etc/cv2x
    install -d ${D}${bindir}/
    install -m 0755 ${S}/cv2x-example ${D}${bindir}/
    install -m 0755 ${S}/atk_flasher ${D}${bindir}/
    install -m 0755 ${S}/atk_flasher                                  ${D}/etc/cv2x/atk_flasher
    install -m 0644 ${S}/calib_file.bin                               ${D}/etc/cv2x/calib_file.bin
    install -m 0755 ${S}/cgen                                         ${D}/etc/cv2x/cgen
    install -m 0755 ${S}/cgen_5.16.0_armv8                            ${D}/etc/cv2x/cgen_5.16.0_armv8
    install -m 0644 ${S}/cv2x_rrc_config.uper                         ${D}/etc/cv2x/cv2x_rrc_config.uper
    install -m 0644 ${S}/cv2x_sw_config.txt                           ${D}/etc/cv2x/cv2x_sw_config.txt 
    install -m 0755 ${S}/cv2x-example                                 ${D}/etc/cv2x/cv2x-example 
    install -m 0644 ${S}/device_logs.csv                              ${D}/etc/cv2x/device_logs.csv
    install -m 0644 ${S}/diag-cli                                     ${D}/etc/cv2x/diag-cli
    install -m 0644 ${S}/dsp_sw_rev3.bin                              ${D}/etc/cv2x/dsp_sw_rev3.bin
    install -m 0644 ${S}/pgen                                         ${D}/etc/cv2x/pgen
    install -m 0644 ${S}/rf_config.bin                                ${D}/etc/cv2x/rf_config.bin
    install -m 0644 ${S}/SECTON.packed_bin.rom                        ${D}/etc/cv2x/SECTON.packed_bin.rom
    install -m 0644 ${S}/SECTON.packed_bin.rom.injected               ${D}/etc/cv2x/SECTON.packed_bin.rom.injected
    install -m 0644 ${S}/sw_config.txt                                ${D}/etc/cv2x/sw_config.txt
    install -m 0644 ${S}/sw_config_internal.txt                       ${D}/etc/cv2x/sw_config_internal.txt
    install -m 0644 ${S}/readme.txt                                   ${D}/etc/cv2x/readme.txt
    install -m 0644 ${S}/libatlkremote_linux_u.so                     ${D}/etc/cv2x/libatlkremote_linux_u.so
    install -m 0644 ${S}/libcli.so                                    ${D}/etc/cv2x/libcli.so
    install -m 0644 ${S}/libcv2x.so                                   ${D}/etc/cv2x/libcv2x.so
    install -m 0644 ${S}/libsmx.so                                    ${D}/etc/cv2x/libsmx.so
}


