/**@File lynq-fota-demo.c
*  @Brief :fota test
*  @details :
*  @Author : lt
*  @Date : 2022-3-15
*  @Version : V1.0
*  @copy ritght : Copyright (c) MobileTek
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <unistd.h>
#include "fcntl.h"


#define UPDATA_ADDR "/tmp/fota.delta"
#define READ_BLOCK_SIZE 0x40000
#if 0
#define FLASH_DEV_DELTA       "/dev/disk/by-partlabel/delta"
#else
#define FLASH_DEV_DELTA       "/dev/mtd41"	
#endif

int (*lynq_md5_file_verfy)(char* filePath, char* file_md5);
int (*lynq_rock_main)(int first_run);
int (*mtk_device_wrap_open)(const char *pathname, int flags);
ssize_t (*mtk_device_wrap_read)(int fd, void *buf, size_t count);
ssize_t (*mtk_device_wrap_write)(int fd, void *buf, size_t count);
int (*mtk_device_wrap_close)(int fd);
int (*lynq_nand_open)(const char *pathname, int flags);
ssize_t (*lynq_nand_read)(int fd, void *buf, size_t count);
ssize_t (*lynq_nand_write)(int fd, void *buf, size_t count);
int (*lynq_nand_close)(int fd);
int (*lynq_get_upgrade_status)(void);
int (*lynq_fota_nrestart)(void);
void (*lynq_reboot_device)(void);
int (*lynq_fota_set_addr_value)(char *value,int size);
int (*lynq_fota_get_addr_value)(char *tmp);
 
#if 0 
int main(int argc,char argv[])
{


    int first_run = 1; 
    int ret = 0;
    int lynq_get_status = 0;
    int fd_down,size,fd_target;
    char input_md5_data[64];
    char delta_data[READ_BLOCK_SIZE];
    void *handle_fota;

    const char *lynq_libpath_fota = "/lib64/liblynq-fota.so";
 
    handle_fota = dlopen(lynq_libpath_fota,RTLD_NOW);
    if(NULL == handle_fota)
    {
        printf("dlopen lynq_libpath_fota fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }   

    lynq_get_upgrade_status = (int (*)(void))dlsym(handle_fota,"lynq_get_upgrade_status");
    if(NULL != lynq_get_upgrade_status)
    {
        //get lynq status
        lynq_get_status = lynq_get_upgrade_status(); 
        printf("[+UP]: lynq_get_status = %d\n",lynq_get_status);
    }
    else
    {
        printf("[+UP]: NULL == lynq_get_upgrade_status\n");
    }
    
    printf("[+UP]: input MD5 data:");	
    //get md5(input)
	while(fgets(input_md5_data,64,stdin) != NULL)
	{
		printf("[+UP]: receive MD5 data:%s\n",input_md5_data);
        lynq_md5_file_verfy = (int (*)(char* filePath, char* file_md5))dlsym(handle_fota,"lynq_md5_file_verfy");
        if(NULL != lynq_md5_file_verfy)
        {
            //md5 verfy
            ret = lynq_md5_file_verfy(UPDATA_ADDR, input_md5_data); 
            printf("[+UP]: MD5 ret = %d\n",ret);
        }
        else
        {
            printf("[+UP]: NULL == lynq_md5_file_verfy\n");
        }
		break;
	}

    fd_down = open(UPDATA_ADDR,O_RDONLY);
    if (fd_down < 0) 
    {
        printf("[+UP]: open source  error\n");
        dlclose(handle_fota);
        return 1;
    }

    lynq_nand_open = (int (*)(const char *pathname, int flags))dlsym(handle_fota,"lynq_nand_open");

    if(NULL != lynq_nand_open)
    {
        //open nanflash
        fd_target = lynq_nand_open(FLASH_DEV_DELTA,O_RDWR);
 
        if(fd_target < 0)
        {
            close(fd_down);
            printf("+[UA]: open target  error\n");
            dlclose(handle_fota);
            return 1;
        } 
    }
    else
    {
        printf("NULL == lynq_nand_open\n");
    }



    printf("[+UP]: Write data to flash\n");
    lynq_nand_write = (ssize_t (*)(int fd, void *buf, size_t count))dlsym(handle_fota,"lynq_nand_write");
    if(NULL != lynq_nand_write)
    {
        //get /tmp data(fota)
        while(( size = read(fd_down,delta_data,READ_BLOCK_SIZE))>0) 
        {
            //write nandflash
            lynq_nand_write(fd_target,delta_data,READ_BLOCK_SIZE);
        }
    }
    else
    {
        printf("NULL == lynq_nand_write\n");
    }
   
    printf("[+UP]: Write data to flash success\n");
    lynq_nand_close = (int (*)(int fd))dlsym(handle_fota,"lynq_nand_close");	
    if(NULL != lynq_nand_close)
    {
        //close
        lynq_nand_close(fd_target);
    }
    close(fd_down);

    printf("+[UA]: Upgrade to start ret:%d\n",ret);
    if(ret == 0)
    {
        lynq_rock_main = (int (*)(int first_run))dlsym(handle_fota,"lynq_rock_main");
        if(NULL != lynq_rock_main)
        {
            //ua start
            lynq_rock_main(first_run);
        }

    }
    printf("+[UA]: Upgrade to end\n");
    dlclose(handle_fota);
    return 0;

}
#else
int main(int argc,char argv[])
{

    int ret = 0;
    int lynq_get_status = 0;
    char input_md5_data[64];
    void *handle_fota;
    char input_order_data[64] = {0};
    char lynq_fota_data[64] = {0};

    const char *lynq_libpath_fota = "/lib64/liblynq-fota.so";
 
    handle_fota = dlopen(lynq_libpath_fota,RTLD_NOW);
    if(NULL == handle_fota)
    {
        printf("dlopen lynq_libpath_fota fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }   

    lynq_get_upgrade_status = (int (*)(void))dlsym(handle_fota,"lynq_get_upgrade_status");
    if(NULL != lynq_get_upgrade_status)
    {
        //get lynq status
        lynq_get_status = lynq_get_upgrade_status(); 
        printf("[+UP]: lynq_get_status = %d\n",lynq_get_status);
    }
    else
    {
        printf("[+UP]: NULL == lynq_get_upgrade_status\n");
    }
    
    printf("[+UP]: input MD5 data:");
    //get md5(input)
    while(fgets(input_md5_data,64,stdin) != NULL)
    {
        printf("[+UP]: receive MD5 data:%s\n",input_md5_data);
        lynq_md5_file_verfy = (int (*)(char* filePath, char* file_md5))dlsym(handle_fota,"lynq_md5_file_verfy");
        if(NULL != lynq_md5_file_verfy)
        {
            //md5 verfy
            ret = lynq_md5_file_verfy(UPDATA_ADDR, input_md5_data); 
            printf("[+UP]: MD5 ret = %d\n",ret);
        }
        else
        {
            printf("[+UP]: NULL == lynq_md5_file_verfy\n");
        }
            break;
        }

    lynq_fota_set_addr_value = (int (*)(char *value,int size))dlsym(handle_fota,"lynq_fota_set_addr_value");
    if(NULL != lynq_fota_set_addr_value)
    {
        if(0 == lynq_fota_set_addr_value(UPDATA_ADDR,16))
        { 
            lynq_fota_get_addr_value = (int (*)(char *tmp))dlsym(handle_fota,"lynq_fota_get_addr_value");
            if(NULL != lynq_fota_get_addr_value)
            {
                lynq_fota_get_addr_value(lynq_fota_data);
                printf("+[UA]: get fota addr:%s\n",lynq_fota_data);
            }
            else
            {
                printf("+[UA]: get fota addr error\n");
            }
        }
        else
        {
            printf("+[UA]: set fota addr error\n");
            return -1;        
        }

    }

    sleep(10);
        
    printf("+[UA]: Upgrade to start ret:%d\n",ret);
    if(ret == 0)
    {
        lynq_fota_nrestart = (int (*)(void))dlsym(handle_fota,"lynq_fota_nrestart");
        if(NULL != lynq_fota_nrestart)
        {
            //ua start
            lynq_fota_nrestart();
        }

    }

    lynq_reboot_device = (void (*)(void))dlsym(handle_fota,"lynq_reboot_device");
    if(NULL != lynq_reboot_device)
    {
        //reboot
        printf("+[UA]: input reboot order(reboot):\n");
        while(fgets(input_order_data,64,stdin) != NULL)
        {
            if(0 == strncmp(input_order_data,"reboot",6))
            {
                lynq_reboot_device();
            }
        }
    }   
    printf("+[UA]: Upgrade to end\n");
    
    dlclose(handle_fota);
    return 0;

}
#endif

