
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dlfcn.h>
#include <sys/types.h>
#define LYNQ_APN_CHANNEL_MAX 10
#define LYNQ_PDP_TYPE_MAX_LEN 16
#define LYNQ_IFACE_NAME_MAX_LEN 50
#define LYNQ_APN_MAX_LEN 50
#define LYNQ_APN_TYPE_MAX_LEN 50
#define LYNQ_PDP_ADDR_MAX_LEN 64
#define LYNQ_DNS_ADDR_MAX_LEN 64
#define LYNQ_GETWAYS_ADDR_MAX_LEN 64
#define LYNQ_POXY_ADDR_MAX_LEN 64


void *handle_network;
void *handle_log;

typedef struct{
    int gw_sig_valid; /*1 valid,1 invalid*/
    int rssi;         /* Valid values are (0-31, 99) as defined in TS 27.007 8.5 */
    int wcdma_sig_valid;/*1 valid,0 invalid*/
    int rscp;        /* The Received Signal Code Power in dBm multipled by -1.
                      * Range : 25 to 120
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 25.123, section 9.1.1.1 */
    int ecno;        /* Valid values are positive integers.  This value is the actual Ec/Io multiplied
                      * by -10.  Example: If the actual Ec/Io is -12.5 dB, then this response value
                      * will be 125.*/
    int lte_sig_valid;/*1 valid,0 invalid*/
    int rsrp;        /* The current Reference Signal Receive Power in dBm multipled by -1.
                      * Range: 44 to 140 dBm
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.4 */
    int rsrq;        /* The current Reference Signal Receive Quality in dB multiplied by -1.
                      * Range: 20 to 3 dB.
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.7 */
    int rssnr;       /* The current reference signal signal-to-noise ratio in 0.1 dB units.
                      * Range: -200 to +300 (-200 = -20.0 dB, +300 = 30dB).
                      * INT_MAX : 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.101 8.1.1 */
    int nr_sig_valid;/*1 valid,0 invalid*/
    int ssRsrp;      /* SS(Synchronization Signal) reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int ssRsrq;      /* SS reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int ssSinr;      /* SS signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 38.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
    int csiRsrp;     /* CSI reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int csiRsrq;     /* CSI reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int csiSinr;     /* CSI signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 138.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
}signalStrength_t;

int (*lynq_network_init)(int);
int (*lynq_radio_on)(const int data);

typedef struct {
    int            status;     /* A RIL_DataCallFailCause, 0 which is PDP_FAIL_NONE if no error */
    int            suggestedRetryTime; /* If status != 0, this fields indicates the suggested retry
                                           back-off timer value RIL wants to override the one
                                           pre-configured in FW.
                                           The unit is miliseconds.
                                           The value < 0 means no value is suggested.
                                           The value 0 means retry should be done ASAP.
                                           The value of INT_MAX(0x7fffffff) means no retry. */
    int            cid;        /* Context ID, uniquely identifies this call */
    int            active;     /* 0=inactive, 1=active/physical link down, 2=active/physical link up */
    char           type[LYNQ_PDP_TYPE_MAX_LEN];       /* One of the PDP_type values in TS 27.007 section 10.1.1.
                                   For example, "IP", "IPV6", "IPV4V6", or "PPP". If status is
                                   PDP_FAIL_ONLY_SINGLE_BEARER_ALLOWED this is the type supported
                                   such as "IP" or "IPV6" */
    char           ifname[LYNQ_IFACE_NAME_MAX_LEN];     /* The network interface name */
    char           addresses[LYNQ_PDP_ADDR_MAX_LEN];  /* A space-delimited list of addresses with optional "/" prefix length,
                                   e.g., "192.0.1.3" or "192.0.1.11/16 2001:db8::1/64".
                                   May not be empty, typically 1 IPv4 or 1 IPv6 or
                                   one of each. If the prefix length is absent the addresses
                                   are assumed to be point to point with IPv4 having a prefix
                                   length of 32 and IPv6 128. */
    char           dnses[LYNQ_DNS_ADDR_MAX_LEN];      /* A space-delimited list of DNS server addresses,
                                   e.g., "192.0.1.3" or "192.0.1.11 2001:db8::1".
                                   May be empty. */
    char           gateways[LYNQ_GETWAYS_ADDR_MAX_LEN];   /* A space-delimited list of default gateway addresses,
                                   e.g., "192.0.1.3" or "192.0.1.11 2001:db8::1".
                                   May be empty in which case the addresses represent point
                                   to point connections. */
    char           pcscf[LYNQ_POXY_ADDR_MAX_LEN];    /* the Proxy Call State Control Function address
                                 via PCO(Protocol Configuration Option) for IMS client. */
    int            mtu;        /* MTU received from network
                                   Value <= 0 means network has either not sent a value or
                                   sent an invalid value */
} lynq_data_call_response_v11_t;
void *dlHandle_data;
int (*lynq_init_data)(int uToken);
int (*lynq_deinit_data)(void);
int (*lynq_setup_data_call)(int *);
int (*lynq_deactive_data_call)(int *);
int (*lynq_setup_data_call_sp)(int *,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol);
int (*lynq_get_data_call_list)(int *,lynq_data_call_response_v11_t *dataCallList);
int (*lynq_wait_data_call_state_change)(int *);
#if 0
// void *handle_log;
void *dlHandle_log;
void (*lynq_log_configuration_init)(char *);
void (*lynq_log_configuration_set)(char *, char);
void (*lynq_log_debug)(const char *, ...);
#endif
int init_data_api(void)
{
    const char *lynq_libpath_data = "/lib64/liblynq-data.so";
    dlHandle_data = dlopen(lynq_libpath_data,RTLD_NOW);
    if(dlHandle_data == NULL)
    {
        printf("dlopen dlHandle_data failed: %s", dlerror());
        return -1;
    }
    lynq_init_data = (int(*)(int))dlsym(dlHandle_data,"lynq_init_data");
    if(NULL == lynq_init_data)
    {
        printf("lynq_init_data not defined or exported in %s\r\n", lynq_libpath_data);
        return -1;
    }
    lynq_deinit_data = (int (*)(void))dlsym(dlHandle_data,"lynq_deinit_data");
    if(NULL == lynq_deinit_data)
    {
        printf("lynq_deinit_data dlsym error\n");
        return -1;
    }
    lynq_setup_data_call = (int (*)(int *))dlsym(dlHandle_data,"lynq_setup_data_call");
    if(NULL == lynq_setup_data_call)
    {
        printf("lynq_setup_data_call dlsym error\n");
         return -1;
    }
    lynq_deactive_data_call = (int (*)(int *))dlsym(dlHandle_data,"lynq_deactive_data_call");
    if(NULL == lynq_deactive_data_call)
    {   
        printf("lynq_deactive_data_call dlsym error\n");
        return -1;
    }
    lynq_setup_data_call_sp = (int (*)(int *,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol))dlsym(dlHandle_data,"lynq_setup_data_call_sp");
    if(NULL == lynq_setup_data_call_sp)
    {
       printf("lynq_setup_data_call_sp dlsym error\n");
       return -1;
    }
   
    lynq_get_data_call_list = (int (*)(int *handle,lynq_data_call_response_v11_t *dataCallList))dlsym(dlHandle_data,"lynq_get_data_call_list");
    if(NULL == lynq_get_data_call_list)
    {
       printf("lynq_get_data_call_list dlsym error\n");
       return -1;
    }
    lynq_get_data_call_list = (int (*)(int *handle,lynq_data_call_response_v11_t *dataCallList))dlsym(dlHandle_data,"lynq_get_data_call_list");
    if(NULL == lynq_get_data_call_list)
    {
        printf("lynq_get_data_call_list dlsym error\n");
        return -1;
    }
    
    lynq_wait_data_call_state_change = (int (*)(int *handle))dlsym(dlHandle_data,"lynq_wait_data_call_state_change");
    if(NULL == lynq_wait_data_call_state_change)
    {
        printf("lynq_wait_data_call_state_change dlsym error\n");
        return -1;
    }
    return 0;
}

int init_network_api(void)
{
    const char *lynq_libpath_network = "/lib64/liblynq-network.so";
    handle_network = dlopen(lynq_libpath_network,RTLD_NOW);
    if(NULL == handle_network)
    {
        printf("dlopen lynq_libpath_network fail:%s",dlerror());
        return -1;
    }
    lynq_network_init = (int(*)(int))dlsym(handle_network,"lynq_network_init");
    if(NULL == lynq_network_init)
    {
        printf("lynq_init_network not defined or exported in %s\r\n", lynq_libpath_network);
        return -1;
    }
    lynq_radio_on = (int(*)(const int data))dlsym(handle_network,"lynq_radio_on");
    if(NULL == lynq_radio_on)
    {
        printf("lynq_init_network not defined or exported in %s\r\n", lynq_libpath_network);
        return -1;
    }
    return 0;
}
#if 0
int init_log_api(void)
{
    const char *lynq_libpath_log = "/lib64/liblynq-log.so";
    dlHandle_log = dlopen(lynq_libpath_log,RTLD_NOW);
    if(dlHandle_log == NULL)
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        return -1;
    }
    lynq_log_configuration_init = (void (*)(char *))dlsym(dlHandle_log,"lynq_log_configuration_init");
    if(NULL == lynq_log_configuration_init)
    {
        printf("lynq_log_configuration_init dlsym error\n");
        return -1;
    }
    lynq_log_configuration_set = (void (*)(char *, char))dlsym(dlHandle_log,"lynq_log_configuration_set");
    if(NULL == lynq_log_configuration_set)
    {
        printf("lynq_log_configuration_set dlsym error\n");
        return -1;
    }
    lynq_log_debug = (void (*)(const char *, ...))dlsym(dlHandle_log,"lynq_log_debug");
    if(NULL == lynq_log_debug)
    {
        printf("lynq_log_debug dlsym error\n");
        return -1;
    }
    return 0;
}
#endif
static int check_network_enable(void)
{
    FILE * fp;
    char data[128] = {0};
    fp = popen("ping 8.8.8.8 -c1", "r");
    fgets(data, sizeof(data), fp);
    printf("%s", data);
    if(strstr(data, "bytes"))
    {
        pclose(fp);
        return 0;
    }
    else
    {
        pclose(fp);
        return -1;
    }
}
int main(void)
{
    if(init_data_api())
    {
        printf("init_data_api error\n");
        return -1;
    }
    if(init_network_api())
    {
        printf("init_network_api error\n");
        return -1;
    }
    sleep(5);
    system("connmanctl enable gadget");
    system("connmanctl tether gadget on");
    int handle = 0;
    lynq_init_data(123);
    lynq_network_init(123);
    usleep(1000*1000);
    int res = lynq_setup_data_call(&handle);
    printf("lynq_setup_data_call result code:%d\n",res);
    int time[3] = {2, 4, 8};
    for(int i = 0;i < 3;i++)
    {
        sleep(time[i]);
        if(check_network_enable)
        {
            res = lynq_radio_on(0);
            printf("lynq_radio_on 0 res:%d  i:%d\n",res, i);
            sleep(1);
            res = lynq_radio_on(1);
            printf("lynq_radio_on 1 res:%d  i:%d\n",res, i);
            res = lynq_deactive_data_call(&handle);
            printf("lynq_deactive_data_call result code:%d  i:%d\n",res, i);
            usleep(500*1000);
            res = lynq_setup_data_call(&handle);
            printf("retry lynq_setup_data_call result code:%d  i:%d\n",res, i);
        }
        else
        {
            printf("i %d ping is ok\n", i);
            break;
        }
    }
    #if 0
    char *log_name = "rndis service";
    lynq_log_configuration_init(log_name);
    lynq_log_configuration_set(log_name, 4);
    if(init_log_api())
    {
        printf("init_log_api error\n");
        return -1;
    }
    #endif
    return 0;
}
