inherit systemd
DESCRIPTION = "lynq-rndis-service"
LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
SRC_URI = "file://lynq_rndis_service.cpp file://LICENSE file://lynq_rndis_service.service"
TARGET_CC_ARCH += "${LDFLAGS}"
#lei add
SYSTEMD_SERVICE_${PN} = "lynq_rndis_service.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_rndis_service.service"
#lei add
LOCAL_C_INCLUDES = "-I."

LOCAL_LIBS = "-L. -ldl -lstdc++ -lpthread"

SOURCES = "$(wildcard *.cpp )"

OBJECTS = "$(SOURCES:.cpp=.o)"

EXECUTABLE = "lynq-rndis-service"
S = "${WORKDIR}"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	${CXX} -Wall ${LOCAL_C_INCLUDES} lynq_rndis_service.cpp ${LOCAL_LIBS} -o ${EXECUTABLE}
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/lynq-rndis-service ${D}${bindir}/
	install -d ${D}${systemd_unitdir}/system/
	install -m 0644 ${S}/lynq_rndis_service.service ${D}${systemd_unitdir}/system
}
