/**@File lynq-systime-demo.c
*  @Brief :thermal test
*  @details :
*  @Author : rita
*  @Date : 2022-4-27
*  @Version : V1.0
*  @copy ritght : Copyright (c) MobileTek
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include <pthread.h>
#include <sys/types.h>
#include <unistd.h>

int (*modem_time_enable)(int enable);
//int (*gnss_time_enable)(int enable);
//int (*ntp_sync_time)(int enable);


int main(int argc,char *argv[])
{
    int ret = 0;
    void *handle_systime;
    int type;
    int enable;

    const char *lynq_libpath_systime = "/lib64/liblynq-systime.so";
 
    handle_systime = dlopen(lynq_libpath_systime,RTLD_NOW);
    if(NULL == handle_systime)
    {
        printf("dlopen lynq_libpath_systime fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }   

   if(argc!=3)
        return -1;

   type = atoi(argv[1]);
   enable = atoi(argv[2]);

    switch(type)
    {
        case 0:
        {
            modem_time_enable = (int (*)(int enable))dlsym(handle_systime,"modem_time_enable");
            if(NULL != modem_time_enable)
            {
                ret = modem_time_enable(enable);
                if(ret == 0)
                {
                    printf("modem_time_set!!!\n");
                }
                else
                {
                    printf("modem_time_enable error, error = %d \n", ret);
                }
            }
            else
            {
                printf("modem_time_enable dlsym error!!!\n");
                exit(EXIT_FAILURE);
            }

            dlclose(handle_systime);

            break;
        }
        case 1:
        {
#if 0
            gnss_time_enable = (int (*)(int enable))dlsym(handle_systime,"gnss_time_enable");
            if(NULL != gnss_time_enable)
            {
                ret = gnss_time_enable(enable);
                if(ret == 0)
                {
                    printf("gnss_time_set!!!\n");
                }
                else
                {
                    printf("gnss_time_enable error, error = %d \n", ret);
                }
            }
            else
            {
                printf("gnss_time_enable dlsym error!!!\n");
                exit(EXIT_FAILURE);
            }

            dlclose(handle_systime);
#endif
            break;
        }
         case 2:
        {
#if 0
            ntp_sync_time = (int (*)(int enable))dlsym(handle_systime,"ntp_sync_time");
            if(NULL != ntp_sync_time)
            {
                ret = ntp_sync_time(enable);
                if(ret == 0)
                {
                    printf("ntp_time_set!!!\n");
                }
                else
                {
                    printf("ntp_sync_time error, error = %d \n", ret);
                }
            }
            else
            {
                printf("ntp_sync_time dlsym error!!!\n");
                exit(EXIT_FAILURE);
            }

            dlclose(handle_systime);
#endif
            break;
        }
        default:
            break;
    }

    return 0;

}

