/**@File lynq-thermal-demo.c
*  @Brief :thermal test
*  @details :
*  @Author : rita
*  @Date : 2022-4-14
*  @Version : V1.0
*  @copy ritght : Copyright (c) MobileTek
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include <pthread.h>
#include <sys/types.h>
#include <unistd.h>


#define LYNQ_THM_PATH 256

#define TYPE_PATH_PRE "/sys/class/thermal"



#define LYNQ_THM_OK 0
#define LYNQ_THM_OPEN_ERROR -1
#define LYNQ_THM_READ_ERROR -2
#define LYNQ_THM_ACCESS_ERROR -3

#define LYNQ_THM_ZONE_KEY "thermal_zone"
#define LYNQ_THM_COOLER_KEY "cooling_device"

typedef enum {
    soc_max=0,
    cpu0,
    cpu1,
    cpu2,
    cpu3,
    gpu0,
    gpu1,
    dramc,
    mmsys,
    md_5g,
    md_4g,
    md_3g,
    soc_dram_ntc,
    pa_5g,
    pa_4g,
    rf_ntc,
    pmic,
    pmic_vcore,
    pmic_vpro,
    pmic_vgpu=19,
} ZONE_NUM;


int (*lynq_get_zone_tmp) (ZONE_NUM num, int *temp);
 
 
int main(int argc,char *argv[])
{
    int ret = 0;
    void *handle_thermal;
    int temp = 0;
    ZONE_NUM zone = md_5g;

    const char *lynq_libpath_thermal = "/lib64/liblynq-thermal.so";
 
    handle_thermal = dlopen(lynq_libpath_thermal,RTLD_NOW);
    if(NULL == handle_thermal)
    {
        printf("dlopen lynq_libpath_thermal fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }   

    lynq_get_zone_tmp = (int (*)(ZONE_NUM, int*))dlsym(handle_thermal,"lynq_get_zone_tmp");
    if(NULL != lynq_get_zone_tmp)
    {
        ret = lynq_get_zone_tmp(zone, &temp);
        if(ret == 0)
        {
        	printf("temp = %d \n", temp);
        }
        else
        {
        	printf("get temp error, error = %d \n", ret);
        }
    }
    else
    {
        printf("lynq_get_zone_tmp dlsym error!!!\n");
        exit(EXIT_FAILURE);
    }

    dlclose(handle_thermal);
    return 0;

}

