#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pthread.h>
#include <unistd.h>
#include <dlfcn.h>

#undef LOG_TAG
#define LOG_TAG "MEDIA_DEMO"

void *dlHandle_media;
void *dlHandle_log;


int (*lynq_get_spk_volume)(int* volume);
int (*lynq_set_spk_volume)(const int volume);
int (*lynq_media_play_audio)(const char *path);
void (*lynq_media_stop_audio)();
int (*lynq_get_mic_volume)(int* volume);
int (*lynq_set_mic_volume)(const int volume);

int main(int argc, char const *argv[])
{
    int ret = 0;
    
    if(argc<4)
    {
        printf("media demo should have 2 paramter, audio file path and volumn");
        exit(EXIT_FAILURE);
    }
    

    const char * addr =argv[1];
    int set_volume = atoi(argv[2]);
    int get_volume;

    const char *lynqLibPath_Call = "/lib64/liblynq-media.so";
    const char *lynqLibPath_Log = "/lib64/liblynq-log.so";

    dlHandle_media = dlopen(lynqLibPath_Call, RTLD_NOW);
    if (dlHandle_media == NULL) 
    {
        printf("dlopen dlHandle_media failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynqLibPath_Log, RTLD_NOW);
    if (dlHandle_log == NULL) 
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }       
    
    printf("media play audio!!! addr is %s\n", addr);
    lynq_media_play_audio = (int(*)(const char *))dlsym(dlHandle_media,"lynq_media_play_audio");
    if(NULL != lynq_media_play_audio)
    {
        ret= lynq_media_play_audio(addr);    
        if(ret == 0)
        {
            printf("media play audio success.\n");            
        }
        else
        { 
            printf("media play audio error, ret is %d\n",ret);
            exit(EXIT_FAILURE);
        }        
    }
    else
    { 
        printf("lynq_media_play_audio dlsym error\n");
        exit(EXIT_FAILURE);
    }

    printf("set speaker volumn, value is %d \n",set_volume);
    lynq_set_spk_volume = (int (*)(const int volume))dlsym(dlHandle_media,"lynq_set_spk_volume");
    if(NULL != lynq_set_spk_volume)
    {
        ret = lynq_set_spk_volume(set_volume);
        if(ret == 0)
        {
            printf("set speaker volumn success!!! value is %d \n",set_volume);
        }
        else
        { 
            printf("set speaker volumn error, ret is %d\n",ret);
        }
    }
    else
    { 
        printf("lynq_set_spk_volume dlsym error\n");
    }
       
    sleep(1);
    
    printf("get speaker volumn!!!\n");
    lynq_get_spk_volume = (int (*)(int*))dlsym(dlHandle_media,"lynq_get_spk_volume");
    if(NULL != lynq_get_spk_volume)
    {
        ret = lynq_get_spk_volume(&get_volume);     
        if(ret == 0)
        {
            printf("get speaker volumn success!!! value is %d\n",get_volume);
            if(get_volume!=set_volume)
            {
                printf("get speaker volumn error, set value is %d, get value is %d!!!\n",get_volume,set_volume);
            }
        }
        else
        {
            printf("get speaker volumn error, ret is %d\n",ret);
        }        
        
        
    }
    else
    { 
        printf("lynq_get_spk_volume dlsym error\n");
    }
         
    
    sleep(19);
    
    printf("media stop audio!!!\n");
    lynq_media_stop_audio = (void(*)())dlsym(dlHandle_media,"lynq_media_stop_audio");
    if(NULL != lynq_media_stop_audio) 
    {
        lynq_media_stop_audio();
        
        printf("media stop audio success.\n");
        
    }
    else
    { 
        printf("lynq_media_stop_audio dlsym error\n");
        exit(EXIT_FAILURE);
    }

    printf("set mic volumn, value is %d \n",set_volume);
    lynq_set_mic_volume = (int (*)(const int volume))dlsym(dlHandle_media,"lynq_set_mic_volume");
    if(NULL != lynq_set_spk_volume)
    {
        set_volume = atoi(argv[3]);
        ret = lynq_set_mic_volume(set_volume);
        if(ret == 0)
        {
            printf("set mic volumn success!!! value is %d \n",set_volume);
        }else{
            printf("set mic volumn error, ret is %d\n",ret);
        }
    }else{
        printf("lynq_set_mic_volume dlsym error\n");
    }
       
    sleep(1);
    
    printf("get mic volume!!!\n");
    lynq_get_mic_volume = (int (*)(int*))dlsym(dlHandle_media,"lynq_get_mic_volume");
    if(NULL != lynq_get_mic_volume)
    {
        ret = lynq_get_mic_volume(&get_volume);     
        if(ret == 0)
        {
            printf("get speaker volumn success!!! value is %d\n",get_volume);
            if(get_volume!=set_volume)
            {
                printf("get mic volumn error, set value is %d, get value is %d!!!\n",get_volume,set_volume);
            }
        }else{
            printf("get mic volumn error, ret is %d\n",ret);
        }        
        
        
    }else{
        printf("lynq_get_mic_volume dlsym error\n");
    }
    return 0;
}

