#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <pthread.h>
#include <unistd.h>

#ifndef LOG_TAG
#define LOG_TAG "NETWORK_DEMO"
#endif

void *handle_network;
void *handle_log;

typedef struct{
    int gw_sig_valid; /*1 valid,1 invalid*/
    int rssi;         /* Valid values are (0-31, 99) as defined in TS 27.007 8.5 */
    int wcdma_sig_valid;/*1 valid,0 invalid*/
    int rscp;        /* The Received Signal Code Power in dBm multipled by -1.
                      * Range : 25 to 120
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 25.123, section 9.1.1.1 */
    int ecno;        /* Valid values are positive integers.  This value is the actual Ec/Io multiplied
                      * by -10.  Example: If the actual Ec/Io is -12.5 dB, then this response value
                      * will be 125.*/
    int lte_sig_valid;/*1 valid,0 invalid*/
    int rsrp;        /* The current Reference Signal Receive Power in dBm multipled by -1.
                      * Range: 44 to 140 dBm
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.4 */
    int rsrq;        /* The current Reference Signal Receive Quality in dB multiplied by -1.
                      * Range: 20 to 3 dB.
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.7 */
    int rssnr;       /* The current reference signal signal-to-noise ratio in 0.1 dB units.
                      * Range: -200 to +300 (-200 = -20.0 dB, +300 = 30dB).
                      * INT_MAX : 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.101 8.1.1 */
    int nr_sig_valid;/*1 valid,0 invalid*/
    int ssRsrp;      /* SS(Synchronization Signal) reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int ssRsrq;      /* SS reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int ssSinr;      /* SS signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 38.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
    int csiRsrp;     /* CSI reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int csiRsrq;     /* CSI reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int csiSinr;     /* CSI signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 138.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
}signalStrength_t;

int (*lynq_network_init)(int);
int (*lynq_query_operater)(char *OperatorFN,char *OperatorSH,char *MccMnc);
int (*lynq_query_network_selection_mode)(int *netselMode);
int (*lynq_set_network_selection_mode)(const char *mode,const char *mccmnc);
int (*lynq_query_available_network)(char *OperatorFN,char *OperatorSH,char *MccMnc,char *NetStatus);
int (*lynq_query_registration_state)(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam);
int (*lynq_query_prefferred_networktype)(int *preNetType);
int (*lynq_set_prefferred_networktype)(const int preffertype);
int (*lynq_query_cell_info)(int cellinfo[10],int * realNum);
int (*lynq_set_unsol_cell_info_listrate)(const int rate);
int (*lynq_set_band_mode)(const int bandmode);
int (*lynq_query_available_bandmode)(int availBanMode[]);
int (*lynq_radio_on)(const int data);
int (*lynq_query_radio_tech)(int* radioTech);
int (*lynq_solicited_signal_strength)(signalStrength_t *solSigStren);
int (*lynq_network_deinit)(void);

int demoStrUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             str[i]=str[i]-32;
        }
        i++;
    }
    return 0;
}

int eventQueryOperator()//查询运营商信息demo
{
    int res = 0;
    printf("lynq_query_operater begin");
    lynq_query_operater = (int(*)(char *OperatorFN,char *OperatorSH,char *MccMnc))dlsym(handle_network,"lynq_query_operater");
    if(NULL != lynq_query_operater)
    {
        char OperatorFN[128]={0};
        char OperatorSH[128]={0};
        char MccMnc[128]={0};
        res = lynq_query_operater(OperatorFN,OperatorSH,MccMnc);
        if(res == 0)
        {
            printf("OperatorFN is %s,OperatorSH is %s,MccMnc is %s\n",OperatorFN,OperatorSH,MccMnc);
        }else{
            printf("lynq_query_operater error");
        }
    }else{
        printf("lynq_query_operater dlsym error");
        exit(EXIT_FAILURE);
    }
    printf("lynq_query_operater end");
    return 0;
}

int eventQueryNetSelectMode(int* mode)//查询网络选择模式demo。
{
    int res = 0;
    lynq_query_network_selection_mode = (int(*)(int *netselMode))dlsym(handle_network,"lynq_query_network_selection_mode");
    if(NULL != lynq_query_network_selection_mode)
    {
        res = lynq_query_network_selection_mode(mode);
        if(res == 0)
        {
            printf("network selection mode is %d\n",*mode);
        }else{
            printf("lynq_query_network_selection_mode error\n");
        }
    }else{
        printf("lynq_query_network_selection_mode dlsym error\n");
        exit(EXIT_FAILURE);
    }
    return 0;
}

int eventSetNetSelectMode(char *mode,char *mccmnc)//设置网络选择模式demo。
{
    int res = 0;
    lynq_set_network_selection_mode = (int(*)(const char *mode,const char* mccmnc))dlsym(handle_network,"lynq_set_network_selection_mode");
    if(NULL != lynq_set_network_selection_mode)
    {
        res = lynq_set_network_selection_mode(mode,mccmnc);
        if(res == 0)
        {
            printf("set network selection mode is %s,mccmnc is %s",mode,mccmnc);
        }else{
            printf("lynq_set_network_selection_mode error");
        }
    }else{
        printf("lynq_set_network_selection_mode dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}

int eventQueryAvailableNetwork()//查询可用网络demo。
{
    int res = 0;
    lynq_query_available_network = (int(*)(char *OperatorFN,char *OperatorSH,char *MccMnc,char * NetStatus))dlsym(handle_network,"lynq_query_available_network");
    if(NULL != lynq_query_available_network)
    {
        char OperatorFN[128]={0};
        char OperatorSH[128]={0};
        char MccMnc[128]={0};
        char NetStatus[128]={0};
        res = lynq_query_available_network(OperatorFN,OperatorSH,OperatorSH,NetStatus);
        if(res == 0)
        {
            printf("FN is %s,SH is %s,mccmnc is %s",OperatorFN,OperatorSH,OperatorSH,NetStatus);
        }else{
            printf("lynq_query_available_network error");
        }
    }else{
        printf("lynq_query_available_network dlsym error");
        exit(EXIT_FAILURE);
    }

    return 0;

}

int eventQueryRegistrationState(char *type)//查询VOICE/DATA/IMS 的注册状态
{
    int res = 0;
    lynq_query_registration_state = (int(*)(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam))dlsym(handle_network,"lynq_query_registration_state");
    if(NULL != lynq_query_registration_state)
    {
        int regState = 0;
        int imsRegState = 0;
        char CID[128]={0};
        char LAC[128]={0};
        int netType = 0;
        int radioTechFam = 0;

        res = lynq_query_registration_state(type,&regState,&imsRegState,LAC,CID,&netType,&radioTechFam);
        if(res == 0)
        {
            demoStrUpper(type);
            printf("upper str is %s\n",type);
            if(!strcmp(type,"VOICE")){
                printf("registration state is %d",regState);
            }else if(!strcmp(type,"DATA")){
                printf("registration state is %d,LAC is %s,CID is %s,network type is %d",regState,LAC,CID,netType);
            }else if(!strcmp(type,"IMS")){
                printf("ims registration state is %d,radio tech family is %d",imsRegState,radioTechFam);
            }else{
                printf("--------->[%s,%d] query ims registration state about voice, data, and ims!!! \n",__FUNCTION__,__LINE__);
                return -1;
            }
        }else{
            printf("lynq_query_registration_state error");
        }
    }else{
        printf("lynq_query_registration_state dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}

int eventQueryPrefferredNetworkType(int* pretype)//查询首选网络类型。
{
    int res = 0;
    lynq_query_prefferred_networktype = (int(*)(int *preNetType))dlsym(handle_network,"lynq_query_prefferred_networktype");
    if(NULL != lynq_query_prefferred_networktype)
    {
        res = lynq_query_prefferred_networktype(pretype);
        if(res == 0)
        {
            printf("prefferred networktype is %d\n",pretype);
        }else{
            printf("lynq_query_prefferred_networktype error");
        }
    }else{
        printf("lynq_query_prefferred_networktype dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventSetPrefferredNetworkType(int type)//设置首选网络类型。
{
    int res = 0;
    lynq_set_prefferred_networktype = (int(*)(const int preffertype))dlsym(handle_network,"lynq_set_prefferred_networktype");
    if(NULL != lynq_set_prefferred_networktype)
    {
        res = lynq_set_prefferred_networktype(type);
        if(res == 0)
        {
            printf("set prefferred networktype is %d\n",type);
        }else{
            printf("lynq_set_prefferred_networktype error\n");
        }
    }else{
        printf("lynq_set_prefferred_networktype dlsym error\n");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventQueryCellInfo()//查询小区信息demo。
{
    int res = 0;
    lynq_query_cell_info = (int(*)(int cellinfo[10],int * realNum))dlsym(handle_network,"lynq_query_cell_info");
    if(NULL != lynq_query_cell_info)
    {
        int cellinfo[10] = {0};
        int realNum =0;//真实返回cell 的个数。
        res = lynq_query_cell_info(cellinfo,&realNum);
        if(res == 0)
        {
            for(int i = 0; i<10;i++)
            {
                printf("cellinfo[%d]: %d",i,cellinfo[i]);
            }
        }else{
            printf("lynq_query_cell_info error");
        }
    }else{
        printf("lynq_query_cell_info dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventSetUnsolCellInfoListrate(int rate)//设置小区信息主动上报频率demo。
{
    int res = 0;
    lynq_set_unsol_cell_info_listrate = (int(*)(const int rate))dlsym(handle_network,"lynq_set_unsol_cell_info_listrate");
    if(NULL != lynq_set_unsol_cell_info_listrate)
    {
        res = lynq_set_unsol_cell_info_listrate(rate);
        if(res == 0)
        {
            printf("rate is %d",rate);
        }else{
            printf("lynq_set_unsol_cell_info_listrate error");
        }
    }else{
        printf("lynq_set_unsol_cell_info_listrate dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventSetBandMode(int mode)//设置band mode demo。
{
    int res = 0;
    lynq_set_band_mode = (int(*)(const int bandmode))dlsym(handle_network,"lynq_set_band_mode");
    if(NULL != lynq_set_band_mode)
    {
        res = lynq_set_band_mode(mode);
        if(res == 0)
        {
            printf("band mode is %d",mode);
        }else{
            printf("lynq_set_band_mode error");
        }
    }else{
        printf("lynq_set_band_mode dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;

}
int eventQueryAvailableBandmode(int bandmode[])//查询band mode demo。
{
    int res = 0;
    lynq_query_available_bandmode = (int(*)(int availBanMode[]))dlsym(handle_network,"lynq_query_available_bandmode");
    if(NULL != lynq_query_available_bandmode)
    {
        res = lynq_query_available_bandmode(bandmode);
        if(res == 0)
        {
            for(int i =1;i<=bandmode[0];i++)
            {
                printf("%d,",bandmode[i]);
            }
        }else{
            printf("lynq_query_available_bandmode error");
        }
    }else{
        printf("lynq_query_available_bandmode dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventRadioOn(int mode)//开启或者关闭无线电 demo。
{
    int res = 0;
    lynq_radio_on = (int(*)(const int data))dlsym(handle_network,"lynq_radio_on");
    if(NULL != lynq_radio_on)
    {
        res = lynq_radio_on(mode);
        if(res == 0)
        {
            printf("radio mode is %d",mode);
        }else{
            printf("lynq_radio_on error");
        }
    }else{
        printf("lynq_radio_on dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}
int eventQueryRadioTech(int* radioTech)//查询无线电技术类型（3GPP/3GPP2）demo。
{
    int res = 0;
    lynq_query_radio_tech = (int(*)(int* radioTech))dlsym(handle_network,"lynq_query_radio_tech");
    if(NULL != lynq_query_radio_tech)
    {
        res = lynq_query_radio_tech(radioTech);
        if(res == 0)
        {
            printf("radio mode is %d",radioTech);
        }else{
            printf("lynq_query_radio_tech error");
        }
    }else{
        printf("lynq_query_radio_tech dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
}

int eventSolicitedSignalStrength()//查询信号强度demo。
{
    int res = 0;
    lynq_solicited_signal_strength = (int(*)(signalStrength_t *solSigStren))dlsym(handle_network,"lynq_solicited_signal_strength");
    if(NULL != lynq_solicited_signal_strength)
    {
        signalStrength_t msg;
        res = lynq_solicited_signal_strength(&msg);
        if(res == 0)
        {
            printf("test sss 006\n");
            printf("gw_sig_valid=%d\n", msg.gw_sig_valid);
            printf("rssi=%d\n", msg.rssi);
            printf("wcdma_sig_valid=%d\n", msg.wcdma_sig_valid);
            printf("rscp=%d\n", msg.rscp);
            printf("ecno=%d\n", msg.ecno);
            printf("lte_sig_valid=%d\n", msg.lte_sig_valid);
            printf("rsrp=%d\n", msg.rsrp);
            printf("rsrq=%d\n", msg.rsrq);
            printf("rssnr=%d\n", msg.rssnr);
            printf("nr_sig_valid=%d\n", msg.nr_sig_valid);
            printf("ssRsrp=%d\n", msg.ssRsrp);
            printf("ssRsrq=%d\n", msg.ssRsrq);
            printf("ssSinr=%d\n", msg.ssSinr);
            printf("csiRsrp=%d\n", msg.csiRsrp);
            printf("csiRsrq=%d\n", msg.csiRsrq);
            printf("csiSinr=%d\n", msg.csiSinr);
        }else{
            printf("lynq_solicited_signal_strength error");
        }
    }else{
        printf("lynq_solicited_signal_strength dlsym error");
        exit(EXIT_FAILURE);
    }
    return 0;
    return 0;
}

int eventNetworkDeinit(void)
{
    int res = 0;
    lynq_network_deinit = (int(*)(void))dlsym(handle_network,"lynq_network_deinit");
    if(NULL != lynq_network_deinit)
    {
        res = lynq_network_deinit();
        if(res == 0)
        {
            printf("network server deinit");
        }else{
            printf("lynq_network_deinit error");
        }
    }else{
        printf("lynq_network_deinit dlsym error");
        exit(EXIT_FAILURE);
    }
}

int main(int argc, char const *argv[])
{
    printf("--------->[%s,%d] start \n",__FUNCTION__,__LINE__);

    int ret = 0;
    int token = 123; //唯一标识符
    const char *lynq_libpath_network = "/lib64/liblynq-network.so";
    const char *lynq_libpath_log = "/lib64/liblynq-log.so";

    handle_network = dlopen(lynq_libpath_network,RTLD_NOW);
    if(NULL == handle_network)
    {
        printf("dlopen lynq_libpath_network fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }
    handle_log = dlopen(lynq_libpath_log,RTLD_NOW);
    if(NULL == handle_log)
    {
        printf("dlopen lynq_libpath_log fail:%s",dlerror());
        exit(EXIT_FAILURE);
    }

    lynq_network_init = (int(*)(int))dlsym(handle_network,"lynq_network_init");
    if(NULL == lynq_network_init)
    {
        printf("lynq_init_network not defined or exported in %s\r\n", lynq_libpath_network);
        exit(EXIT_FAILURE);
    }

    ret = lynq_network_init(token);//初始化Network服务
    if(ret != 0)
    {
        printf("lynq_network_init defalut");
    }
    dlerror();

    sleep(5);//等待modem 准备好。

    int pretype;
    eventQueryNetSelectMode(&pretype);//查询网络选择模式。
    printf("pretype = %d\r\n",pretype);
    sleep(5);
    char mode[32] = {};
    char mccmnc[32] = {};
    sprintf(mode,"Manual",strlen("Manual"));
    sprintf(mccmnc,"46000",strlen("46000"));
    eventSetNetSelectMode(mode,mccmnc);//设置网络选择模式为手动，以移动46000为例。
    printf("mode = %s\r\n",mode);
    printf("mccmnc = %s\r\n",mccmnc);

    sleep(5);
    eventQueryNetSelectMode(&pretype);//查询网络选择模式。
    printf("pretype = %d\r\n",pretype);
    int type = -1;
    eventQueryPrefferredNetworkType(&type);
    printf("Pre Network type:%d",type);
    eventSetPrefferredNetworkType(9);
    while(1){
        sleep(1);
    }
    return 0;
}
