#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include <pthread.h>
#include <sys/types.h>
#include <unistd.h>

#undef LOG_TAG
#define LOG_TAG "RTP_DEMO"

void *dlHandle_rtp;
void *dlHandle_log;

typedef enum{
    RTP_CLIENT = 0,     
    RTP_SERVER =1,
}LYNQ_Rtp_Mode;

int (*lynq_set_rtp_mode_media_play)(const LYNQ_Rtp_Mode rtp_mode);
int (*lynq_set_rtp_ip_media_play)(LYNQ_Rtp_Mode rtp_mode,const char* ip,const int ip_length);
int (*lynq_set_rtp_port_media_play)(LYNQ_Rtp_Mode rtp_mode,const int port);
int (*lynq_set_rtp_param_media_play)(LYNQ_Rtp_Mode rtp_mode,char *file_address,const int clock_rate,const int channels,const int latency);
int (*lynq_start_rtp_server_media_play)(void);
int (*lynq_stop_rtp_server_media_play)(void);

int main(int argc, char *argv[])
{
    printf("[LYNQ_RTP_DEMO]--------->[%s,%d] start",__FUNCTION__,__LINE__);

    int ret =0 ;
    const char *lynq_libpath_rtp = "/lib64/liblynq-rtp.so";
    const char *lynq_libpath_log = "/lib64/liblynq-log.so";


    dlHandle_rtp = dlopen(lynq_libpath_rtp,RTLD_NOW);
    if(dlHandle_rtp == NULL)
    {
        printf("dlopen dlHandle_rtp failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynq_libpath_log,RTLD_NOW);
    if(dlHandle_log == NULL)
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }

    lynq_set_rtp_mode_media_play = (int(*)(const LYNQ_Rtp_Mode rtp_mode))dlsym(dlHandle_rtp,"lynq_set_rtp_mode_media_play");
    if(NULL == lynq_set_rtp_mode_media_play)
    {
        printf("lynq_set_rtp_mode_media_play not defined or exported in %s\r\n", lynq_libpath_rtp);
        exit(EXIT_FAILURE);
    }
    
    ret = lynq_set_rtp_mode_media_play(RTP_CLIENT);//初始设置 必须在第一步执行


    sleep(1);
    if(ret == 0)
    {
        printf("set rtp mode success!!!\n");
    }
    else
    {
        printf("set rtp mode fail!!!\n");
        return -1;
    }

    lynq_set_rtp_ip_media_play = (int (*)(LYNQ_Rtp_Mode ,const char* ip,const int length))dlsym(dlHandle_rtp,"lynq_set_rtp_ip_media_play");
    if(NULL != lynq_set_rtp_ip_media_play)
    {
        ret = lynq_set_rtp_ip_media_play(RTP_CLIENT,"127.0.0.1",strlen("127.0.0.1"));//默认APN 参数拨号上网。
        if(ret == 0)
        {
            printf("set ip success!!!\n");
        }else{
            printf("set ip error\n");
        }
    }else{
        printf("lynq_set_rtp_ip_media_play dlsym error\n");
    }

    //set
    lynq_set_rtp_port_media_play = (int (*)(LYNQ_Rtp_Mode rtp_mode,const int port))dlsym(dlHandle_rtp,"lynq_set_rtp_port_media_play");
    if(NULL != lynq_set_rtp_port_media_play)
    {
        ret = lynq_set_rtp_port_media_play(RTP_CLIENT,5555);
        if(ret == 0)
        {
            printf("lynq_set_rtp_port_media_play success!!!\n");
        }else{
            
            printf("lynq_set_rtp_port_media_play error\n");
        }
    }else{
        printf("lynq_set_rtp_port_media_play dlsym error\n");
    }


    printf("start lynq_set_rtp_param_media_play handle_1");

    lynq_set_rtp_param_media_play = (int (*)(LYNQ_Rtp_Mode rtp_mode,char *file_address,const int clock_rate,const int channels,const int latency))dlsym(dlHandle_rtp,"lynq_set_rtp_param_media_play");
    if(NULL != lynq_set_rtp_param_media_play)
    {   
        ret = lynq_set_rtp_param_media_play(RTP_CLIENT,"/data/ring.wav",8000,1,400);
        if(ret == 0)
        {
            printf("lynq_set_rtp_param_media_play success!!!\n");
        }else{
            printf("lynq_set_rtp_param_media_play error\n");
        }
    }else{
        printf("lynq_set_rtp_param_media_play dlsym error\n");
    }

    printf("start lynq_set_rtp_param_media_play handle_2\n");


    lynq_start_rtp_server_media_play = (int (*)(void))dlsym(dlHandle_rtp,"lynq_start_rtp_server_media_play");
    if(NULL != lynq_start_rtp_server_media_play)
    {
        ret = lynq_start_rtp_server_media_play();
        if(ret == 0)
        {
            printf("start rtp server success!!!\n");
        }else{
            printf("start rtp server error\n");
        }
    }else{
        printf("lynq_start_rtp_server_media_play dlsym error\n");
    }
    sleep(5);
    return 0;

}
