#inherit externalsrc package
inherit optee-build
DESCRIPTION = "security storage demo"
LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
SRC_URI = "file://security-storage-demo.cpp file://LICENSE"
TARGET_CC_ARCH += "${LDFLAGS}"

PLATFORM_TYPE = "${@d.getVar('TARGET_PLATFORM', True)[0:3]+'xxx'}"

LOCAL_C_INCLUDES += " -I${WORKDIR}/../../optee-client/3.2.0-${PR}/out/export/include/"
LOCAL_C_INCLUDES += " -I${TOPDIR}/../src/bsp/trustzone/optee/optee_test/${PLATFORM_TYPE}/ta/include/"
LOCAL_C_INCLUDES += " -I${TOPDIR}/../src/bsp/trustzone/optee/optee_os/${PLATFORM_TYPE}/3.2.0/lib/libutee/include/"

LOCAL_LIBS += "-L${WORKDIR}/../../optee-client/3.2.0-${PR}/out/export/lib -lteec"

DEPENDS += "optee-client"

SOURCES = "$(wildcard *.cpp )"

OBJECTS = "$(SOURCES:.cpp=.o)"

EXECUTABLE = "security-storage-demo"
S = "${WORKDIR}"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	echo "S --- ${S}"
	echo "TARGET_PREFIX --- ${TARGET_PREFIX}"
	echo "TEE_ARCH --- ${TEE_ARCH}"
	echo "STAGING_DIR_HOST --- ${STAGING_DIR_HOST}"
	echo "prefix --- ${prefix}"
	echo "PLATFORM_TYPE --- ${PLATFORM_TYPE}"
	echo "TMPDIR --- ${TMPDIR}"
	echo "PACKAGE_ARCH --- ${PACKAGE_ARCH}"
	echo "TARGET_OS --- ${TARGET_OS}"
	echo "PN --- ${PN}"
	echo "PV --- ${PV}"
	echo "PR --- ${PR}"
	echo "WORKDIR --- ${WORKDIR}"
	echo "TARGET_PLATFORM --- ${TARGET_PLATFORM}"
	echo "LOCAL_C_INCLUDES --- ${LOCAL_C_INCLUDES}"
	echo "CXX --- ${CXX}"
	echo "LOCAL_LIBS --- ${LOCAL_LIBS}"
	echo "TOPDIR --- ${TOPDIR}"
	${CXX} -Wall ${LOCAL_C_INCLUDES} security-storage-demo.cpp ${LOCAL_LIBS} -o ${EXECUTABLE}

}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/security-storage-demo ${D}${bindir}/
	install -d ${D}${includedir}
}
