#include<stdio.h>
#include<stdlib.h>
#include<dlfcn.h>
#include<string.h>


#define LIB_SETALARM "/lib64/libpoweralarm.so"
#define POWERALARM "power"
#define WAKEALARM "wake"

typedef ssize_t (*SET_ALARM)(char *);

/*****************************************************************************
* 
*   Prototype    : check_parameter
*   Description  : Check the parameters in the main function 
*   Input        : char *param ;  input format : 2022-04-23-15-30-00(OR 90-15-30-40 OR 1200)           
*   Output       : None
*   Return Value : -1: error ; >0: return interval ;
*
*****************************************************************************/
long int check_parameter(char *param,char type)
{
    int ret =0;
    long int sec;
    int time[6] = {0};

    ret = sscanf(param, "%d%*[-]%d%*[-]%d%*[-]%d%*[-]%d%*[-]%d", &time[0], &time[1], &time[2], &time[3], &time[4], &time[5]);
    if ((ret == 4) && (type == 'i')) //match parameter : -i
    {
        if ((time[0] < 0) || (time[0] > 99) || (time[1] < 0) || (time[1] > 23) || (time[2] < 0) || (time[2] > 59) || (time[3] < 0) || (time[3] > 59))
        {
            printf("error, minimum input range: 00-00-01-00;maximum input range:99-23-59-59\n");
            return -1;
        }
        sec = ((((time[0] * 24) + time[1]) *60) + time[2]) * 60 + time[3]; //time[0] : day; time[1] : hour; time[2] : minute; time[3] : second; 

        return sec;
        
    }
    else if ((ret == 6) && (type == 'w')) //match parameter : -wp
    {
        if (time[0]>2099)
        {
            printf("maximum date range:2099-12-31-23-59-59\n");
            return -1;
        }
        return 1;
    }
    else
    {
        printf("invalid input\n");
        return -1;
    }
}

int main(int argc, char *argv[])
{
    static void *handle = NULL;
    SET_ALARM poweralarm = NULL;
    SET_ALARM wakealarm = NULL;
    ssize_t res;
    long int sec = 0; 

    if (argc != 4) //жڲĸǷȷ
    {
        printf("eg1: ./set-alarm -i 00-00-20-00(OR 1200) wake(OR power)\n");
        printf("eg2: ./set-alarm -wp 2022-04-08-12-05-09 wake(OR power)\n");
        return -1;
    }

    if (strcmp(argv[1],"-i") == 0)
    {
        if (NULL != strchr(argv[2], '-'))
        {
            sec = check_parameter(argv[2],'i');
            if (sec <= 0)
            {
                printf("eg: ./set_alarm -i 00-00-20-00(OR 1200) wake(OR power)\n");
                return -1;
            }
            sprintf(argv[2], "%ld", sec);
        }
        else
        {
            sec = atol(argv[2]);
        }
        if(sec < 60)
        {
            printf("error, minimum input range: 00-00-01-00\n");
            return -1; 
        }
        printf("Success: set the time interval to wake up the system\n");
    }
    else if (strcmp(argv[1], "-wp") == 0)
    {
        sec = check_parameter(argv[2],'w');
        if (sec == -1)
        {
            printf("eg: ./set-alarm -wp 2022-04-08-12-05-09 wake(OR power)\n");
            return -1;
        }  
        printf("set the time point to wake up the system\n");
    }
    else
    {
        printf("illegal parameter\n");
        return -1;
    }

    handle = dlopen(LIB_SETALARM, RTLD_NOW); //ȡ̬
    if (handle == NULL)
    {
        fprintf(stderr, "%s\n", dlerror());
        exit(EXIT_FAILURE);
    } 

    dlerror();
    printf("dlopen Success !!!!\n");
    if (!strncmp(argv[3], POWERALARM, sizeof(POWERALARM)))
    {
        poweralarm = (ssize_t(*)(char *))dlsym(handle, "poweralarm"); //ȡpoweralarmַ
        if (poweralarm != NULL)
        {
            res = poweralarm(argv[2]); //ùػ
            if (res > 0)               //ɹ
            {
                system("poweroff");
                printf("Poweroff OK,res = %ld\n", res);
            }
            else
            {
                printf("set poweralarm error,please cat log file,LOG_TAG : libpoweralarm\n");
            }
        }
        else
        {
            printf("open function poweralarm error\n");
        }
    }
    else if (!strncmp(argv[3], WAKEALARM, sizeof(WAKEALARM)))
    {
        wakealarm = (ssize_t(*)(char *))dlsym(handle, "wakealarm"); //ȡpoweralarmַ
        if (wakealarm != NULL)
        {
            res = wakealarm(argv[2]); //ùػ
            if (res > 0)              //ɹ
            {
                printf("Wake_up OK,res = %ld\n", res);
            }
            else
            {
                printf("set wakealarm error,please cat log file,LOG_TAG : libpoweralarm\n");
            }
        }
        else
        {
            printf("open function wakealarm error\n");
        }
    }
    else
    {
        printf("!!!!Input wake or power!!!!\n");
    }

    dlclose(handle); //رվ
 
    return 0;
}
