#include <stdio.h>
#include <dlfcn.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>

#define BUF_SIZE 32
#define BUF_PIN 4

void *dlHandle_sim;
void *dlHandle_log;

int (*lynq_sim_init)(int utoken);
int (*lynq_sim_deinit)(void);
int (*lynq_enable_pin)(char pin[]);
int (*lynq_disable_pin)(char pin[]);
int (*lynq_get_iccid)(char buf[]);
int (*lynq_query_pin_lock)(char *pin,int buf[]);
int (*lynq_verify_pin)(char *pin);
int (*lynq_change_pin)(char *old_pin,char *new_pin);
int (*lynq_unlock_pin)(char *puk,char *pin);
int (*lynq_query_phone_number)(char buf[]);
int (*lynq_get_sim_status)(int *card_status);
int (*lynq_get_imsi)(char buf[]);
int (*lynq_get_imei)(char buf[]);
int (*lynq_get_imei_and_sv)(char imei[],char sv[]);
int (*lynq_req_sim_io)(int list[5], char *path, char *data, char *pin2, char *aidPtr, int sw[2], char *simResponse);
int (*lynq_shutdown)(char options[],char time[],char message[]);
int (*lynq_get_version)(char buf[]);
int (*lynq_sim_power)(int mode);
int (*lynq_reset_modem)(void);
int (*lynq_screen)(int num);


int flag_init = 0;
typedef struct
{
    int cmdIdx;
    char *funcName;
}st_api_test_case;

st_api_test_case api_testcases[] = 
{
    {0,    "lynq_sim_init"},
    {1,    "lynq_enable_pin"},
    {2,    "lynq_disable_pin"},
    {4,    "lynq_get_iccid"},
    {5,    "lynq_query_pin_lock"},
    {6,    "lynq_verify_pin"},
    {7,    "lynq_change_pin"},
    {8,    "lynq_unlock_pin"},
    {9,    "lynq_query_phone_number"},
    {10,    "lynq_get_imsi"},
    {11,    "lynq_get_sim_status"},
    {12,    "lynq_sim_deinit"},
    {13,    "lynq_get_imei"},
    {14,    "lynq_get_imei_and_sv"},
    {15,    "lynq_req_sim_io"},
    {16,    "lynq_shutdown"},
    {17,    "lynq_get_version"},
    {18,    "lynq_sim_power"},
    {19,    "lynq_reset_modem"},
    {20,    "lynq_screen"},
    {-1,    NULL}
};

void print_help(void)
{
    int i;

    printf("Supported test cases:\n");
    for(i = 0; ; i++)
    {
        if(api_testcases[i].cmdIdx == -1)
        {
            break;
        }
        printf("%d:\t%s\n", api_testcases[i].cmdIdx, api_testcases[i].funcName);
    }
}


int main(void){
    int cmdIdx = 0;
    int flag = 0;
    int res = 0;

    const char *lynq_libpath_sim = "/lib64/liblynq-sim.so";
    const char *lynq_libpath_log = "/lib64/liblynq-log.so";

    dlHandle_sim = dlopen(lynq_libpath_sim,RTLD_NOW);
    if(dlHandle_sim == NULL)
    {
        printf("dlopen dlHandle_sim failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynq_libpath_log,RTLD_NOW);
    if(dlHandle_log == NULL)
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }

    print_help();
    while(1)
    {
        printf("please input cmd index(-1 exit, 80-help): ");
        if (scanf("%d", &cmdIdx) != 1)
        {
            char c;
            while((c = getchar()) != '\n' && c != EOF);
            printf("Illegal input.Please input correctly\n");
            print_help();
            continue;
        }
        switch(cmdIdx)
        {
            case 0: /* lynq_sim_init  */
            {   
                
                if(flag_init == 1)
                {
                   printf("init is already\n"); 
                   break;
                }
                else{
                    int token;
                    printf("input token\n");
                    scanf("%d", &token);
                    lynq_sim_init = (int(*)(int utoken))dlsym(dlHandle_sim,"lynq_sim_init");
                    if(NULL != lynq_sim_init)
                    {
                        res = lynq_sim_init(token);
                        if(res == 0)
                        {
                            printf("Run lynq_sim_init\n");
                            flag_init = 1;
                        }else{
                            printf("lynq sim init error\n");
                        }
                    }else{
                        printf("lynq_sim_init dlsym error\n");
                    }
                    break;
                }
                
            }
            case 1: /* lynq_enable_pin */
            {   
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char pin[BUF_PIN] = {0};
                    printf("input pin\n");
                    scanf("%s", pin);
                    lynq_enable_pin = (int(*)(char pin[]))dlsym(dlHandle_sim,"lynq_enable_pin");
                    if(NULL != lynq_enable_pin)
                    {
                        res = lynq_enable_pin(pin);
                        if(res == 0)
                        {
                            printf("pin enabled!!!\n");
                        }else{
                            printf("pin enable error\n");
                        }
                    }else{
                        printf("lynq_enable_pin dlsym error\n");
                    }                                    
                }
                break;
            }

            case 2: /* lynq_disable_pin */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char pin[BUF_PIN] = {0};
                    printf("input pin\n");
                    scanf("%s", pin);
                    lynq_disable_pin = (int(*)(char pin[]))dlsym(dlHandle_sim,"lynq_disable_pin");
                    if(NULL != lynq_disable_pin)
                    {
                        res = lynq_disable_pin(pin);
                        if(res == 0)
                        {
                            printf("pin disnabled!!!\n");
                        }else{
                            printf("pin disable error\n");
                        }
                    }else{
                        printf("lynq_disable_pin dlsym error\n");
                    }
                }
                break;
            }
        
            case 4: /* lynq_get_iccid */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char iccid[BUF_SIZE] = {0};
                    lynq_get_iccid = (int(*)(char buf[]))dlsym(dlHandle_sim,"lynq_get_iccid");
                    if(NULL != lynq_get_iccid)
                    {
                        res = lynq_get_iccid(iccid);
                        if(res == 0)
                        {
                            printf("get iccid success!!! iccid is %s\n",iccid);
                        }else{
                            printf("get iccid error\n");
                        }
                    }else{
                        printf("lynq_get_iccid dlsym error\n");
                    }
                }
                break;
            }

            case 5:  /* lynq_query_pin_lock */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char pin[BUF_PIN] = {0};
                    printf("input pin\n");
                    scanf("%s", pin);
                    int lock[BUF_SIZE] = {0};

                    lynq_query_pin_lock = (int(*)(char *pin,int buf[]))dlsym(dlHandle_sim,"lynq_query_pin_lock");
                    if(NULL != lynq_query_pin_lock)
                    {
                        res = lynq_query_pin_lock(pin,lock);
                        if(res == 0)
                        {
                            printf("query pin lock success!!! iccid is %d\n",lock);
                        }else{
                            printf("query pin lock error\n");
                        }
                    }else{
                        printf("lynq_query_pin_lock dlsym error\n");
                    }
                }
                break;
            }
            case 6: /* lynq_verify_pin */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char pin[BUF_PIN] = {0};
                    printf("input pin\n");
                    scanf("%s", pin);

                    lynq_verify_pin = (int(*)(char *pin))dlsym(dlHandle_sim,"lynq_verify_pin");
                    if(NULL != lynq_verify_pin)
                    {
                        res = lynq_verify_pin(pin);
                        if(res == 0)
                        {
                            printf("verify pin success!!!\n");
                        }else{
                            printf("verify pin error\n");
                        }
                    }else{
                        printf("lynq_verify_pin dlsym error\n");
                    }
                }
                break;
            }            
            case 7: /* lynq_change_pin */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char old_pin[BUF_PIN] = {0};
                    printf("input old pin\n");
                    scanf("%s", old_pin);
                    char new_pin[BUF_PIN] = {0};
                    printf("input new pin\n");
                    scanf("%s", new_pin);

                    lynq_change_pin = (int(*)(char *old_pin,char *new_pin))dlsym(dlHandle_sim,"lynq_change_pin");
                    if(NULL != lynq_change_pin)
                    {
                        res = lynq_change_pin(old_pin,new_pin);
                        if(res == 0)
                        {
                            printf("change pin success!!!\n");
                        }else{
                            printf("change pin error\n");
                        }
                    }else{
                        printf("lynq_change_pin dlsym error\n");
                    }
                }
                break;
            }
            case 8: /* lynq_unlock_pin */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char puk[BUF_SIZE] = {0};
                    printf("input  puk\n");
                    scanf("%s", puk);
                    char new_pin[BUF_PIN] = {0};
                    printf("input new pin\n");
                    scanf("%s", new_pin);
                    lynq_unlock_pin = (int(*)(char *puk,char *pin))dlsym(dlHandle_sim,"lynq_unlock_pin");
                    if(NULL != lynq_unlock_pin)
                    {
                        res = lynq_unlock_pin(puk,new_pin);
                        if(res == 0)
                        {
                            printf("unlock pin success!!!\n");
                        }else{
                            printf("unlock pin error\n");
                        }
                    }else{
                        printf("lynq_unlock_pin dlsym error\n");
                    }
                }
                break;
            }
            case 9: /* lynq_query_phone_number */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char number[BUF_SIZE] = {0};
                    lynq_query_phone_number = (int(*)(char buf[]))dlsym(dlHandle_sim,"lynq_query_phone_number");
                    if(NULL != lynq_query_phone_number)
                    {
                        res = lynq_query_phone_number(number);
                        if(res == 0)
                        {
                            printf("phone number is %s!!!\n",number);
                        }else{
                            printf("No phone write\n");
                        }
                    }else{
                        printf("lynq_query_phone_number dlsym error\n");
                    }
                }
                break;
            }
            case 10: /* lynq_get_imsi */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    char imsi[BUF_SIZE] = {0};

                    lynq_get_imsi = (int(*)(char buf[]))dlsym(dlHandle_sim,"lynq_get_imsi");
                    if(NULL != lynq_get_imsi)
                    {
                        res = lynq_get_imsi(imsi);
                        if(res == 0)
                        {
                            printf("imsi is %s!!!\n",imsi);
                        }else{
                            printf("get imsi error\n");
                        }
                    }else{
                        printf("lynq_get_imsi dlsym error\n");
                    }
                }
                break;
            }
            case 11: /* lynq_get_sim_status */
            {
                if(flag_init == 0){
                    printf("must init first\n");
                }
                else{
                    int x = -1;
                    int *y = &x;

                    lynq_get_sim_status = (int(*)(int* card_status))dlsym(dlHandle_sim,"lynq_get_sim_status");
                    if(NULL != lynq_get_sim_status)
                    {
                        res = lynq_get_sim_status(y);
                        if(res == 0)
                        {
                            printf("state is %d!!!\n",*y);
                        }else{
                            printf("get imsi error\n");
                        }
                    }else{
                        printf("lynq_get_sim_status dlsym error\n");
                    }
                }
                break;
            }
            case 12:
            {
                lynq_sim_deinit = (int(*)(void))dlsym(dlHandle_sim,"lynq_sim_deinit");
                if(NULL != lynq_sim_deinit)
                {
                    res = lynq_sim_deinit();
                    if(res == 0)
                    {
                        printf("sim deinit success is!!!\n");
                    }else{
                        printf("get imsi error\n");
                    }
                }else{
                    printf("lynq_sim_deinit dlsym error\n");
                }
                flag_init = 0;
                break;
            }
            case 13:
            {
                lynq_get_imei = (int (*)(char *buf))dlsym(dlHandle_sim,"lynq_get_imei");
                if(NULL != lynq_get_imei)
                {
                    char buf[20] = {0};
                    res = lynq_get_imei(buf);
                    if(res == 0)
                    {
                        printf("imei is %s!!!\n",buf);
                    }
                    else
                    {
                        printf("get imei error %d\n", res);
                    }
                }
                else
                {
                    printf("lynq_get_imei dlsym error\n");
                }
                break;
            }
            case 14:
            {
                lynq_get_imei_and_sv = (int (*)(char *imei, char* sv))dlsym(dlHandle_sim,"lynq_get_imei_and_sv");
                if(NULL != lynq_get_imei_and_sv)
                {
                    char imei[20] = {0};
                    char sv[20] = {0};
                    res = lynq_get_imei_and_sv(imei,sv);
                    if(res == 0)
                    {
                        printf("imei is %s sv is %s!!!\n",imei,sv);
                    }
                    else
                    {
                        printf("get imei sv error %d\n", res);
                    }
                }
                else
                {
                    printf("lynq_get_imei_and_sv dlsym error\n");
                }
                break;
            }
            case 15:
            {
                lynq_req_sim_io = (int (*)(int list[5], char *path, char *data, char *pin2, char *aidPtr, int sw[2], char *simResponse))dlsym(dlHandle_sim,"lynq_req_sim_io");
                if(NULL != lynq_req_sim_io)
                {
                    int list[5] = {176,28423,0,0,9};
                    char *path = "3F007F20";
                    char *data = NULL;
                    char *pin2 = NULL;
                    char *aidPtr = NULL;
                    int sw[2];
                    char simResponse[256] = {0};
                    res = lynq_req_sim_io(list, path, data, pin2, aidPtr, sw, simResponse);
                    if(res == 0)
                    {
                        printf("%d %d  %s\n", sw[0], sw[1], simResponse);
                    }
                    else
                    {
                        printf("lynq_req_sim_io error %d\n", res);
                    }
                }
                else
                {
                    printf("lynq_req_sim_io dlsym error \n");
                }
                break;
            }
            case 16:
            {
                lynq_shutdown = (int (*)(char *, char *, char *))dlsym(dlHandle_sim,"lynq_shutdown");
                if(NULL != lynq_shutdown)
                {
                    char *option = "-h";
                    char *time = "1";
                    char *message = "poweroff";
                    res = lynq_shutdown(option,time,message);
                    if(res == 0)
                    {
                        printf("shutdown -h 1\n");
                    }
                    else
                    {
                        printf("shutdown error\n");
                    }
                }
                break;
            }
            case 17:
            {
                lynq_get_version = (int (*)(char *))dlsym(dlHandle_sim,"lynq_get_version");
                if(NULL != lynq_get_version)
                {
                    char buf[32] = {0};
                    res = lynq_get_version(buf);
                    if(res == 0)
                    {
                        printf("version %s\n", buf);
                    }
                    else
                    {
                        printf("lynq_get_version error\n");
                    }
                }
                break;
            }
            case 18:
            {
                lynq_sim_power = (int (*)(int))dlsym(dlHandle_sim,"lynq_sim_power");
                if(NULL != lynq_sim_power)
                {
                    int token;
                    printf("input mode\n");
                    scanf("%d", &token);
                    res = lynq_sim_power(token);
                    if(res == 0)
                    {
                        printf("lynq_sim_power success\n");
                    }
                    else
                    {
                        printf("lynq_sim_power error\n");
                    }
                }
                break;
            }
            case 19:
            {
                lynq_reset_modem = (int (*)())dlsym(dlHandle_sim,"lynq_reset_modem");
                if(NULL != lynq_reset_modem)
                {
                    res = lynq_reset_modem();
                    if(res == 0)
                    {
                        printf("lynq_reset_modem success\n");
                    }
                    else
                    {
                        printf("lynq_reset_modem error\n");
                    }
                }
                break;
            }
            case 20:
            {
                lynq_screen = (int (*)(int))dlsym(dlHandle_sim,"lynq_screen");
                if(NULL != lynq_screen)
                {
                    int token;
                    printf("input mode\n");
                    scanf("%d", &token);
                    res = lynq_screen(token);
                    if(res == 0)
                    {
                        printf("lynq_screen success\n");
                    }
                    else
                    {
                        printf("lynq_screen error\n");
                    }
                }
                break;
            }
            case -1:
            {
                flag = 1;        /* exit */
                break;
            }
            case 80:
                print_help(); 
                break;
            default:
                print_help();
            break;     
        }
        if(flag == 1)
            break;
    }
    return 0;
}
