#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <pthread.h>
#include <dlfcn.h>
#include <errno.h>
#include <sys/un.h>
#include <ctype.h>

#undef LOG_TAG
#define LOG_TAG "MAIN_LOG"
#define DEBUG printf

#define MAX_INPUT 100
#define MSG_MAX_LEN 1024
#define SMSC_MAX_LEN 22
#define TELEPHONE_NUM_LEN 64
#define SMS_NUM_MAX 255

const char *lynqLibpathSms = "/lib64/liblynq-sms.so";
const char *lynqLibpathNetwork = "/lib64/liblynq-network.so";

void *handle_network;
void *handle_sms;

int init_sms_uToken = 2022;
int init_network_uToken = 2023;

int (*lynq_network_init)(int);
int (*lynq_set_prefferred_networktype)(const int preffertype);
int (*lynq_query_prefferred_networktype)(int *preNetType);
int (*lynq_query_registration_state)(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam,int *netRejected);
int (*lynq_network_deinit)(void);

int (*lynq_sms_init)(int uToken);
int (*lynq_sms_deinit)(void);
int (*lynq_send_sms)(char telephony_num[TELEPHONE_NUM_LEN], int charset, char *msg, int msglen);
int (*lynq_read_sms)(int index,int *status,int *charset,char smsc[SMSC_MAX_LEN],int *smscLen,int *smslen,char message[MSG_MAX_LEN],char teleNum[TELEPHONE_NUM_LEN],int *numLen, int *current,int *total);
int (*lynq_get_smsc_address)(char service_num[SMSC_MAX_LEN]);
int (*lynq_set_smsc_address)(const char* service_num);
int (*lynq_list_sms)(char index_list[SMS_NUM_MAX]);
int (*lynq_delete_sms)(int index);
int (*lynq_wait_receive_new_sms)(int *handle);

void sms_demo_init(int preNetType);
void sms_demo_deinit(void);
int demo_send_message(char *smsc_address, char *phone_num, int charset);
int demo_delete_message(int index);
int demo_set_smsc_address(char *smsc_address);
int demo_get_smsc_address(void);
int demo_list_all_msg(void);

//***新消息处理线程***
void *triggerUrcEvent(void *parg)
{
    int ret=0;
    int handle = -1;
    char smsc[SMSC_MAX_LEN] = {'\0'};
    char msg[MSG_MAX_LEN] = {'\0'};
    char teleNum[TELEPHONE_NUM_LEN] = {'\0'};
    char index_list [SMS_NUM_MAX] = {'\0'};
    int index = -1;
    int status = -1;
    int charset = -1;
    int smsclen = -1;
    int smslen = 1;
    int numlen = -1;
    int current = -1;
    int total = -1;
    while(1)
    {
wait_message:
        bzero(smsc, SMSC_MAX_LEN);
        bzero(msg, MSG_MAX_LEN);
        bzero(teleNum, TELEPHONE_NUM_LEN);

        lynq_wait_receive_new_sms = (int (*)(int *handle))dlsym(handle_sms,"lynq_wait_receive_new_sms"); // 等待接收新短消息上报，并获取handle。
        if(NULL != lynq_wait_receive_new_sms)
        {
            ret = lynq_wait_receive_new_sms(&handle);
            if(ret == 0)
            {
                printf("************************************Attention! new message!******************************************\n");
                printf("index = %d\n",handle);
            }
            else
            {
                printf("wait receive error %d\n", ret);
                goto wait_message;
            }
        }
        else
        {
            printf("lynq_wait_receive_new_sms dlsym error\n");
            exit(EXIT_FAILURE);
        }

        //及时处理底层上报
        /**********根据handle 读取该条短消息--start**********/
        lynq_read_sms = (int (*)(int index,int *status,int *charset,char smsc[SMSC_MAX_LEN],int *smscLen,int *smslen,char message[MSG_MAX_LEN],char teleNum[TELEPHONE_NUM_LEN],int *numLen, int *current,int *total))dlsym(handle_sms,"lynq_read_sms"); 
        if(NULL != lynq_read_sms)
        {
            ret = lynq_read_sms(handle, &status, &charset, smsc, &smsclen, &smslen, msg, teleNum, &numlen, &current, &total);
            if(ret == 0)
            {
                
                printf("status=%d,charset=%d,smsc=%s,smsclen=%d,smslen=%d,msg=%s,teleNum=%s,numlen=%d,current=%d,total=%d\n",
                status,charset,smsc,smsclen,smslen,msg,teleNum,numlen,current,total);
                printf("************************************new message end******************************************\n");
            }
            else
            {
                printf("lynq_read_sms error %d\n", ret);
                printf("************************************new message end******************************************\n");
            }
        }
        else
        {
            printf("lynq_read_sms dlsym error\n");
        }
        /**********根据handle 读取该条短消息--end**********/
        
    }
    return NULL;
}

void sms_demo_init(int preNetType)
{   
    int ret;
    int outPreNetType = -1;

    handle_network = dlopen(lynqLibpathNetwork,RTLD_NOW);
    if(NULL == handle_network)
    {
        printf("dlopen lynqLibpathNetwork fail:%s\n",dlerror());
        exit(EXIT_FAILURE);
    }
    handle_sms = dlopen(lynqLibpathSms,RTLD_NOW);
    if(NULL == handle_sms)
    {
        printf("dlopen lynqLibpathSms fail:%s\n",dlerror());
        exit(EXIT_FAILURE);
    }

    lynq_network_init = (int(*)(int))dlsym(handle_network,"lynq_network_init");
    if(NULL == lynq_network_init)
    {
        printf("lynq_sms_init not defined or exported in %s\r\n", lynqLibpathNetwork);
        exit(EXIT_FAILURE);
    }
    lynq_sms_init = (int(*)(int))dlsym(handle_sms,"lynq_sms_init");
    if(NULL == lynq_sms_init)
    {
        printf("lynq_sms_init not defined or exported in %s\r\n", lynqLibpathSms);
        exit(EXIT_FAILURE);
    }

    ret = lynq_sms_init(init_sms_uToken);//初始化短消息业务。
    if(ret != 0)
    {
        printf("lynq_sms_init defalut\n");
        exit(EXIT_FAILURE);
    }
    dlerror();
    sleep(1);
    ret = lynq_network_init(init_network_uToken);//初始化NETWORK 业务。
    if(ret != 0)
    {
        printf("lynq_network_init defalut\n");
        exit(EXIT_FAILURE);
    }
    sleep(1);
    lynq_set_prefferred_networktype = (int(*)(const int preffertype))dlsym(handle_network,"lynq_set_prefferred_networktype");//设置首选网络
    if(NULL != lynq_set_prefferred_networktype)
    {
        ret = lynq_set_prefferred_networktype(preNetType);
        if(ret == 0)
        {
            printf("set prefferred networktype is %d\n",preNetType);
        }
        else
        {
            printf("lynq_set_prefferred_networktype error %d\n",ret);
            exit(EXIT_FAILURE);
        }
    }else{
        printf("lynq_set_prefferred_networktype dlsym error\n");
        exit(EXIT_FAILURE);
    }

    lynq_query_prefferred_networktype = (int(*)(int *preNetType))dlsym(handle_network,"lynq_query_prefferred_networktype");//查询首选网络
    if(NULL != lynq_query_prefferred_networktype)
    {
        ret = lynq_query_prefferred_networktype(&outPreNetType);
        if(ret == 0)
        {
            if(outPreNetType == preNetType)
            {
                DEBUG("prefferred networktype is %d\n", preNetType);
            }
            else
            {
                printf("set prefferred networktype error, outPreNetType is %d\n", outPreNetType);
                exit(EXIT_FAILURE);
            }
        }
        else
        {
            printf("lynq_query_prefferred_networktype error %d\n", ret);
            exit(EXIT_FAILURE);
        }
    }
    else
    {
        printf("lynq_query_prefferred_networktype dlsym error\n");
        exit(EXIT_FAILURE);
    }
    sleep(1);
    pthread_t tid;
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    ret = pthread_create(&tid,&attr,triggerUrcEvent,NULL);//创建一个线程用来处理接收新短消息事件。
}

void sms_demo_deinit(void)
{
    int ret;
    /**********注销短消息业务--start**********/
    lynq_sms_deinit = (int (*)(void))dlsym(handle_sms,"lynq_sms_deinit");
    if(NULL != lynq_sms_deinit)
    {
        ret = lynq_sms_deinit();
        if(ret == 0)
        {
            printf("sms deinit success\n");
        }
        else
        {
            printf("sms deinit error %d\n", ret);
            exit(EXIT_FAILURE);
        }
    }
    else
    {
        printf("lynq_sms_deinit dlsym error\n");
        exit(EXIT_FAILURE);
    }
    sleep(5);
    /**********注销短消息业务--end**********/    

    DEBUG("lynq sms deinit end\n");

    /**********注销网络业务--start**********/
    lynq_network_deinit = (int (*)(void))dlsym(handle_network,"lynq_network_deinit");
    if(NULL != lynq_network_deinit)
    {
        ret = lynq_network_deinit();
        if(ret == 0)
        {
            printf("network deinit success\n");
        }
        else
        {
            printf("network deinit error %d\n", ret);
            exit(EXIT_FAILURE);
        }
    }
    else
    {
        printf("lynq_network_deinit dlsym error\n");
        exit(EXIT_FAILURE);
    }
    /**********注销网络业务--end**********/ 
    return ;
}
/*
*Step1、查询注册状态，检查是否成功注网（未成功注册到网络时无法进行短信相关功能）
*Step2、设置短信中心号码（建议每次发短信前确定使用了正确的短信中心号码）
*Step3、发送短信
*/
int demo_send_message(char *smsc_address, char *phone_num, int charset, char *msg)
{
    int ret = 0;
    if(smsc_address == NULL || phone_num == NULL || msg == NULL)
    {
        printf("input error\n");
        return -1;
    }
    //Step1、查询注册状态，检查是否成功注网
    /**********查询注册状态--start**********/
    lynq_query_registration_state = (int(*)(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam,int *netRejected))dlsym(handle_network,"lynq_query_registration_state");
    if(NULL != lynq_query_registration_state)
    {
        int regState = -1;
        int imsRegState = -1;
        char CID[128]={'\0'};
        char LAC[128]={'\0'};
        int netType = -1;
        int radioTechFam = -1;
        int netRejected = -1;

        //此处以IMS举例，实际查询DATA、VOICE、IMS皆可获得注网状态，具体可看Network中lynq_query_registration_state接口的描述
        ret = lynq_query_registration_state("IMS",&regState,&imsRegState,LAC,CID,&netType,&radioTechFam,&netRejected);
        if(ret == 0)
        {
            if(imsRegState == 1)
            {
                DEBUG("lynq_query_registration_state pass\n");
            }
            else
            {
                printf("lynq_query_registration_state error, imsRegState = %d\n", imsRegState);
                return -1;
            }
        }
        else
        {
            printf("lynq_query_registration_state error\n");
            return -1;
        }
    }
    else
    {
        printf("lynq_query_registration_state dlsym error\n");
        return -1;
    }
    /**********查询注册状态--end**********/

    //Step2、设置短信中心号码
    /**********设置短消息中心号码--start**********/
    lynq_set_smsc_address = (int (*)(const char* service_num))dlsym(handle_sms,"lynq_set_smsc_address");
    if(NULL != lynq_set_smsc_address)
    {
        ret = lynq_set_smsc_address(smsc_address);
        if(ret == 0)
        {
            printf("set smsc success\n");
        }
        else
        {
            printf("set smsc error %d\n", ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_set_smsc_address dlsym error\n");
        return -1;
    }
    /**********设置短消息中心号码--end**********/

    //Step3、发送短信
    /**********发送短消息--start**********/

    lynq_send_sms = (int(*)(char telephony_num[TELEPHONE_NUM_LEN],int charset, char *msg, int msglen))dlsym(handle_sms,"lynq_send_sms");
    if(NULL != lynq_send_sms)
    {
        ret = lynq_send_sms(phone_num, charset, msg, sizeof(msg));
        if(ret == 0)
        {
            printf("send sms success\n");
        }
        else
        {
            printf("send sms error %d\n", ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_send_sms dlsym error\n");
        return -1;
    }
    /**********发送短消息--end**********/  
    return 0;  
}

int demo_list_all_msg(void)
{
    int ret = 0;
    char index_list[SMS_NUM_MAX] = {'\0'};
    int index = -1;
    int status = -1;
    int charset = -1;
    int smsclen = -1;
    int smslen = 1;
    int numlen = -1;
    int current = -1;
    int total = -1;
    char smsc[SMSC_MAX_LEN] = {'\0'};
    char msg[MSG_MAX_LEN] = {'\0'};
    char teleNum[TELEPHONE_NUM_LEN] = {'\0'};
    /**********获取短消息列表--start**********/
    lynq_list_sms = (int (*)(char index_list[SMS_NUM_MAX]))dlsym(handle_sms,"lynq_list_sms");
    if(NULL != lynq_list_sms)
    {
        ret = lynq_list_sms(index_list);
        if(ret == 0)
        {
            printf("list=%s\n", index_list);
        }
        else
        {
            printf("lynq_list_sms error %d\n",ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_list_sms dlsym error\n");
        return -1;
    }
    /**********获取短消息列表--end**********/

    //此处举例将短信列表中的短信全部读取出的场景
    /**********根据index 读取该条短消息--start**********/
    lynq_read_sms = (int (*)(int index,int *status,int *charset,char smsc[SMSC_MAX_LEN],int *smscLen,int *smslen,char message[MSG_MAX_LEN],char teleNum[TELEPHONE_NUM_LEN],int *numLen, int *current,int *total))dlsym(handle_sms,"lynq_read_sms");
    if(NULL == lynq_read_sms)
    {
        printf("lynq_read_sms dlsym error\n");
        return -1;
    }
    for(index = 1; index <= SMS_NUM_MAX; index++)
    {
        if(index_list[index-1] == '1')
        { 
            DEBUG("read message index: %d\n", index);
            ret = lynq_read_sms(index, &status, &charset, smsc, &smsclen, &smslen, msg, teleNum, &numlen, &current, &total);
            printf("************************************message start******************************************\n");
            if(ret == 0)
            {
                printf("status=%d,charset=%d,smsc=%s,smsclen=%d,smslen=%d,msg=%s,teleNum=%s,numlen=%d,current=%d,total=%d\n",
                status,charset,smsc,smsclen,smslen,msg,teleNum,numlen,current,total);
                printf("************************************message end******************************************\n");
            }
            else
            {
                printf("lynq_read_sms error %d\n", ret);
                printf("************************************message end******************************************\n");
                return -1;
            }
        }
    }
    /**********根据index 读取该条短消息--end**********/
    return 0;
}

int demo_delete_message(int index)
{
    int ret = 0;
    /**********根据index 删除该条短消息--start**********/
    lynq_delete_sms = (int (*)(int index))dlsym(handle_sms,"lynq_delete_sms");
    if(NULL != lynq_delete_sms)
    {
        ret = lynq_delete_sms(index);
        if(ret == 0)
        {
            printf("list=%d\n",index);
        }
        else
        {
            printf("lynq_delete_sms error %d\n", ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_delete_sms dlsym error\n");
        return -1;
    }
    /**********根据handle 删除该条短消息--end**********/   
    return 0; 
}

int demo_set_smsc_address(char *smsc_address)
{
    int ret = 0;
    if(smsc_address == NULL)
    {
        printf("smsc_address is null\n");
        return -1;
    }
    /**********设置短消息中心号码--start**********/
    lynq_set_smsc_address = (int (*)(const char* service_num))dlsym(handle_sms,"lynq_set_smsc_address");
    if(NULL != lynq_set_smsc_address)
    {
        ret = lynq_set_smsc_address(smsc_address);
        if(ret == 0)
        {
            printf("set smsc success\n");
        }
        else
        {
            printf("set smsc error %d\n", ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_set_smsc_address dlsym error\n");
        return -1;
    }
    /**********设置短消息中心号码--end**********/
}

int demo_get_smsc_address(void)
{
    int ret = 0;
    char smsc[SMSC_MAX_LEN] = {'\0'};
    /**********查询短消息中心号码--start**********/
    lynq_get_smsc_address = (int (*)(char service_num[SMSC_MAX_LEN]))dlsym(handle_sms,"lynq_get_smsc_address");
    if(NULL != lynq_get_smsc_address)
    {
        ret = lynq_get_smsc_address(smsc);
        if(ret == 0)
        {
            printf("get smsc success,smsc = %s\n",smsc);
        }
        else
        {
            printf("lynq_get_smsc_address error %d\n", ret);
            return -1;
        }
    }
    else
    {
        printf("lynq_get_smsc_address dlsym error\n");
        return -1;
    }
    /**********查询短消息中心号码--end**********/  
    return 0;  
}

void printf_help(void)
{
    printf("**********************************User Guide***********************************************\n");
    printf("User Guide\n");
    printf("usage: [<function>] [<arg>...]\n");
    printf("-h                                                    for help\n");
    printf("--send <smsc_address> <phone_num> <charset>           send message\n");
    printf("                                                      charset:    0: 7BIT\n");
    printf("                                                                  1: 8BIT\n");
    printf("                                                                  2: UCS2\n");
    printf("--list                                                list all messages\n");
    printf("--delete <index>                                      delete message with index <index>\n");
    printf("--set-smsc <address>                                  set the smsc address to <address>\n");
    printf("--get-smsc                                            get the smsc address\n");
    printf("--exit                                                exit\n");
    printf("********************************************************************************************\n");
    return;
}

void printf_help2(void)
{
    printf("*******************************User Guide*************************************************\n");
    printf("usage: sms-demo <preNetType>\n");
    printf("Example: sms-demo 9\n");
    printf("<preNetType>\n");
    printf("0 : GSM/WCDMA (WCDMA preferred)\n");
    printf("1 : GSM only\n");
    printf("2 : WCDMA\n");
    printf("3 : GSM/WCDMA (auto mode, according to PRL)\n");
    printf("5 : CDMA only\n");
    printf("9 : LTE, GSM/WCDMA\n");
    printf("11: LTE only\n");
    printf("12: LTE/WCDMA\n");
    printf("23: PREF_NET_TYPE_NR_ONLY /* NR 5G only mode */\n");
    printf("24: PREF_NET_TYPE_NR_LTE/* NR 5G, LTE */\n");
    printf("31: PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA /* NR 5G, LTE, TD-SCDMA, WCDMA */\n");
    printf("32: PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA /* NR 5G, LTE, TD-SCDMA, GSM and WCDMA */\n");
    printf("*******************************************************************************************\n");
    return;
}

int is_int(char *str)
{
    int i;
    int len = (str == NULL ? -1 : strlen(str));

    for (i = 0; i < len; i++)
    {
        if (!(isdigit(str[i])))
            return -1;
    }
    return len;
}

void delete_enter(char data[])
{
    char *find = strchr(data, '\n');
    if(find)
        *find = '\0';
    return ;
}

int main(int argc,char** argv)
{
    char arg_string[MAX_INPUT];
    char *input[5];
    int i, ret;//i 计算传入参数数量，ret 各类函数返回值
    int preNetType;
    int charset;
    char smsc_address[SMSC_MAX_LEN] = {'\0'};
    char phone_num[TELEPHONE_NUM_LEN] = {'\0'};
    char msg[MSG_MAX_LEN] = {'\0'};
    int index;
    char *p = NULL, *q = NULL; //p: help choose function; q: help split string


    if(argc != 2)
    {
        printf_help2();
        exit(EXIT_FAILURE);
    }
    if(is_int(argv[1]) < 0)
    {
        printf("ERROR INPUT!!!\n");
        printf_help2();
        exit(EXIT_FAILURE);
    }
    preNetType = atoi(argv[1]);

    DEBUG("preNetType = %d\n", preNetType);
    sms_demo_init(preNetType);

    while(1)
    {
        printf("Please input requirement:\n");
        fgets(arg_string, MAX_INPUT, stdin);
        delete_enter(arg_string);
        if (arg_string == NULL)
        {
            printf("ERROR INPUT!!!\n");
            printf_help();
            goto end;
        }
        
        q = strtok(arg_string, " ");
        if(q == NULL)
        {
            printf_help();
            goto end;
        }
        input[0] = q;
        p = q;     
        for(i = 0; q != NULL; i++)
        {
            input[i] = q;
            q = strtok(NULL, " ");
        }
        if(i > 4)//错误的传参数量
        {
            printf("arg number error\n");
            printf_help();
        }

        if(strcmp(p,"-h") == 0)
        {
            printf_help();
        }
        //**************************send message************************************
        else if(strcmp(p,"--send") == 0)
        {
            DEBUG("arg_num: %d\n", i);
            if(i != 4)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            if(strlen(input[1]) > SMSC_MAX_LEN)
            {
                printf("ERROR: smsc address out of range\n");
                goto end;
            }
            else if(strlen(input[2]) > TELEPHONE_NUM_LEN)
            {
                printf("ERROR: phone number out of range\n");
                goto end;
            }
            if(is_int(input[3]) < 0)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            strcpy(smsc_address, input[1]);
            strcpy(phone_num, input[2]);
            charset = atoi(input[3]);
            if((charset != 0) && (charset != 1) && (charset != 2))
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }

            printf("===Attention: The message content needs to be wrapped in double quotes===\nInput the message content:\n");
            fgets(msg , MSG_MAX_LEN, stdin);//注意：短消息内容需要用双引号("")引起来。
            delete_enter(msg);

            DEBUG("send message arg: %s, %s, %d, %s\n", smsc_address, phone_num, charset, msg);
            ret = demo_send_message(smsc_address, phone_num, charset, msg);
            if(ret < 0)
            {
                printf("send message error! \n");
                goto end;
            }
        }
        //***************************list all message********************************************
        else if(strcmp(p,"--list") == 0)
        {
            if(i != 1)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            
            ret = demo_list_all_msg();
            if(ret < 0)
            {
                printf("list all message error!\n");
                goto end;
            }
        }
        //****************************delete message with index**********************************
        else if(strcmp(p,"--delete") == 0)
        {
            if(i != 2)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            if(is_int(input[1]) < 0)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            index = atoi(input[1]);
            if (index > SMS_NUM_MAX || index <= 0)
            {
                printf("ERROR: index over range(1~255)!!!\n");
                printf_help();
                goto end;
            }

            DEBUG("delete message arg: %d\n", index);
            ret = demo_delete_message(index);
            if(ret < 0)
            {
                printf("delete message error!\n");
                goto end;
            }
        }
        //*****************************set smsc address******************************************
        else if(strcmp(p,"--set-smsc") == 0)
        {
            if(i != 2)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            if(strlen(input[1]) > SMSC_MAX_LEN)
            {
                printf("ERROR: smsc address out of range\n");
                goto end;
            }

            strcpy(smsc_address, input[1]);
            DEBUG("set smsc arg: %s\n", smsc_address);
            ret = demo_set_smsc_address(smsc_address);
            if(ret < 0)
            {
                printf("set smsc error! \n");
                goto end;
            }
        }
        //******************************get smsc adress******************************************
        else if(strcmp(p,"--get-smsc") == 0)
        {
            if(i != 1)
            {
                printf("ERROR INPUT!!!\n");
                printf_help();
                goto end;
            }
            ret = demo_get_smsc_address();
            if(ret < 0)
            {
                printf("get smsc error! \n");
                goto end;
            }
        }
        else if(strcmp(p,"--exit") == 0)
        {
            break;
        }
        else
        {
            printf("error input\n");
            printf_help();
        }
end:
        input[0] = NULL;
        input[1] = NULL;
        input[2] = NULL;
        input[3] = NULL;
        input[4] = NULL;
    } 
deinit:
    sms_demo_deinit();
    return 0;
}
