#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pthread.h>
#include <unistd.h>
#include <dlfcn.h>


#undef LOG_TAG
#define LOG_TAG "WAKELOCK_DEMO"
//static pthread_mutex_t s_urc_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
//static pthread_cond_t s_urc_call_state_change_cond = PTHREAD_COND_INITIALIZER;

void *dlHandle_wakelock;
void *dlHandle_log;


enum {
    PARTIAL_WAKE_LOCK = 1,  // the cpu stays on, but the screen is off
    FULL_WAKE_LOCK = 2      // the screen is also on
};

// while you have a lock held, the device will stay on at least at the
// level you request.

int (*acquire_wake_lock)(int lock, const char* id);
int (*release_wake_lock)(const char* id);


void init_call_func(void)
{
    const char *lynqLibPath_WakeLock = "/usr/lib64/libpower.so";
    const char *lynqLibPath_Log = "/lib64/liblynq-log.so";

    dlHandle_wakelock = dlopen(lynqLibPath_WakeLock, RTLD_NOW);
    if (dlHandle_wakelock == NULL) 
    {
        printf("dlopen lynqLibPath_WakeLock failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    dlHandle_log = dlopen(lynqLibPath_Log, RTLD_NOW);
    if (dlHandle_log == NULL) 
    {
        printf("dlopen dlHandle_log failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }
    acquire_wake_lock = (int(*)(int,const char*))dlsym(dlHandle_wakelock, "acquire_wake_lock");
    if (acquire_wake_lock == NULL) {
        printf("acquire_wake_lock not defined or exported in %s", lynqLibPath_WakeLock);
        exit(EXIT_FAILURE);
    }
    release_wake_lock = (int(*)( const char*))dlsym(dlHandle_wakelock, "release_wake_lock");
    if (release_wake_lock == NULL) {
        printf("release_wake_lock not defined or exported in %s", lynqLibPath_WakeLock);
        exit(EXIT_FAILURE);
    }
    dlerror(); // Clear any previous dlerror

  return;
}


int main(int argc,char** argv)
{

    init_call_func();
    if (argc != 3)
    {
        printf("wrong input format.\n");
        return -1;
    }


    if (strcmp(argv[1],"-a") == 0)
    {
        if (acquire_wake_lock(PARTIAL_WAKE_LOCK,argv[2]) < 0)
        {
            printf("acquire_wake_lock : %s fail.\n",argv[2]);
            return -1;
        }
        else  
        {
            printf("acquire_wake_lock : %s success.\n",argv[2]);
            return 0;
        }
        
    }
    else if (strcmp(argv[1],"-r") == 0)
    {
        if (release_wake_lock(argv[2]) < 0)
        {
            printf("release_wake_lock : %s fail.\n",argv[2]);
            return -1;
        }
        else
        {
            printf("release_wake_lock : %s success.\n",argv[2]);
            return 0;
        }   
    }
    else
    {
        printf("wrong input format.\n");
        return -1;
    }


}
