/**@File wifi_test.c
*  @Brief :about function test
*  @details :
*  @Author : qs.xiong
*  @Date : 2022-3-14
*  @Version : V1.0
*  @copy ritght : Copyright (c) MobileTek
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>

void *handle_wifi;

#ifdef __cplusplus
extern "C" {
#endif
#ifdef __cplusplus
}
#endif

typedef enum {
	LYNQ_WIFI_WORK_MODE_STA=0,		/*WiFi is in STA mode */
	LYNQ_WIFI_WORK_MODE_AP,			/*WiFi is in AP mode */
}lynq_wifi_work_mode_m;

typedef enum {
	LYNQ_WIFI_BANDWIDTH_HT20 = 0,	
	LYNQ_WIFI_BANDWIDTH_HT80,		
}lynq_wifi_bandwidth_type_m;

typedef enum {
	LYNQ_WIFI_AUTH_OPEN = 0,
	LYNQ_WIFI_AUTH_WPA_PSK,
}lynq_wifi_ap_auth_s;

typedef enum {
	LYNQ_WIFI_STA_AUTH_OPEN = 0,
	LYNQ_WIFI_STA_AUTH_WPA_PSK,
}lynq_wifi_sta_auth_s;

typedef enum {
	LYNQ_NETWORK_0 =0,
	LYNQ_NETWORK_1,
	LYNQ_NETWORK_2,
	LYNQ_NETWORK_3,
	LYNQ_NETWORK_4,
	LYNQ_NETWORK_5,
	LYNQ_NETWORK_6,
	LYNQ_NETWORK_7,
	LYNQ_NETWORK_8,
	LYNQ_NETWORK_9,
}lynq_wifi_index_e;


int (*lynq_wifi_enable)(void);
int (*lynq_wifi_disable)(void);
int (*lynq_wifi_wpa_start)(void);
int (*lynq_wifi_wpacli_start)(void);
int (*lynq_wifi_work_mode_get)(lynq_wifi_work_mode_m *mode);
int (*lynq_wifi_ap_ssid_set)(lynq_wifi_index_e idx,char *ap_ssid);
int (*lynq_wifi_ap_ssid_get)(lynq_wifi_index_e idx,char *ap_ssid);
int (*lynq_wifi_ap_frequency_set)(lynq_wifi_index_e idx,int lynq_wifi_frequency);
int (*lynq_wifi_ap_frequency_get)(lynq_wifi_index_e idx,int *lynq_wifi_frequency);
int (*lynq_wifi_ap_bandwidth_get)(lynq_wifi_index_e idx,lynq_wifi_bandwidth_type_m *bandwidth);
int (*lynq_wifi_ap_channel_get)(lynq_wifi_index_e idx,int* channel);
int (*lynq_wifi_ap_auth_set)(lynq_wifi_index_e idx, lynq_wifi_ap_auth_s auth);
int (*lynq_wifi_ap_auth_get)(lynq_wifi_index_e idx, lynq_wifi_ap_auth_s *auth);
int (*lynq_wifi_ap_max_sta_get)(lynq_wifi_index_e idx,int* max_sta_num);
int (*lynq_wifi_ap_start)(lynq_wifi_index_e idx);
int (*lynq_wifi_ap_restart)(lynq_wifi_index_e idx);
int (*lynq_wifi_ap_stop)(lynq_wifi_index_e idx);
int (*lynq_wifi_ap_hide_ssid)(lynq_wifi_index_e idx);
int (*lynq_ap_ssid_pass_set)(lynq_wifi_index_e idx,char *password);


int main(int argc, char *argv[])
{
    printf("[LYNQ_WIFI_DEMO]--------->[%s,%d] start \n",__FUNCTION__,__LINE__);
    int ret = -1;
    int get_ap_frequency = -1;
    int get_ap_channel=-1;
    int get_max_sta_num=-1;
	int test_freq = 5180;
	char test_ssid[50] = "TEST_SSID_5G";
    char get_ap_ssid[50]={0};
	char test_pass[25] = "12345678";
	
	lynq_wifi_index_e idxd;
    lynq_wifi_ap_auth_s set_ap_auth;
    lynq_wifi_work_mode_m get_work_mode;
    lynq_wifi_ap_auth_s get_ap_auth;
    lynq_wifi_bandwidth_type_m get_ap_bandwidth;
  
    const char *lynqLibpathWifi = "/lib64/liblynq-wifi6.so";
   
    handle_wifi = dlopen(lynqLibpathWifi,RTLD_NOW);
    if(NULL == handle_wifi)
    {
        printf("dlopen lynqLibpathWifi fail:%s\n",dlerror());
        exit(EXIT_FAILURE);
    }
   
    lynq_wifi_enable = (int(*)())dlsym(handle_wifi,"lynq_wifi_enable");
    if(NULL == lynq_wifi_enable)
    {
        printf("lynq_wifi_enable not defined or exported in %s\r\n", lynqLibpathWifi);
        exit(EXIT_FAILURE);
    }
    
    ret = lynq_wifi_enable();	//< insmod drv wg870/cyw955572
    if(ret != 0)
    {
        printf("lynq_wifi_enable defalut\n");
    }

        lynq_wifi_wpa_start = (int(*)())dlsym(handle_wifi,"lynq_wifi_wpa_start");
    if(NULL == lynq_wifi_wpa_start)
    {
        printf("lynq_wifi_wpa_start not defined or exported in %s\r\n", lynqLibpathWifi);
        exit(EXIT_FAILURE);
    }
    
    ret = lynq_wifi_wpa_start();	//< start supplicant
    if(ret != 0)
    {
        printf("lynq_wifi_wpa_start defalut\n");
    }
    
    lynq_wifi_wpacli_start = (int(*)())dlsym(handle_wifi,"lynq_wifi_wpacli_start");
    if(NULL == lynq_wifi_wpacli_start)
    {
        printf("lynq_wifi_wpacli_start not defined or exported in %s\r\n", lynqLibpathWifi);
        exit(EXIT_FAILURE);
    }
    
    ret = lynq_wifi_wpacli_start();	//< start supplicant
    if(ret != 0)
    {
        printf("lynq_wifi_wpacil_start defalut\n");
    }
   
   

	 idxd=LYNQ_NETWORK_0;

	 printf("into case 0 start ap test\n");
	 set_ap_auth=LYNQ_WIFI_AUTH_WPA_PSK;
	 lynq_wifi_ap_ssid_set = (int (*)(lynq_wifi_index_e idx,char *ap_ssid))dlsym(handle_wifi,"lynq_wifi_ap_ssid_set");
	
	 if(NULL != lynq_wifi_ap_ssid_set)
	 {
		ret = lynq_wifi_ap_ssid_set(idxd,test_ssid);	//< set ssid for ap
		if(ret == 0)
		{
			printf("set ssid success");
		}else{
			printf("set ssid error\n");
		}
	}else{
		printf("lynq_wifi_ap_ssid_set dlsym error\n");
	}
		
	lynq_wifi_ap_auth_set = (int (*)(lynq_wifi_index_e idx, lynq_wifi_ap_auth_s auth))dlsym(handle_wifi,"lynq_wifi_ap_auth_set");
	if(NULL != lynq_wifi_ap_auth_set)
	{
		ret = lynq_wifi_ap_auth_set(idxd,set_ap_auth);	//< set ap work with WPA2 
		if(ret == 0)
		{
			printf("set auth success");
		}else{
			printf("set auth error\n");
		}
	}else{
		printf("lynq_wifi_ap_auth_set dlsym error\n");
	}
	
	lynq_ap_ssid_pass_set = (int (*)(lynq_wifi_index_e idx,char *password))dlsym(handle_wifi,"lynq_ap_ssid_pass_set");
	if(NULL != lynq_ap_ssid_pass_set)
	{
		ret = lynq_ap_ssid_pass_set(idxd,test_pass);	//< set password for ap
		if(ret == 0)
		{
			printf("set password success");
		}else{
			printf("set password error\n");
		}
	}else{
		printf("lynq_ap_ssid_pass_set dlsym error\n");
	}
	lynq_wifi_ap_frequency_set = (int (*)(lynq_wifi_index_e idx,int lynq_wifi_frequency))dlsym(handle_wifi,"lynq_wifi_ap_frequency_set");
	if(NULL != lynq_wifi_ap_frequency_set)
	{
		ret = lynq_wifi_ap_frequency_set(idxd,test_freq);	//< set freq and 
		if(ret == 0)
		{
			printf("set frequency success");
		}else{
			printf("set frequency error\n");
		}
	}else{
		printf("lynq_wifi_ap_frequency_set dlsym error\n");
	}
	lynq_wifi_ap_start = (int (*)(lynq_wifi_index_e idx))dlsym(handle_wifi,"lynq_wifi_ap_start");
	if(NULL != lynq_wifi_ap_start)
	{
		ret = lynq_wifi_ap_start(idxd);	//< start ap
		if(ret == 0)
		{
			printf("start ap success");
		}else{
			printf("start ap error\n");
		}
	}else{
		printf("lynq_wifi_ap_start dlsym error\n");
	}
	
	sleep(5);
	lynq_wifi_ap_ssid_get = (int (*)(lynq_wifi_index_e idx,char *ap_ssid))dlsym(handle_wifi,"lynq_wifi_ap_ssid_get");
	if(NULL != lynq_wifi_ap_ssid_get)
	{   
		ret = lynq_wifi_ap_ssid_get(idxd,get_ap_ssid);	//< get ssid of ap
		if(ret == 0)
		{
			printf("get ap_ssid success %s\n",get_ap_ssid);
		}else{
			printf("set ap_ssid error\n");
		}
	}else{
		printf("lynq_wifi_ap_ssid_get dlsym error\n");
	}


	lynq_wifi_ap_frequency_get = (int (*)(lynq_wifi_index_e idx,int *lynq_wifi_frequency))dlsym(handle_wifi,"lynq_wifi_ap_frequency_get");
	if(NULL != lynq_wifi_ap_frequency_get)
	{   
		ret = lynq_wifi_ap_frequency_get(idxd,&get_ap_frequency);	//< get ap frequency
		if(ret == 0)
		{
			printf("get frequency success %d\n",get_ap_frequency);
		}else{
			printf("get frequency error\n");
		}
	}else{
		printf("lynq_wifi_ap_frequency_get dlsym error\n");
	}

	lynq_wifi_work_mode_get = (int (*)(lynq_wifi_work_mode_m *mode))dlsym(handle_wifi,"lynq_wifi_work_mode_get");
	if(NULL != lynq_wifi_work_mode_get)
	{   
		ret = lynq_wifi_work_mode_get(&get_work_mode);	//< get wifi mode
		if(ret == 0)
		{
			printf("get work_mode success： %d\n",get_work_mode);
		}else{
			printf("get work_mode error\n");
		}
	}else{
		printf("lynq_wifi_work_mode_get dlsym error\n");
	}


	lynq_wifi_ap_auth_get = (int (*)(lynq_wifi_index_e idx, lynq_wifi_ap_auth_s *auth))dlsym(handle_wifi,"lynq_wifi_ap_auth_get");
	if(NULL != lynq_wifi_ap_auth_get)
	{   
		ret = lynq_wifi_ap_auth_get(idxd,&get_ap_auth);	//< get wifi auth
		if(ret == 0)
		{
			printf("get ap_auth success： %d\n",get_ap_auth); //< 0 is OPEN 1 is WPA-PSK
		}else{
			printf("get ap_auth error\n");
		}
	}else{
		printf("lynq_wifi_ap_auth_get dlsym error\n");
	}

	lynq_wifi_ap_bandwidth_get = (int (*)(lynq_wifi_index_e idx, lynq_wifi_bandwidth_type_m *bandwidth))dlsym(handle_wifi,"lynq_wifi_ap_bandwidth_get");
	if(NULL != lynq_wifi_ap_bandwidth_get)
	{   
		ret = lynq_wifi_ap_bandwidth_get(idxd,&get_ap_bandwidth);	//< get ap bandwidth
		if(ret == 0)
		{
			printf("get bandwidth success %d\n",get_ap_bandwidth); //< 0 is 20HMz 1 is 80HMz
		}else{
			printf("get bandwidth error\n");
		}
	}else{
		printf("lynq_wifi_ap_bandwidth_get dlsym error\n");
	}


	lynq_wifi_ap_channel_get = (int (*)(lynq_wifi_index_e idx,int* channel))dlsym(handle_wifi,"lynq_wifi_ap_channel_get");
	if(NULL != lynq_wifi_ap_channel_get)
	{   
		ret = lynq_wifi_ap_channel_get(idxd,&get_ap_channel);	//< get ap channel
		if(ret == 0)
		{
			printf("get channel success %d\n",get_ap_channel); 
		}else{
			printf("get channel error\n");
		}
	}else{
		printf("lynq_wifi_ap_channel_get dlsym error\n");
	}

	lynq_wifi_ap_max_sta_get = (int (*)(lynq_wifi_index_e idx,int* max_sta_num))dlsym(handle_wifi,"lynq_wifi_ap_max_sta_get");
	if(NULL != lynq_wifi_ap_max_sta_get)
	{   
		ret = lynq_wifi_ap_max_sta_get(idxd,&get_max_sta_num);	
		if(ret == 0)
		{
			printf("get max_sta_num success %d\n",get_max_sta_num); 
		}else{
			printf("get max_sta_num error\n");
		}
	}else{
		printf("lynq_wifi_ap_max_sta_get dlsym error\n");
	}

	sleep(10);
	lynq_wifi_ap_hide_ssid = (int (*)(lynq_wifi_index_e idx))dlsym(handle_wifi,"lynq_wifi_ap_hide_ssid");
	if(NULL != lynq_wifi_ap_channel_get)
	{   
		ret = lynq_wifi_ap_hide_ssid(idxd);	//< hide the ssid
		if(ret == 0)
		{
			printf("hide ssid success\n"); 
		}else{
			printf("hide ssid error\n");
		}
	}else{
		printf("lynq_wifi_ap_hide_ssid dlsym error\n");
	}

    return 0;
}
