/**@File libwifi6.h
*  @Brief :about function test
*  @details :
*  @Author : qs.xiong
*  @Date : 2022-3-14
*  @Version : V1.0
*  @copy ritght : Copyright (c) MobileTek
*/
#ifndef __LIBWIFI6_H__
#define __LIBWIFI6_H__

typedef enum {
    LYNQ_WIFI_BANDWIDTH_HT10 = 0, // not support in ap mode
    LYNQ_WIFI_BANDWIDTH_HT20,
    LYNQ_WIFI_BANDWIDTH_HT40,    // not support in ap mode
    LYNQ_WIFI_BANDWIDTH_HT80,
}lynq_wifi_bandwidth_type_m;

typedef enum {
    LYNQ_WIFI_AUTH_OPEN = 0,
    LYNQ_WIFI_AUTH_WEP,
    LYNQ_WIFI_AUTH_WPA_PSK,
    LYNQ_WIFI_AUTH_WPA2_PSK,
}lynq_wifi_auth_s;

typedef enum {
    LYNQ_WIFI_2G_band = 1,
    LYNQ_WIFI_5G_band,
    LYNQ_WIFI_2_and_5G_band,  //not support
}lynq_wifi_band_m;

typedef enum {
    LYNQ_WIFI_AP_STATUS_DISABLE = 0,   
    LYNQ_WIFI_AP_STATUS_ENABLE,        //ap is running status
}lynq_wifi_ap_run_status_s;

typedef enum {
    LYNQ_WIFI_STA_STATUS_DISABLE = 0,
    LYNQ_WIFI_STA_STATUS_ENABLE,       //sta is running status
}lynq_wifi_sta_run_status_s;

typedef enum {
    LYNQ_WIFI_INTERFACE_0 = 0,      //sta
    LYNQ_WIFI_INTERFACE_1,         //ap
}lynq_wifi_index_e;

typedef enum {
    LYNQ_WIFI_STATUS_DISCONNECT = 0,
    LYNQ_WIFI_STATUS_CONNECT,
}lynq_wifi_ap_status_s;

typedef struct ap_info
{
    char ap_ip[32];
    char ap_mac[32];
    char ap_ssid[64];
    char psw[64];                      //password 
    lynq_wifi_auth_s auth;
    lynq_wifi_band_m band;
}ap_info_s;

typedef struct device_info
{
    char sta_ip[32];
    char sta_mac[32];
    char hostname[32];
    lynq_wifi_ap_status_s status;
}device_info_s;                

typedef struct scan_info
{
    char mac[32];
    char ssid[64];
    lynq_wifi_band_m band;
    lynq_wifi_auth_s auth;
    int rssi;
}scan_info_s;

typedef struct ap_detail_info
{
    struct ap_info base_info;            // base_info : base info of strcut ap_info 
    lynq_wifi_ap_run_status_s status;     // status:is not running 1:is running
    int rssi;                         //[0~199]
}ap_detail_info_s;

typedef struct saved_ap_info
{
    struct ap_info base_info;
}saved_ap_info_s;


// insmod drive and start service of wifi
int lynq_wifi_enable(void);
//rmmod drive
int lynq_wifi_disable(void);
//set ssid of ap
int lynq_wifi_ap_ssid_set(lynq_wifi_index_e idx,char *ap_ssid);
//get ap of ssid
int lynq_wifi_ap_ssid_get(lynq_wifi_index_e idx,char *ap_ssid);

//set frquency for ap
int lynq_wifi_ap_frequency_set(lynq_wifi_index_e idx,int lynq_wifi_frequency);
//get freuency of ap
int lynq_wifi_ap_frequency_get(lynq_wifi_index_e idx,int *lynq_wifi_frequency);

//set bandwidth for ap
int lynq_wifi_ap_bandwidth_set(lynq_wifi_index_e idx,lynq_wifi_bandwidth_type_m bandwidth);
//get thr bandwidth of ap
int lynq_wifi_ap_bandwidth_get(lynq_wifi_index_e idx,lynq_wifi_bandwidth_type_m *bandwidth);

//set channel for ap
int lynq_wifi_ap_channel_set( lynq_wifi_index_e idx,int channel);
//get channel of ap 
int lynq_wifi_ap_channel_get( lynq_wifi_index_e idx,int* channel);

//set auth for ap
int lynq_wifi_ap_auth_set(lynq_wifi_index_e idx, lynq_wifi_auth_s auth);
//get ap auth
int lynq_wifi_ap_auth_get(lynq_wifi_index_e idx, lynq_wifi_auth_s *auth);

//start ap
int lynq_wifi_ap_start(lynq_wifi_index_e idx);
//stop ap
int lynq_wifi_ap_stop(lynq_wifi_index_e idx);
//restart ap
int lynq_wifi_ap_restart(lynq_wifi_index_e idx);

//hide ssid
int lynq_wifi_ap_hide_ssid(lynq_wifi_index_e idx);
//unhide ssid
int lynq_wifi_ap_unhide_ssid(lynq_wifi_index_e idx);

//set the password for ap
int lynq_ap_password_set(lynq_wifi_index_e idx, char *password);
//get the ap password
int lynq_ap_password_get(lynq_wifi_index_e idx, char *password);

//set the password to connet to dest_ap
int lynq_sta_ssid_password_set(lynq_wifi_index_e idx, ap_info_s *ap, char *password);
int lynq_sta_ssid_password_get(lynq_wifi_index_e idx, ap_info_s *ap, char *password);

//get the ssid of sta
int lynq_wifi_get_sta_ssid(lynq_wifi_index_e idx,char *sta_ssid);
//get availble device info such as:ssid mac band rssi status auth
int lynq_wifi_get_sta_available_ap(lynq_wifi_index_e idx,ap_detail_info_s *info);  



//get the sta connect ap auth
int lynq_wifi_get_sta_auth(lynq_wifi_index_e idx, lynq_wifi_auth_s* auth);    //auth 0:OPEN 1:WEP 2:WPA-PSK 3:WPA2-PSK

//sta start connect to dest_ap
int lynq_wifi_sta_connect(lynq_wifi_index_e idx, char *ssid, lynq_wifi_auth_s auth, char *psw);
//disconnect 
int lynq_wifi_sta_disconnect(lynq_wifi_index_e idx,char *ssid);

//start sta mode;enable sta
int lynq_wifi_sta_start(lynq_wifi_index_e idx);
//stop sta:disable sta
int lynq_wifi_sta_stop(lynq_wifi_index_e idx);

//Get all device info linked ap
int lynq_get_ap_device_list(lynq_wifi_index_e idx, ap_info_s **ap, device_info_s ** list,int * len);        //list info:mac ip hostname status  len:device len
//Get scan_result info
int lynq_get_scan_list(lynq_wifi_index_e idx, scan_info_s ** list,int * len);                    //list info:mac ssid band auth rssi    len:scan_info len
int lynq_sta_forget_ap(lynq_wifi_index_e idx, char *ssid,lynq_wifi_auth_s auth);
int lynq_get_sta_saved_ap(lynq_wifi_index_e idx,saved_ap_info_s ** list,int * len);      //len: length of saved_ap_info

//start scan availbale ap active
int lynq_wifi_sta_start_scan(lynq_wifi_index_e idx);

/*
 * event usage:
 * first declare a funcion like AP_CALLBACK_FUNC_PTR to recv messge from wifi lib
 * call lynq_reg_ap_event_callback to register whih private data pointer and the callback fuction pointer declared before
 * when envent comes the last registered callback function will been called
 */

typedef void(*AP_CALLBACK_FUNC_PTR)(void *priv, lynq_wifi_ap_status_s status);
int lynq_reg_ap_event_callback(void *priv, AP_CALLBACK_FUNC_PTR cb);
int lynq_unreg_ap_event_callback(void *priv);

typedef enum {
    LYNQ_WIFI_STA_STATUS_DISCONNECT = 0,
    LYNQ_WIFI_STA_STATUS_CONNECT,
    LYNQ_WIFI_STA_STATUS_SCAN_RESULT,    //finish sta scan 
}lynq_wifi_sta_status_s;
typedef enum
{
    LYNQ_TIME_OUT = 0,
    LYNQ_PSW_ERROR,
    LYNQ_AUTH_ERROR,
    LYNQ_NOT_FIND_AP,
}error_number_s;

typedef void(*STA_CALLBACK_FUNC_PTR)(void *priv, lynq_wifi_sta_status_s status, error_number_s number);
int lynq_reg_sta_event_callback(void * priv, STA_CALLBACK_FUNC_PTR cb);
int lynq_unreg_sta_event_callback(void * priv);

//get current ap status
int lynq_get_ap_status(lynq_wifi_index_e idx, lynq_wifi_ap_run_status_s * ap_status);
//get curent sta status
int lynq_get_sta_status(lynq_wifi_index_e idx, lynq_wifi_sta_run_status_s * sta_status);

//set the country code 
int lynq_get_country_code(lynq_wifi_index_e idx, char *country_code);
//get current country code
int lynq_set_country_code(lynq_wifi_index_e idx, char *country_code);

//get wlan0/ap0 ip or mac
int lynq_get_interface_ip(lynq_wifi_index_e idx,char *ip);
int lynq_get_interface_mac(lynq_wifi_index_e idx,char *mac);   


//get current connect ap mac rssi band
int lynq_get_connect_ap_mac(lynq_wifi_index_e idx,char *mac);
int lynq_get_connect_ap_rssi(lynq_wifi_index_e idx,int * rssi);
int lynq_get_connect_ap_band(lynq_wifi_index_e idx,lynq_wifi_band_m * band);
int lynq_get_connect_ap_ip(lynq_wifi_index_e idx,char *ip);

#endif
