/**@File wifi_test.c
*  @Brief :about function test
*  @details :
*  @Author : qs.xiong
*  @Date : 2022-6-21
*  @Version : V1.1
*  @copy ritght : Copyright (c) MobileTek
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>

void *handle_wifi;

#ifdef __cplusplus
extern "C" {
#include "libwifi6.h"
#endif
#ifdef __cplusplus
}
#endif



int lynq_set_ap_init(char *ssid,char *auth,char *freq,char *password){
    
    int ret = -1;
    int test_freq = -1;   
    int input_auth = -1;
	
    lynq_wifi_index_e idxd;                          //ap
    lynq_wifi_auth_s set_ap_auth;
    
    idxd=LYNQ_WIFI_INTERFACE_1;	
    input_auth=atoi(auth);
    set_ap_auth=(lynq_wifi_auth_s)input_auth;
    test_freq=atoi(freq);
    ret = lynq_wifi_ap_ssid_set(idxd,ssid);	//< set ssid for ap
    if(ret == 0)
    {
        printf("set ssid success");
    }else{
        printf("set ssid error\n");
    }
    ret = lynq_wifi_ap_auth_set(idxd,set_ap_auth);	//< set ap work with WPA2 
    if(ret == 0)
    {
        printf("set auth success");
    }else{
        printf("set auth error\n");
    }
    ret = lynq_ap_password_set(idxd,password);	//< set password for ap
    if(ret == 0)
    {
        printf("set password success");
    }else{		
        printf("set password error\n");
    }
    ret = lynq_wifi_ap_frequency_set(idxd,test_freq);	//< set freq and 
    if(ret == 0)
    {
        printf("set frequency success");
    }else{
        printf("set frequency error\n");
    }
    ret = lynq_wifi_ap_start(idxd);	//< start ap
    if(ret == 0)
    {
        printf("start ap success");
    }else{
        printf("start ap error\n");
        }
            return 0;
}


int lynq_set_sta_init(char * test_ssid,char * auth,char * password){
    
    int ret = -1;
    int input_auth = -1;
    char test_pass[25] = "";
    lynq_wifi_index_e idxd = LYNQ_WIFI_INTERFACE_0;
    
    input_auth=atoi(auth);   
    lynq_wifi_auth_s set_ap_auth;
    set_ap_auth=(lynq_wifi_auth_s)input_auth;	

    ret = lynq_wifi_sta_start(idxd);
    if ( ret == 0 ){
    printf("lynq_wifi_sta_start is sucssec\n");
    }else{
    printf("lynq_wifi_sta_start is fail\n");
    }

     ret = lynq_wifi_sta_connect(idxd, test_ssid, set_ap_auth, password);
     if ( ret == 0 ){
     printf("lynq_wifi_sta_connect is sucssec\n");
     }else{
     printf("lynq_wifi_sta_connect is fail\n");
     }

     return ret;
}

int lynq_get_ap_device_list(void){
    
    lynq_wifi_index_e idxd;
    int ret = -1;
    int len = -1;
    int i = 0;
	idxd = LYNQ_WIFI_INTERFACE_1;

    ap_info_s * ap_s_ptr = NULL;
	device_info_s* dev_s_ptr = NULL;
    device_info_s * ptr = NULL;

    printf("[lynq_get_ap_device_list]--------->[%s,%d] start \n",__FUNCTION__,__LINE__);
    ret = lynq_get_ap_device_list(idxd,&ap_s_ptr,&dev_s_ptr,&len);
    if(ret != 0)
    {
        printf("lynq_wifi_wpa_start defalut\n");
        return -1;
    }
   
     ptr = dev_s_ptr;

    printf("lynq_get_ap_device_list before for start\n");
    for (i=0;i<len;++i){
        printf("[LYNQ_WIFI_DEMO]--------->[%s,%d] start \n",__FUNCTION__,__LINE__);
	    printf("lynq_get_ap_device_list for start\n");
        printf("dev[%d] [ip]:%s,[mac]:%s,[hostname]:%s,[connect status]:%s\n",i,ptr->sta_ip,ptr->sta_mac,
        ptr->hostname,LYNQ_WIFI_STATUS_CONNECT == ptr->status ? "connect":"disconnect");
        ptr++;
    }
    free(ap_s_ptr);
    free(dev_s_ptr);
    return 0;
}

int main(char * argc,char * argv[]){

    printf("[LYNQ_WIFI_DEMO]--------->[%s,%d] start \n",__FUNCTION__,__LINE__);
    int cs = -1; 
    int dev = -1;
    int ret = -1;


    ret = lynq_wifi_enable();	//< insmod drv wg870/cyw955572
    if(ret != 0)
    {	
        printf("lynq_wifi_enable defalut\n");
    }
    cs=atoi(argv[1]);

    /*
    *   cs:为0 is sta mode
    *   cs:为1 is ap  mode
    *
    */

    if( cs == 0 ){
        if(lynq_set_sta_init(argv[2],argv[3],argv[4]) != 0){
            printf("sta init error");
        }

    }else if( cs == 1 ){
        if(lynq_set_ap_init(argv[2],argv[3],argv[4],argv[5]) !=0 ){
            printf("ap init error\n");
        }
    }
     printf("input 1 to get ap_device_list\n");
     printf("input other number break code\n");
     scanf("%d",&dev);

     switch (dev)
     {
     case 1/* constant-expression */:
        /* code */
        ret = lynq_get_ap_device_list();
        if(ret != 0){
            printf("start lynq_get_ap_device_list(void) defulat\n");
        }
        break;
     
     default:
        break;
    }

    return 0;
}






