#inherit externalsrc package
DESCRIPTION = "wifi6 demo"
LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
SRC_URI = "file://libwifi6.h file://wifi6-demo.cpp file://LICENSE"

DEPENDS += "lynq-rootfs"
do_compile[depends] = "lynq-rootfs:do_install"

TARGET_CC_ARCH += "${LDFLAGS}"

LOCAL_C_INCLUDES = "-I."

LOCAL_LIBS = "-L. -ldl -lstdc++ -lpthread -llynq-wifi6"

SOURCES = "$(wildcard *.cpp )"

OBJECTS = "$(SOURCES:.cpp=.o)"

EXECUTABLE = "wifi6-demo"
S = "${WORKDIR}"


INSANE_SKIP_${PN} = "ldflags"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
INHIBIT_PACKAGE_STRIP = "1"

do_compile_prepend() {
  . ${TOPDIR}/rootbase.sh
  cp -rf ${ROOTFS_BASE}/* ${STAGING_DIR_HOST}/

}

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	${CXX} -Wall wifi6-demo.cpp ${LOCAL_LIBS} ${LOCAL_C_INCLUDES} -o ${EXECUTABLE}
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/wifi6-demo ${D}${bindir}/
	install -d ${D}${includedir}
    install -d ${D}/lib64/
    install -m 644 ${STAGING_DIR_HOST}/lib64/liblynq-wifi6.so  ${D}/lib64/
}
