#!/usr/bin/env python

import sys
import os


if len(sys.argv) != 2:
    print('Usage : align_4kb [file_name]')
    sys.exit()

if not os.path.isfile(sys.argv[1]):
    print(sys.argv[1] + ' not exist')
    sys.exit()

if os.path.getsize(sys.argv[1]) % 4096 == 0:
    print('file size is 4KB alignment')
    sys.exit()

file_src = sys.argv[1]
file_dst = os.path.splitext(
    file_src)[0] + "_original" + os.path.splitext(file_src)[1]

if os.path.exists(file_dst):
    os.remove(file_dst)

os.rename(file_src, file_dst)

file_src = file_dst
file_dst = sys.argv[1]

with open(file_dst, 'ab') as fdst:
    with open(file_src, 'rb') as fsrc:
        data = fsrc.read()
        len_diff = 4096 - len(data) % 4096
        fdst.write(data)
    if len_diff:
        fdst.write(b'\xff' * len_diff)
