# SPDX-License-Identifier: MediaTekProprietary

#!/usr/bin/python
import os

socfactoryprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'oem', 'nanderaseblock', '0'],
                ['fastboot', 'oem', 'nanderaseblock', '1'],
                ['fastboot', 'flash', 'nand0', 'MBR_NAND'],
                ['fastboot', 'erase', 'bl2_a'],
                ['fastboot', 'flash', 'bl2_a', 'bl2.img'],
                ['fastboot', 'erase', 'bl2_b'],
                ['fastboot', 'flash', 'bl2_b', 'bl2.img'],
                ['fastboot', 'erase', 'bl33_a'],
                ['fastboot', 'flash', 'bl33_a', 'bl33.img'],
                ['fastboot', 'erase', 'bl33_b'],
                ['fastboot', 'flash', 'bl33_b', 'bl33.img'],
                ['fastboot', 'erase', 'spm_a'],
                ['fastboot', 'flash', 'spm_a', 'spmfw.img'],
                ['fastboot', 'erase', 'spm_b'],
                ['fastboot', 'flash', 'spm_b', 'spmfw.img'],
                ['fastboot', 'erase', 'dtbo'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'erase', 'hsm_bl'],
                ['fastboot', 'flash', 'hsm_bl', 'hsm_bl.img'],
                ['fastboot', 'erase', 'hsm_os_a'],
                ['fastboot', 'flash', 'hsm_os_a', 'hsm_os.img'],
                ['fastboot', 'erase', 'hsm_os_b'],
                ['fastboot', 'flash', 'hsm_os_b', 'hsm_os.img'],
                ['fastboot', 'erase', 'boot_para'],
                ['fastboot', 'erase', 'proinfo'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'erase', 'boot_a'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'erase', 'boot_b'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'erase', 'system_b'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'erase', 'md1img_a'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'erase', 'md1img_b'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'erase', 'md1dsp_a'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'erase', 'md1dsp_b'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'erase', 'misc'],
                ['fastboot', 'erase', 'tee_a'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'erase', 'tee_b'],
                ['fastboot', 'flash', 'tee_b', 'tee.img'],
                ['fastboot', 'erase', 'mcupm_a'],
                ['fastboot', 'flash', 'mcupm_a', 'mcupm.img'],
                ['fastboot', 'erase', 'mcupm_b'],
                ['fastboot', 'flash', 'mcupm_b', 'mcupm.img'],
                ['fastboot', 'erase', 'medmcu_a'],
                ['fastboot', 'flash', 'medmcu_a', 'medmcu.img'],
                ['fastboot', 'erase', 'medmcu_b'],
                ['fastboot', 'flash', 'medmcu_b', 'medmcu.img'],
                ['fastboot', 'erase', 'sspm_a'],
                ['fastboot', 'flash', 'sspm_a', 'sspm.img'],
                ['fastboot', 'erase', 'sspm_b'],
                ['fastboot', 'flash', 'sspm_b', 'sspm.img'],
                ['fastboot', 'erase', 'dpm_a'],
                ['fastboot', 'flash', 'dpm_a', 'dpm.img'],
                ['fastboot', 'erase', 'dpm_b'],
                ['fastboot', 'flash', 'dpm_b', 'dpm.img'],
                ['fastboot', 'erase', 'userdata'],
                ['fastboot', 'flash', 'userdata', 'userdata.img'],
                ['fastboot', 'erase', 'vbmeta_a'],
                ['fastboot', 'flash', 'vbmeta_a', 'vbmeta.img'],
                ['fastboot', 'erase', 'vbmeta_b'],
                ['fastboot', 'flash', 'vbmeta_b', 'vbmeta.img'],
                ['fastboot', 'erase', 'expdb'],
                ['fastboot', 'erase', 'delta'],
                ['fastboot', 'erase', 'log'],
                ['fastboot', 'erase', 'db'],
                ['fastboot', 'erase', 'oemdata'],
                ['fastboot', 'flash', 'oemdata', 'oemdata.img'],
                ['fastboot', 'erase', 'oemapp_a'],
                ['fastboot', 'flash', 'oemapp_a', 'oemapp.img'],
                ['fastboot', 'erase', 'oemapp_b'],
                ['fastboot', 'flash', 'oemapp_b', 'oemapp.img']]
}

oemfactoryprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'flash', 'download:spmfw', 'spmfw.img'],
                ['fastboot', 'flash', 'download:mcupm', 'mcupm.img'],
                ['fastboot', 'flash', 'download:medmcu', 'medmcu.img'],
                ['fastboot', 'flash', 'download:sspm', 'sspm.img'],
                ['fastboot', 'flash', 'download:dpm', 'dpm.img'],
                ['fastboot', 'flash', 'download:hsmos', 'hsm_os.img'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'oem', 'nanderaseblock', '0'],
                ['fastboot', 'oem', 'nanderaseblock', '1'],
                ['fastboot', 'flash', 'nand0', 'MBR_NAND'],
                ['fastboot', 'erase', 'bl2_a'],
                ['fastboot', 'flash', 'bl2_a', 'bl2.img'],
                ['fastboot', 'erase', 'bl2_b'],
                ['fastboot', 'flash', 'bl2_b', 'bl2.img'],
                ['fastboot', 'erase', 'bl33_a'],
                ['fastboot', 'flash', 'bl33_a', 'bl33.img'],
                ['fastboot', 'erase', 'bl33_b'],
                ['fastboot', 'flash', 'bl33_b', 'bl33.img'],
                ['fastboot', 'erase', 'spm_a'],
                ['fastboot', 'flash', 'spm_a', 'spmfw.img'],
                ['fastboot', 'erase', 'spm_b'],
                ['fastboot', 'flash', 'spm_b', 'spmfw.img'],
                ['fastboot', 'erase', 'dtbo'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'erase', 'hsm_bl'],
                ['fastboot', 'flash', 'hsm_bl', 'hsm_bl.img'],
                ['fastboot', 'erase', 'hsm_os_a'],
                ['fastboot', 'flash', 'hsm_os_a', 'hsm_os.img'],
                ['fastboot', 'erase', 'hsm_os_b'],
                ['fastboot', 'flash', 'hsm_os_b', 'hsm_os.img'],
                ['fastboot', 'erase', 'boot_para'],
                ['fastboot', 'erase', 'proinfo'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'erase', 'boot_a'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'erase', 'boot_b'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'erase', 'system_b'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'erase', 'md1img_a'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'erase', 'md1img_b'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'erase', 'md1dsp_a'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'erase', 'md1dsp_b'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'erase', 'misc'],
                ['fastboot', 'erase', 'tee_a'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'erase', 'tee_b'],
                ['fastboot', 'flash', 'tee_b', 'tee.img'],
                ['fastboot', 'erase', 'mcupm_a'],
                ['fastboot', 'flash', 'mcupm_a', 'mcupm.img'],
                ['fastboot', 'erase', 'mcupm_b'],
                ['fastboot', 'flash', 'mcupm_b', 'mcupm.img'],
                ['fastboot', 'erase', 'medmcu_a'],
                ['fastboot', 'flash', 'medmcu_a', 'medmcu.img'],
                ['fastboot', 'erase', 'medmcu_b'],
                ['fastboot', 'flash', 'medmcu_b', 'medmcu.img'],
                ['fastboot', 'erase', 'sspm_a'],
                ['fastboot', 'flash', 'sspm_a', 'sspm.img'],
                ['fastboot', 'erase', 'sspm_b'],
                ['fastboot', 'flash', 'sspm_b', 'sspm.img'],
                ['fastboot', 'erase', 'dpm_a'],
                ['fastboot', 'flash', 'dpm_a', 'dpm.img'],
                ['fastboot', 'erase', 'dpm_b'],
                ['fastboot', 'flash', 'dpm_b', 'dpm.img'],
                ['fastboot', 'erase', 'userdata'],
                ['fastboot', 'flash', 'userdata', 'userdata.img'],
                ['fastboot', 'erase', 'vbmeta_a'],
                ['fastboot', 'flash', 'vbmeta_a', 'vbmeta.img'],
                ['fastboot', 'erase', 'vbmeta_b'],
                ['fastboot', 'flash', 'vbmeta_b', 'vbmeta.img'],
                ['fastboot', 'erase', 'expdb'],
                ['fastboot', 'erase', 'delta'],
                ['fastboot', 'erase', 'log'],
                ['fastboot', 'erase', 'db'],
                ['fastboot', 'erase', 'oemdata'],
                ['fastboot', 'flash', 'oemdata', 'oemdata.img'],
                ['fastboot', 'erase', 'oemapp_a'],
                ['fastboot', 'flash', 'oemapp_a', 'oemapp.img'],
                ['fastboot', 'erase', 'oemapp_b'],
                ['fastboot', 'flash', 'oemapp_b', 'oemapp.img']]
}

userprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fbWait'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'oem', 'set_active', '0']]
}

bootprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'flash', 'bl2_a', 'bl2.img'],
                ['fastboot', 'flash', 'bl33_a', 'bl33.img'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'oem', 'set_active', '0']]
}

testprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'erase', 'bl2_a'],
                ['fastboot', 'flash', 'bl2_a', 'bl2.img'],
                ['fastboot', 'erase', 'bl2_b'],
                ['fastboot', 'flash', 'bl2_b', 'bl2.img'],
                ['fastboot', 'erase', 'bl33_a'],
                ['fastboot', 'flash', 'bl33_a', 'bl33.img'],
                ['fastboot', 'erase', 'bl33_b'],
                ['fastboot', 'flash', 'bl33_b', 'bl33.img'],
                ['fastboot', 'erase', 'spm_a'],
                ['fastboot', 'flash', 'spm_a', 'spmfw.img'],
                ['fastboot', 'erase', 'spm_b'],
                ['fastboot', 'flash', 'spm_b', 'spmfw.img'],
                ['fastboot', 'erase', 'dtbo'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'erase', 'hsm_bl'],
                ['fastboot', 'flash', 'hsm_bl', 'hsm_bl.img'],
                ['fastboot', 'erase', 'hsm_os_a'],
                ['fastboot', 'flash', 'hsm_os_a', 'hsm_os.img'],
                ['fastboot', 'erase', 'hsm_os_b'],
                ['fastboot', 'flash', 'hsm_os_b', 'hsm_os.img'],
                ['fastboot', 'erase', 'proinfo'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'erase', 'boot_a'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'erase', 'boot_b'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'erase', 'system_b'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'erase', 'md1img_a'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'erase', 'md1img_b'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'erase', 'md1dsp_a'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'erase', 'md1dsp_b'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'erase', 'tee_a'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'erase', 'tee_b'],
                ['fastboot', 'flash', 'tee_b', 'tee.img'],
                ['fastboot', 'erase', 'mcupm_a'],
                ['fastboot', 'flash', 'mcupm_a', 'mcupm.img'],
                ['fastboot', 'erase', 'mcupm_b'],
                ['fastboot', 'flash', 'mcupm_b', 'mcupm.img'],
                ['fastboot', 'erase', 'medmcu_a'],
                ['fastboot', 'flash', 'medmcu_a', 'medmcu.img'],
                ['fastboot', 'erase', 'medmcu_b'],
                ['fastboot', 'flash', 'medmcu_b', 'medmcu.img'],
                ['fastboot', 'erase', 'sspm_a'],
                ['fastboot', 'flash', 'sspm_a', 'sspm.img'],
                ['fastboot', 'erase', 'sspm_b'],
                ['fastboot', 'flash', 'sspm_b', 'sspm.img'],
                ['fastboot', 'erase', 'dpm_a'],
                ['fastboot', 'flash', 'dpm_a', 'dpm.img'],
                ['fastboot', 'erase', 'dpm_b'],
                ['fastboot', 'flash', 'dpm_b', 'dpm.img'],
                ['fastboot', 'erase', 'vbmeta_a'],
                ['fastboot', 'flash', 'vbmeta_a', 'vbmeta.img'],
                ['fastboot', 'erase', 'vbmeta_b'],
                ['fastboot', 'flash', 'vbmeta_b', 'vbmeta.img'],
                ['fastboot', 'erase', 'oemapp_a'],
                ['fastboot', 'flash', 'oemapp_a', 'oemapp.img'],
                ['fastboot', 'erase', 'oemapp_b'],
                ['fastboot', 'flash', 'oemapp_b', 'oemapp.img']]
}

userdataprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'erase', 'bl2_a'],
                ['fastboot', 'flash', 'bl2_a', 'bl2.img'],
                ['fastboot', 'erase', 'bl2_b'],
                ['fastboot', 'flash', 'bl2_b', 'bl2.img'],
                ['fastboot', 'erase', 'bl33_a'],
                ['fastboot', 'flash', 'bl33_a', 'bl33.img'],
                ['fastboot', 'erase', 'bl33_b'],
                ['fastboot', 'flash', 'bl33_b', 'bl33.img'],
                ['fastboot', 'erase', 'spm_a'],
                ['fastboot', 'flash', 'spm_a', 'spmfw.img'],
                ['fastboot', 'erase', 'spm_b'],
                ['fastboot', 'flash', 'spm_b', 'spmfw.img'],
                ['fastboot', 'erase', 'dtbo'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'erase', 'hsm_bl'],
                ['fastboot', 'flash', 'hsm_bl', 'hsm_bl.img'],
                ['fastboot', 'erase', 'hsm_os_a'],
                ['fastboot', 'flash', 'hsm_os_a', 'hsm_os.img'],
                ['fastboot', 'erase', 'hsm_os_b'],
                ['fastboot', 'flash', 'hsm_os_b', 'hsm_os.img'],
                ['fastboot', 'erase', 'proinfo'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'erase', 'boot_a'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'erase', 'boot_b'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'erase', 'system_b'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'erase', 'md1img_a'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'erase', 'md1img_b'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'erase', 'md1dsp_a'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'erase', 'md1dsp_b'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'erase', 'tee_a'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'erase', 'tee_b'],
                ['fastboot', 'flash', 'tee_b', 'tee.img'],
                ['fastboot', 'erase', 'mcupm_a'],
                ['fastboot', 'flash', 'mcupm_a', 'mcupm.img'],
                ['fastboot', 'erase', 'mcupm_b'],
                ['fastboot', 'flash', 'mcupm_b', 'mcupm.img'],
                ['fastboot', 'erase', 'medmcu_a'],
                ['fastboot', 'flash', 'medmcu_a', 'medmcu.img'],
                ['fastboot', 'erase', 'medmcu_b'],
                ['fastboot', 'flash', 'medmcu_b', 'medmcu.img'],
                ['fastboot', 'erase', 'sspm_a'],
                ['fastboot', 'flash', 'sspm_a', 'sspm.img'],
                ['fastboot', 'erase', 'sspm_b'],
                ['fastboot', 'flash', 'sspm_b', 'sspm.img'],
                ['fastboot', 'erase', 'dpm_a'],
                ['fastboot', 'flash', 'dpm_a', 'dpm.img'],
                ['fastboot', 'erase', 'dpm_b'],
                ['fastboot', 'flash', 'dpm_b', 'dpm.img'],
                ['fastboot', 'erase', 'vbmeta_a'],
                ['fastboot', 'flash', 'vbmeta_a', 'vbmeta.img'],
                ['fastboot', 'erase', 'vbmeta_b'],
                ['fastboot', 'flash', 'vbmeta_b', 'vbmeta.img'],
                ['fastboot', 'erase', 'oemapp_a'],
                ['fastboot', 'flash', 'oemapp_a', 'oemapp.img'],
                ['fastboot', 'erase', 'oemapp_b'],
                ['fastboot', 'flash', 'oemapp_b', 'oemapp.img'],
                ['fastboot', 'erase', 'oemdata'],
                ['fastboot', 'flash', 'oemdata', 'oemdata.img'],
                ['fastboot', 'erase', 'userdata'],
                ['fastboot', 'flash', 'userdata', 'userdata.img']]
}

# return procedure list
def getFlashProc(product):
    try:
        ret = oemfactoryprocedures[product.upper()]
        return ret
    except:
        return None


def getFlashUserProc(product):
    try:
        ret = userprocedures[product.upper()]
        return ret
    except:
        return None

def getFlashBootProc(product):
    try:
        ret = bootprocedures[product.upper()]
        return ret
    except:
        return None

def getFlashTestProc(product):
    try:
        ret = testprocedures[product.upper()]
        return ret
    except:
        return None
    
def getFlashUserDataProc(product):
    try:
        ret = userdataprocedures[product.upper()]
        return ret
    except:
        return None
    
def getFlashSocFactoryProc(product):
    try:
        ret = socfactoryprocedures[product.upper()]
        return ret
    except:
        return None
    
def getFlashOemFactoryProc(product):
    try:
        ret = oemfactoryprocedures[product.upper()]
        return ret
    except:
        return None
