#!/usr/bin/python
import os

procedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'flash', 'download:spmfw', 'spmfw.img'],
                ['fastboot', 'flash', 'download:mcupm', 'mcupm.img'],
                ['fastboot', 'flash', 'download:medmcu', 'medmcu.img'],
                ['fastboot', 'flash', 'download:sspm', 'sspm.img'],
                ['fastboot', 'flash', 'download:dpm', 'dpm.img'],
                ['fastboot', 'flash', 'download:hsmos', 'hsm_os.img'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'erase', 'nand0'],
                ['fastboot', 'flash', 'nand0', 'MBR_NAND'],
                ['fastboot', 'flash', 'bl2', 'bl2.img'],
                ['fastboot', 'flash', 'bl33', 'bl33.img'],
                ['fastboot', 'flash', 'spm_a', 'spmfw.img'],
                ['fastboot', 'flash', 'spm_b', 'spmfw.img'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'flash', 'hsm_bl', 'hsm_bl.img'],
                ['fastboot', 'flash', 'hsm_os', 'hsm_os.img'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'flash', 'tee_b', 'tee.img'],
                ['fastboot', 'flash', 'nvram', 'nvram.ubi'],
                ['fastboot', 'flash', 'mcupm', 'mcupm.img'],
                ['fastboot', 'flash', 'medmcu', 'medmcu.img'],
                ['fastboot', 'flash', 'sspm', 'sspm.img'],
                ['fastboot', 'flash', 'dpm', 'dpm.img'],
                ['fastboot', 'flash', 'userdata', 'userdata.img']]
}

userprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fbWait'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'oem', 'set_active', '0']]
}

bootprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'flash', 'bl2', 'bl2.img'],
                ['fastboot', 'flash', 'bl33', 'bl33.img'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'oem', 'set_active', '0']]
}

testprocedures = {
    # product   : fastboot args
    'DEFAULT': [['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'hsm_bl.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'EMPTY', 'bl2.img'],
                ['fastboot', 'continue'],
                ['fbWait'],
                ['fastboot', 'flash', 'download:tz', 'tee.img'],
                ['fastboot', 'flash', 'download:bl33', 'bl33.img'],
                ['fastboot', 'oem', 'continue'],
                ['fbWait'],
                ['fastboot', 'erase', 'bl2'],
                ['fastboot', 'flash', 'bl2', 'bl2.img'],
                ['fastboot', 'erase', 'bl33'],
                ['fastboot', 'flash', 'bl33', 'bl33.img'],
                ['fastboot', 'erase', 'dtbo'],
                ['fastboot', 'flash', 'dtbo', 'combo.dtbo'],
                ['fastboot', 'erase', 'proinfo'],
                ['fastboot', 'flash', 'proinfo', 'sncfg.ubi'],
                ['fastboot', 'erase', 'boot_a'],
                ['fastboot', 'flash', 'boot_a', 'boot.img'],
                ['fastboot', 'erase', 'boot_b'],
                ['fastboot', 'flash', 'boot_b', 'boot.img'],
                ['fastboot', 'erase', 'system_a'],
                ['fastboot', 'flash', 'system_a', 'system.img'],
                ['fastboot', 'erase', 'system_b'],
                ['fastboot', 'flash', 'system_b', 'system.img'],
                ['fastboot', 'erase', 'md1img_a'],
                ['fastboot', 'flash', 'md1img_a', 'md1img.img'],
                ['fastboot', 'erase', 'md1img_b'],
                ['fastboot', 'flash', 'md1img_b', 'md1img.img'],
                ['fastboot', 'erase', 'md1dsp_a'],
                ['fastboot', 'flash', 'md1dsp_a', 'md1dsp.img'],
                ['fastboot', 'erase', 'md1dsp_b'],
                ['fastboot', 'flash', 'md1dsp_b', 'md1dsp.img'],
                ['fastboot', 'erase', 'tee_a'],
                ['fastboot', 'flash', 'tee_a', 'tee.img'],
                ['fastboot', 'erase', 'tee_b'],
                ['fastboot', 'flash', 'tee_b', 'tee.img']]
}

# return procedure list
def getFlashProc(product):
    try:
        ret = procedures[product.upper()]
        return ret
    except:
        return None


def getFlashUserProc(product):
    try:
        ret = userprocedures[product.upper()]
        return ret
    except:
        return None

def getFlashBootProc(product):
    try:
        ret = bootprocedures[product.upper()]
        return ret
    except:
        return None

def getFlashTestProc(product):
    try:
        ret = testprocedures[product.upper()]
        return ret
    except:
        return None
