SUMMARY = "HSM-IMAGE"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=411c267670838099ca82e01c7f044a7b"
SRC_URI = " file://LICENSE \
          "
WORKONSRC = "${TOPDIR}/../prebuilt/firmware/hsm"
HSM_BIN_OUT = "${WORKDIR}/out"
HSM_IMG_OUT = "${WORKDIR}/out/img"
DEPENDS = "packer-native "
SRC_URI = " file://LICENSE \
            file://hsm.json \
            file://bootloader.json \
            file://${WORKONSRC}/hsm-out.tar.gz \
          "
inherit workonsrc deploy

do_compile[nostamp] = "1"
do_deploy() {
	install -m 755 ${HSM_IMG_OUT}/bootloader.bin ${DEPLOYDIR}/hsm_bl.img
	install -m 755 ${HSM_IMG_OUT}/hsm.bin ${DEPLOYDIR}/hsm_os.img
}

addtask deploy before do_build after do_compile
do_compile() {
	echo "no source with images"
        rm -rf ${HSM_IMG_OUT}
        install -d ${HSM_IMG_OUT}
        install -m 755 ${HSM_BIN_OUT}/bootloader.bin ${HSM_IMG_OUT}/bootloader.bin
        install -m 755 ${HSM_BIN_OUT}/hsm.bin       ${HSM_IMG_OUT}/hsm.bin 
        install -m 755 ${HSM_BIN_OUT}/cert.bin      ${HSM_IMG_OUT}/cert.bin       
}



do_genheader () {
	${WORKDIR}/recipe-sysroot-native${bindir}/python-native/python2 ${WORKDIR}/recipe-sysroot-native${datadir}/packer/mipack.py -d ${HSM_IMG_OUT}/ -o ${HSM_IMG_OUT}/bootloader.bin ${WORKDIR}/bootloader.json
        ${WORKDIR}/recipe-sysroot-native${bindir}/python-native/python2 ${WORKDIR}/recipe-sysroot-native${datadir}/packer/mipack.py -d ${HSM_IMG_OUT}/ -o ${HSM_IMG_OUT}/hsm.bin ${WORKDIR}/hsm.json
}


addtask genheader before do_deploy after do_compile
