FILESEXTRAPATHS_append := ":${THISDIR}/files"

SRC_URI += "file://bootloader.json \
	file://hsm.json"

EXTRA_OEMAKE += "AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		AB_OTA_LOGIC_IN_HSM=${AB_OTA_LOGIC_IN_HSM}"

do_addcert() {
	# add secure JTAG certificate
	mkdir -p ${B}out
	touch ${B}out/cert.bin
	if [ -f "${B}src/application/bootloader/mt2735/cert/cert.bin" ]; then
		cp ${B}src/application/bootloader/mt2735/cert/cert.bin ${B}out
	fi
}

do_deploy() {
	install -m 755 ${B}out/bootloader.bin ${DEPLOYDIR}/hsm_bl.img
	install -m 755 ${B}out/hsm.bin ${DEPLOYDIR}/hsm_os.img
}

addtask addcert before do_compile after do_configure
addtask deploy before do_build after do_compile
