FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

LIC_FILES_CHKSUM = "file://COPYING;md5=bbea815ee2795b2f4230826c0c6b8814"

# don't include kernel-image to rootfs
RDEPENDS_${KERNEL_PACKAGE_NAME}-base = ""

DEPENDS += "kern-tools-native"

SRC_URI += "\
        ${@bb.utils.contains('CORE_NUM', '2', ' file://cpu_2cores.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('NAND_TYPE', 'slc', ' file://slc_nand.cfg', '', d)} \
        ${@bb.utils.contains('NAND_TYPE', 'spi', ' file://spi_nand.cfg', '', d)} \
        ${@bb.utils.contains('BOOTDEV_TYPE', 'emmc', ' file://emmc.cfg', '', d)} \
        ${@bb.utils.contains('TEE_SUPPORT', 'optee', ' file://auto2735evb_ivt_optee.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('MEMORY_SIZE', '512', ' file://memory_512mb.cfg', '', d)} \
        ${@bb.utils.contains('MEMORY_SIZE', '640', ' file://memory_640mb.cfg', '', d)} \
        ${@bb.utils.contains('MEMORY_SIZE', '768', ' file://memory_768mb.cfg', '', d)} \
        ${@bb.utils.contains('MEMORY_SIZE', '896', ' file://memory_896mb.cfg', '', d)} \
        ${@bb.utils.contains('MEMORY_SIZE', '1024', ' file://memory_1024mb.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('BUILD_TYPE', 'user', ' file://user_build.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('MTK_SMT_BUILD', 'yes', ' file://smt.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('SECURE_BOOT_ENABLE', 'yes', ' file://dm_verity.cfg', '', d)} \
	${@bb.utils.contains('IMAGE_FSTYPES', 'squashfs', ' file://rootfstype_squashfs.cfg', '', d)} \
	${@bb.utils.contains('IMAGE_FSTYPES', 'ubi', ' file://rootfstype_ubifs.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('HSM_OS_SUPPORT', 'yes', ' file://hsm.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('SGMII_SNPS_INTERFACE', 'yes', ' file://sgmii_snps.cfg', '', d)} \
        ${@bb.utils.contains('SGMII_NETSYS_INTERFACE', 'yes', ' file://sgmii_netsys.cfg', '', d)} \
"

SRC_URI += "\
        ${@bb.utils.contains('AEE_SUPPORT', 'yes', '', ' file://disable_aee.cfg', d)} \
"
#Typethree add for tcxo hw version 2023/02/03 start
#SRC_URI += "\
#        ${@bb.utils.contains('TCXO_SUPPORT', 'yes', ' file://tcxo_support.cfg', '', d)} \
#"
#Typethree add for tcxo hw version 2023/02/03 end
def find_cfg(d):
    sources=src_patches(d, True)
    sources_list=[]
    for s in sources:
        base, ext = os.path.splitext(os.path.basename(s))
        if ext and ext in [".scc", ".cfg"]:
            sources_list.append(s)
        elif base and base in 'defconfig':
            sources_list.append(s)

    return sources_list


do_configure_append () {
	merge_config.sh -m .config ${@" ".join(find_cfg(d))}
}

do_configure_prepend () {
	if [ "${MTK_SMT_BUILD}" = "yes" ]; then
		cp -rf ${TOPDIR}/../meta/meta-mediatek-mt2735/recipes-kernel/linux/files/mt2735.dtsi ${KERNEL_SRC}/arch/arm64/boot/dts/mediatek/
	fi

}
