DESCRIPTION = "Modem database file"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://lwg"
SRC_URI += "file://ltg"
SRC_URI += "file://lwctg"

S = "${WORKDIR}"

FILES_${PN} = "${datadir}/modem/db/*"

#provide shell connmand rename
DEPENDS = "util-linux-native"

do_compile[noexec] = "1"

ALLOW_EMPTY_${PN} = "1"

do_install_append() {
    if [ -s ${S}/lwg/*GUInfo* ]; then
    install -d ${D}${datadir}/modem/db
    install lwg/*GUInfo* ${D}${datadir}/modem/db/BPLGUInfo_lwg
    fi

    if [ -s ${S}/ltg/*GUInfo* ]; then
    install -d ${D}${datadir}/modem/db
    install ltg/*GUInfo* ${D}${datadir}/modem/db/BPLGUInfo_ltg
    fi

    if [ -s ${S}/lwctg/*GUInfo* ]; then
    install -d ${D}${datadir}/modem/db
    install lwctg/*GUInfo* ${D}${datadir}/modem/db/BPLGUInfo_lwctg
    install lwctg/MDDB.META* ${D}${datadir}/modem/db/
    rename .EDB _1_ulwctg_n.EDB ${D}${datadir}/modem/db/MDDB.META*.EDB
    rename .XML.GZ _1_ulwctg_n.XML.GZ ${D}${datadir}/modem/db/MDDB.META*.XML.GZ
    fi
}

