DESCRIPTION = "Modem filter file"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://lwg"
SRC_URI += "file://ltg"
SRC_URI += "file://lwctg"

S = "${WORKDIR}"

FILES_${PN} = "${datadir}/modem/filter/*"

#provide shell connmand rename
DEPENDS = "util-linux-native"

do_compile[noexec] = "1"

ALLOW_EMPTY_${PN} = "1"


do_install_append() {

    if [ -s ${S}/lwg/catcher_filter.bin ]; then
    install -d ${D}${datadir}/modem/filter
    install lwg/catcher_filter.bin ${D}${datadir}/modem/filter/catcher_filter_lwg.bin
    fi

    if [ -s ${S}/ltg/catcher_filter.bin ]; then
    install -d ${D}${datadir}/modem/filter
    install ltg/catcher_filter.bin ${D}${datadir}/modem/filter/catcher_filter_ltg.bin
    fi

    if [ -s ${S}/lwctg/catcher_filter.bin ]; then
    install -d ${D}${datadir}/modem/filter
    install lwctg/catcher_filter_*.bin ${D}${datadir}/modem/filter/
    rename catcher_filter catcher_filter_1_ulwctg_n ${D}${datadir}/modem/filter/catcher_filter_*.bin
    install lwctg/catcher_filter.bin ${D}${datadir}/modem/filter/catcher_filter_lwctg.bin
    fi
}

