DESCRIPTION = "Modem images"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

SRC_URI = "file://LICENSE"
SRC_URI += "file://lwg"
SRC_URI += "file://ltg"
SRC_URI += "file://lwctg"

S = "${WORKDIR}"

FILES_${PN} = "${datadir}/modem/images/*"

do_compile[noexec] = "1"

ALLOW_EMPTY_${PN} = "1"

do_install_append() {
    if [ -s ${S}/lwg/modem.img ] && [ -e ${S}/lwg/dsp.bin ]; then
    install -d ${D}${datadir}/modem/images
    install lwg/modem.img ${D}${datadir}/modem/images/modem_lwg.img
    install lwg/dsp.bin ${D}${datadir}/modem/images/dsp_lwg.bin
    fi

    if [ -s ${S}/ltg/modem.img ] && [ -e ${S}/ltg/dsp.bin ]; then
    install -d ${D}${datadir}/modem/images
    install ltg/modem.img ${D}${datadir}/modem/images/modem_ltg.img
    install ltg/dsp.bin ${D}${datadir}/modem/images/dsp_ltg.bin
    fi

    if [ -s ${S}/lwctg/modem.img ] && [ -e ${S}/lwctg/dsp.bin ]; then
    install -d ${D}${datadir}/modem/images
    install lwctg/modem.img ${D}${datadir}/modem/images/modem_lwctg.img
    install lwctg/dsp.bin ${D}${datadir}/modem/images/dsp_lwctg.bin
    fi

    if [ -s ${S}/lwg/modem.xml ]; then
    install -d ${D}${datadir}/modem/images
    install lwg/modem.xml ${D}${datadir}/modem/images/modem_lwg.xml
    fi

    if [ -s ${S}/ltg/modem.xml ]; then
    install -d ${D}${datadir}/modem/images
    install ltg/modem.xml ${D}${datadir}/modem/images/modem_ltg.xml
    fi

    if [ -s ${S}/lwctg/modem.xml ]; then
    install -d ${D}${datadir}/modem/images
    install lwctg/modem.xml ${D}${datadir}/modem/images/modem_lwctg.xml
    fi
}

