inherit deploy u-boot-fitimage

UBOOT_SRC = "${TOPDIR}/../src/bsp/u-boot"
LIC_FILES_CHKSUM = "file://${UBOOT_SRC}/Licenses/README;md5=025bf9f768cbcb1a165dbe1a110babfb"
PV = "v2014.04-rc1+git+src"

SECTION = "bootloaders"
PROVIDES = "virtual/bootloader"

LICENSE = "GPLv2+"

PACKAGE_ARCH = "${MACHINE_ARCH}"

PROJECT = "mtk"

# Some versions of u-boot use .bin and others use .img.  By default use .bin
# but enable individual recipes to change this value.
UBOOT_SUFFIX ??= "bin"
UBOOT_IMAGE ?= "u-boot-${PROJECT}.${UBOOT_SUFFIX}"
UBOOT_BINARY ?= "u-boot.${UBOOT_SUFFIX}"
UBOOT_FIT_IMAGE ?= "u-boot-fit.${UBOOT_SUFFIX}"
UBOOT_MAKE_TARGET ?= "all"


do_compile () {
	cd ${UBOOT_SRC}
	make clobber
	make V=1 -f Makefile
	cd -
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${UBOOT_SRC}/${UBOOT_FIT_IMAGE} ${DEPLOYDIR}/${UBOOT_FIT_IMAGE}
}

addtask deploy before do_build after do_assemble_fitimage

