require u-boot-common_${PV}.inc
inherit deploy u-boot-fitimage

UBOOT_SRC = "${TOPDIR}/../src/bsp/u-boot-201611"
UBOOT_OUT = "${WORKDIR}/out"

PROVIDES = "virtual/bootloader"

PACKAGE_ARCH = "${MACHINE_ARCH}"

PROJECT = "mtk"

# Some versions of u-boot use .bin and others use .img.  By default use .bin
# but enable individual recipes to change this value.
UBOOT_SUFFIX ??= "bin"
UBOOT_IMAGE ?= "u-boot-${PROJECT}.${UBOOT_SUFFIX}"
UBOOT_BINARY ?= "u-boot.${UBOOT_SUFFIX}"
UBOOT_FIT_IMAGE ?= "u-boot-fit.${UBOOT_SUFFIX}"
UBOOT_MAKE_TARGET ?= "all"

EXTRA_OEMAKE = 'CROSS_COMPILE="${TARGET_PREFIX}" KBUILD_OUTPUT="${UBOOT_OUT}" STRIP=true V=1'

do_compile () {
	cd ${UBOOT_SRC}
	oe_runmake mrproper
	oe_runmake mt8521_defconfig
	oe_runmake -f Makefile
	cd -
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${UBOOT_OUT}/${UBOOT_FIT_IMAGE} ${DEPLOYDIR}/${UBOOT_FIT_IMAGE}
}

addtask deploy before do_build after do_assemble_fitimage

