inherit native

DESCRIPTION = "ARM's Baremetal GCC"

LICENSE = "GPL-2.0 & GPL-3.0 & GPL-2.0-with-GCC-exception & GPL-3.0-with-GCC-exception & LGPL-2.0 & LGPL-2.1 & LGPL-3.0 & MIT"
LIC_FILES_CHKSUM = "file://share/doc/gcc-arm-none-eabi/license.txt;md5=cba77c7fde3ed13e866b04a2f3d93918"
SRC_URI = "https://launchpad.net/gcc-arm-embedded/4.8/4.8-2014-q3-update/+download/gcc-arm-none-eabi-4_8-2014q3-20140805-linux.tar.bz2;name=gcc-arm-none"
SRC_URI[gcc-arm-none.md5sum] = "acc8c8ff45f8801e2155934214309a87"
GCC_ARM_NONE_TOOLCHAIN_VERSION = "4_8-2014q3"
GCC_ARM_NONE_TOOLCHAIN = "gcc-arm-none-eabi"

S = "${WORKDIR}/${GCC_ARM_NONE_TOOLCHAIN}-${GCC_ARM_NONE_TOOLCHAIN_VERSION}"
B = "${WORKDIR}/${GCC_ARM_NONE_TOOLCHAIN}-${GCC_ARM_NONE_TOOLCHAIN_VERSION}"


#UNINATIVE_LOADER = ""

do_install () {
	install -d ${D}/${bindir}/${GCC_ARM_NONE_TOOLCHAIN}
	cp -r ${S}/. ${D}/${bindir}/${GCC_ARM_NONE_TOOLCHAIN}
	rm -rf ${D}/${bindir}/${GCC_ARM_NONE_TOOLCHAIN}/oe-logs
	rm -rf ${D}/${bindir}/${GCC_ARM_NONE_TOOLCHAIN}/oe-workdir
	rm -rf ${D}/${bindir}/${GCC_ARM_NONE_TOOLCHAIN}/singletask.lock
}


INSANE_SKIP_${PN} = "already-stripped"

FILES_${PN} = "${bindir}/${GCC_ARM_NONE_TOOLCHAIN}/*"
