SNCFG_DIR_IMAGE_SIZE ?= "4096"
SNCFG_DIR_IMAGE_PATH = "${DEPLOY_DIR_IMAGE}/sncfg"
IMAGE_FSTYPES_NO_WHITESPACE="$(echo "${IMAGE_FSTYPES}" | tr -d '[:space:]')"
USERDATA_FS_PARTITION = "sncfg_fs.ubi"
USERDATA_PARTITION = "sncfg.ubi"
DEPENDS += "mtd-utils-native coreutils-native"
mk_sncfg_image() {

	rm -rf ${SNCFG_DIR_IMAGE_PATH}
	mkdir -p ${SNCFG_DIR_IMAGE_PATH}
	if [ -f ${DEPLOY_DIR_IMAGE}/ff.bin ]; then
		cp ${DEPLOY_DIR_IMAGE}/ff.bin ${SNCFG_DIR_IMAGE_PATH}/configpack1
		cp ${DEPLOY_DIR_IMAGE}/ff.bin ${SNCFG_DIR_IMAGE_PATH}/configpack2
		truncate -s 256K ${SNCFG_DIR_IMAGE_PATH}/configpack1
		truncate -s 256K ${SNCFG_DIR_IMAGE_PATH}/configpack2
	fi
	if [ -f ${DEPLOY_DIR_IMAGE}/fc-dongle.bin ]; then
		cp ${DEPLOY_DIR_IMAGE}/fc-dongle.bin ${SNCFG_DIR_IMAGE_PATH}/factoryconfig
		truncate -s 256K ${SNCFG_DIR_IMAGE_PATH}/factoryconfig
	fi

	if [ "${TARGET_PLATFORM}" = "mt2731" ]; then
		touch ${SNCFG_DIR_IMAGE_PATH}/nvram
		truncate -s 2048K ${SNCFG_DIR_IMAGE_PATH}/nvram
	fi

	touch ${SNCFG_DIR_IMAGE_PATH}/proinfo
	truncate -s 1536K ${SNCFG_DIR_IMAGE_PATH}/proinfo

  if test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ubi" || test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "squashfs"; then
	echo \[ubifs\] > ubinize.cfg
	echo mode=ubi >> ubinize.cfg
	echo image=${DEPLOY_DIR_IMAGE}/${USERDATA_FS_PARTITION} >> ubinize.cfg
	echo vol_id=0 >> ubinize.cfg
	echo vol_size=4096KiB
	echo vol_type=dynamic >> ubinize.cfg
	echo vol_name=sncfg >> ubinize.cfg
	echo vol_flags=autoresize >> ubinize.cfg
	echo dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${USERDATA_FS_PARTITION} seek=${SNCFG_DIR_IMAGE_SIZE} count=0 bs=1k
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${USERDATA_FS_PARTITION} seek=${SNCFG_DIR_IMAGE_SIZE} count=0 bs=1k
	echo mkfs.ubifs -r ${SNCFG_DIR_IMAGE_PATH} ${MKUBIFS_CONFIG_ARGS} -o ${DEPLOY_DIR_IMAGE}/${USERDATA_FS_PARTITION}
	mkfs.ubifs -r ${SNCFG_DIR_IMAGE_PATH} ${MKUBIFS_CONFIG_ARGS} -o ${DEPLOY_DIR_IMAGE}/${USERDATA_FS_PARTITION}
	echo ubinize -o ${USERDATA_PARTITION} ${UBINIZE_ARGS} ubinize.cfg
	ubinize -o ${USERDATA_PARTITION} ${UBINIZE_ARGS} ubinize.cfg
	cp ${USERDATA_PARTITION} ${DEPLOY_DIR_IMAGE}/${USERDATA_PARTITION}
  elif test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ext4"; then
	STATE_PARTITION="sncfg.ext4"
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} seek=${SNCFG_DIR_IMAGE_SIZE} count=0 bs=1k
	mkfs.ext4 -F -i 4096 ${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} -d ${SNCFG_DIR_IMAGE_PATH}
	else
	echo "No method to make ${IMAGE_FSTYPES_NO_WHITESPACE} type state image"
  fi
}

ROOTFS_POSTPROCESS_COMMAND += " mk_sncfg_image;"


