# Implement blacklist/whitelist functionality for alternative toolchains
# Based on the oe-core blacklist bbclass
#
# To add a blacklisted package:
#   TCBLACKLIST[pn] = 'toolchain'
#
# To blacklist everything, and whitelist a package:
#   TCBLACKLIST = 'toolchain'
#   TCWHITELIST[pn] = 'toolchain'

include conf/toolchain-blacklist.conf

python () {
    tc = d.getVar('TOOLCHAIN', True)
    pn = d.getVar('PN', True)
    blacklist = d.getVar('TCBLACKLIST', True)
    whitelist = d.getVarFlag('TCWHITELIST', pn, True)
    inherit_arc = bb.data.inherits_class('toolchain-arc', d)

    if inherit_arc and (tc != blacklist or not whitelist or whitelist != tc):
        raise bb.parse.SkipPackage("Recipe '%s' is blacklisted for the '%s' toolchain" % (pn, tc))
}
