#!/bin/sh

echo "---core handler tag log start---"

CURTIME=`date "+%Y-%m-%d-%H%M%S"`
SDDIR="/run/media/mmcblk1p1"
PNAME=$1
PID=$2
CURNAME=assert_${PNAME}_${CURTIME}
if [ -d ${SDDIR} ]; then
	COREFILE=${SDDIR}/core_${PNAME}_${PID}_${CURTIME}
	cat > ${COREFILE}
else
	COREFILE=/tmp/core_${PNAME}_${PID}
	cat > ${COREFILE}
fi

mkdir ${SDDIR}/${CURNAME}
cp -rf ${COREFILE} ${SDDIR}/${CURNAME}/core_${PNAME}_${PID}
cp -rf ${SDDIR}/syslog.log* ${SDDIR}/${CURNAME}/
dmesg > ${SDDIR}/${CURNAME}/kernel.log
cp -rf ${SDDIR}/tcpdump.cap* ${SDDIR}/${CURNAME}/
cp -rf ${SDDIR}/mtklog/mdlog1 ${SDDIR}/${CURNAME}/
sync
tar -zcvf ${SDDIR}/${CURNAME}.tgz ${SDDIR}/${CURNAME}
rm -rf ${SDDIR}/${CURNAME}

echo "---core handler tag log done---"


